/*ident	"@(#)C++env:incl-master/proto-headers/malloc.h	1.1" */

#ifndef __MALLOC_H
#define __MALLOC_H

/* This macro is introduced for the sole purpose of making it possible to 
*  build cfront 2.0b6.1 and later versions with earlier versions of cfront.
*/
#ifndef __HAVE_SIZE_T
#define __HAVE_SIZE_T
#endif

#ifndef __STDDEF_H
#include <stddef.h>
#endif

#define calloc ______calloc
#define realloc ______realloc
#define malloc ______malloc
#define mallopt ______mallopt
#define free ______free
#define cfree ______cfree

/* --------------------------------------------------- */
/* | Copyright (c) 1986 MIPS Computer Systems, Inc.  | */
/* | All Rights Reserved.                            | */
/* --------------------------------------------------- */
/* $Header: malloc.h,v 1.7 88/01/22 13:33:19 dce Exp $ */

#ifndef	_MALLOC_
#define	_MALLOC_	1


/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*
	Constants defining mallopt operations
*/
#define M_MXFAST	1	/* set size of blocks to be fast */
#define M_NLBLKS	2	/* set number of block in a holding block */
#define M_GRAIN		3	/* set number of sizes mapped to one, for
				   small blocks */
#define M_KEEP		4	/* retain contents of block after a free until
				   another allocation */
/*
	structure filled by 
*/
struct mallinfo  {
	int arena;	/* total space in arena */
	int ordblks;	/* number of ordinary blocks */
	int smblks;	/* number of small blocks */
	int hblks;	/* number of holding blocks */
	int hblkhd;	/* space in holding block headers */
	int usmblks;	/* space in small blocks in use */
	int fsmblks;	/* space in free small blocks */
	int uordblks;	/* space in ordinary blocks in use */
	int fordblks;	/* space in free ordinary blocks */
	int keepcost;	/* cost of enabling keep option */
};	

char *malloc();
void free();
char *realloc();
int mallopt();
struct mallinfo mallinfo();

#endif
 

#undef malloc
#undef free
#undef realloc
#undef mallopt
#undef calloc
#undef cfree

extern "C" {
	char *malloc(size_t);
	void free(void*);
	void cfree(void*);
	char *realloc(void*, size_t);
	char *calloc(unsigned, size_t);
	int mallopt(int, int);
	struct mallinfo mallinfo(int);
}

#endif
