/*ident	"@(#)C++env:incl-master/proto-headers/ldfcn.h	1.1" */

#ifndef __LDFCN_H
#define __LDFCN_H

#define ftell ______ftell
#define fgets ______fgets
#define ldopen ______ldopen
#define ldaopen ______ldaopen
#define ldaclose ______ldaclose
#define ldahread ______ldahread
#define ldclose ______ldclose
#define ldfhread ______ldfhread
#define ldlinit ______ldlinit
#define ldlitem ______ldlitem
#define ldlread ______ldlread
#define ldlseek ______ldlseek
#define ldnlseek ______ldnlseek
#define ldnrseek ______ldnrseek
#define ldnshread ______ldnshread
#define ldnsseek ______ldnsseek
#define ldohseek ______ldohseek
#define ldrseek ______ldrseek
#define ldshread ______ldshread
#define ldsseek ______ldsseek
#define ldtbread ______ldtbread
#define ldtbseek ______ldtbseek
#define ldtbindex ______ldtbindex
#define ldgetname ______ldgetname
#define sgetl ______sgetl
#define sputl ______sputl

#ifndef FILHDR
#       include <filehdr.h>
#endif
#ifndef __STDIO_H
#       include <stdio.h>
#endif

/* --------------------------------------------------- */
/* | Copyright (c) 1986 MIPS Computer Systems, Inc.  | */
/* | All Rights Reserved.                            | */
/* --------------------------------------------------- */
/* $Header: ldfcn.h,v 1031.2 88/05/16 14:39:51 bettina Exp $ */

/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*
 *	The following two declarations appear in the IH versions of
 *	"stdio.h" but do not appear in the normal 1.2 versions.
 */
#ifdef __mips__
long ftell();
char *fgets();
#endif

#ifndef LDFILE
struct	ldfile {
	int		_fnum_;	/* so each instance of an LDFILE is unique */
	FILE		*ioptr;	/* system I/O pointer value */
	long		offset;	/* absolute offset to the start of the file */
	FILHDR		header;	/* the file header of the opened file */
#ifdef __mips__
	pCHDRR		pchdr;  /* pointer to the symbol table */
	long		lastindex; /* index of last symbol accessed */
	unsigned short	type;	/* indicator of the type of the file */
	unsigned	fswap : 1;	/* if set, we must swap */
	unsigned	fBigendian : 1;	/* if set, we must swap aux for the
					 * last retrieved symbol
					 */
#else
	unsigned short	type;		/* indicator of the type of the file */
#endif
};


/*
	provide a structure "type" definition, and the associated
	"attributes"
*/

#define	LDFILE		struct ldfile
#define IOPTR(x)	x->ioptr
#define OFFSET(x)	x->offset
#define TYPE(x)		x->type
#define	HEADER(x)	x->header
#define LDFSZ		sizeof(LDFILE)
#ifdef __mips__
#define PSYMTAB(x)	x->pchdr
#define SYMTAB(x)	(ldreadst(x, -1), x->pchdr)
#define SYMHEADER(x)	x->pchdr->hdr
#define PFD(x)		x->pchdr->pfd
#define LDSWAP(x)	x->fswap
#define LDAUXSWAP(x,ifd) (PFD(x)[ifd].fBigendian != x->fBigendian)
#define LDERROR(x,y,z)  fprintf(stderr,"libmld: x:"); fprintf (stderr, y, z);
#endif

/*
	define various values of TYPE(ldptr)
*/

#define ARTYPE 	0177545
#define ISARCHIVE(x) ((x) == ARTYPE)

/*
	define symbolic positioning information for FSEEK (and fseek)
*/

#define BEGINNING	0
#define CURRENT		1
#define END		2

/*
	define a structure "type" for an archive header
*/

typedef struct
{
	char ar_name[16];
	long ar_date;
	int ar_uid;
	int ar_gid;
	long ar_mode;
	long ar_size;
} archdr;

#define	ARCHDR	archdr
#define ARCHSZ	sizeof(ARCHDR)


/*
	define some useful symbolic constants
*/

#define SYMTBL	0	/* section nnumber and/or section name of the Symbol Table */

#define	SUCCESS	 1
#define	CLOSED	 1
#define	FAILURE	 0
#define	NOCLOSE	 0
#define	BADINDEX	-1L

#define	OKFSEEK	0

/*
	define macros to permit the direct use of LDFILE pointers with the
	standard I/O library procedures
*/

LDFILE *ldopen();
LDFILE *ldaopen();
#ifdef __mips__
LDFILE *ldinitheaders();
#endif

#define GETC(ldptr)	getc(IOPTR(ldptr))
#define GETW(ldptr)	getw(IOPTR(ldptr))
#define FEOF(ldptr)	feof(IOPTR(ldptr))
#define FERROR(ldptr)	ferror(IOPTR(ldptr))
#define FGETC(ldptr)	fgetc(IOPTR(ldptr))
#define FGETS(s,n,ldptr)	fgets(s,n,IOPTR(ldptr))
#define FILENO(ldptr)	fileno(IOPTR(ldptr))
#define FREAD(p,s,n,ldptr)	fread(p,s,n,IOPTR(ldptr))
#define FSEEK(ldptr,o,p)	fseek(IOPTR(ldptr),(p==BEGINNING)?(OFFSET(ldptr)+o):o,p)
#define FTELL(ldptr)	ftell(IOPTR(ldptr))
#define FWRITE(p,s,n,ldptr)       fwrite(p,s,n,IOPTR(ldptr))
#define REWIND(ldptr)	rewind(IOPTR(ldptr))
#define SETBUF(ldptr,b)	setbuf(IOPTR(ldptr),b)
#define UNGETC(c,ldptr)		ungetc(c,IOPTR(ldptr))
#ifndef __mips__
#define STROFFSET(ldptr)	(HEADER(ldptr).f_symptr + HEADER(ldptr).f_nsyms * 18) /* 18 == SYMESZ */
#else
#define STROFFSET(ldptr)	(SYMHEADER(ldptr).cbSsOffset)
#endif
#endif
 

#undef ldlinit
#undef sgetl
#undef ldtbread
#undef ldrseek
#undef ldnrseek
#undef ldlread
#undef ldaopen
#undef ldahread
#undef ldgetname
#undef ftell
#undef ldfhread
#undef ldtbseek
#undef ldsseek
#undef ldnsseek
#undef ldshread
#undef ldnshread
#undef ldaclose
#undef ldnlseek
#undef ldlseek
#undef ldopen
#undef ldlitem
#undef fgets
#undef ldtbindex
#undef ldclose
#undef ldohseek
#undef sputl

#ifndef SYMENT
#	include <syms.h>
#endif
#ifndef LINENO
#	include <linenum.h>
#endif
#ifndef SCNHDR
#	include <scnhdr.h>
#endif

extern "C" {
	int ldahread(LDFILE*, ARCHDR*);
	int ldclose(LDFILE*);
	int ldaclose(LDFILE*);
        int ldfhread(LDFILE*, FILHDR*);
	char* ldgetname(LDFILE*, SYMENT*);
	int ldlread(LDFILE*, long, unsigned short, LINENO*);
	int ldlinit(LDFILE*, long);
	int ldlitem(LDFILE*, unsigned short, LINENO*);
	int ldlseek(LDFILE*,unsigned short);
	int ldnlseek(LDFILE*, const char*);
	int ldohseek(LDFILE*);
	LDFILE *ldopen(char*, LDFILE*);
	LDFILE *ldaopen(const char*, LDFILE*);
	int ldrseek(LDFILE*, unsigned short);
	int ldnrseek(LDFILE*, const char*);
	int ldshread(LDFILE*, unsigned short, SCNHDR*);
	int ldnshread(LDFILE*, const char*, SCNHDR*);
	int ldsseek(LDFILE*, unsigned short);
	int ldnsseek(LDFILE*, const char*);
	long ldtbindex(LDFILE*);
	int ldtbread(LDFILE*, long, SYMENT*);
	int ldtbseek(LDFILE*);
	long sgetl(const char*);
	void sputl(long, char*);
}

#endif
