/*ident	"@(#)C++env:incl-master/proto-headers/dirent.h	1.2" */

#ifndef __DIRENT_H
#define __DIRENT_H

#define opendir ______opendir
#define readdir ______readdir
#define telldir ______telldir
#define seekdir ______seekdir
#define closedir ______closedir

/* --------------------------------------------------- */
/* | Copyright (c) 1986 MIPS Computer Systems, Inc.  | */
/* | All Rights Reserved.                            | */
/* --------------------------------------------------- */
/* $Header: dirent.h,v 1.9 88/01/22 13:32:49 dce Exp $ */

#ifndef	_DIRENT_
#define	_DIRENT_	1



/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#define MAXNAMLEN	255		/* maximum filename length */
#define DIRBUF		4096		/* buffer size for fs-indep. dirs */


typedef struct
	{
	int	dd_fd;			/* file descriptor */
	int	dd_loc;			/* offset in block */
	int	dd_size;		/* amount of valid data */
	char	*dd_buf;		/* directory block */
	}	DIR;			/* stream data from opendir() */

extern DIR		*opendir();
extern struct dirent	*readdir();
extern long		telldir();
extern void		seekdir();
extern int		closedir();

#define rewinddir( dirp )	seekdir( dirp, 0L )
#include <sys/dirent.h>

#endif
 

#undef opendir
#undef telldir
#undef closedir
#undef readdir
#undef seekdir

extern "C" {
	DIR *opendir(const char*);
	struct dirent *readdir(DIR*);
	long telldir(DIR*);
	void seekdir(DIR*, long);
	void closedir(DIR*);
#ifndef rewinddir
	void rewinddir(DIR*);
#endif
}

#endif
