/*
 * |-----------------------------------------------------------|
 * | Copyright (c) 1990 MIPS Computer Systems, Inc.            |
 * | All Rights Reserved                                       |
 * |-----------------------------------------------------------|
 * |          Restricted Rights Legend                         |
 * | Use, duplication, or disclosure by the Government is      |
 * | subject to restrictions as set forth in                   |
 * | subparagraph (c)(1)(ii) of the Rights in Technical        |
 * | Data and Computer Software Clause of DFARS 52.227-7013.   |
 * |         MIPS Computer Systems, Inc.                       |
 * |         928 Arques Avenue                                 |
 * |         Sunnyvale, CA 94086                               |
 * |-----------------------------------------------------------|
 */
/* $Header: ttyent.h,v 1.2.2.2 90/05/07 20:09:50 wje Exp $ */
#ifndef BSD43_
#    include <bsd43/bsd43_.h>
#endif


struct	bsd43_(ttyent) { /* see getttyent(3) */
	char	*ty_name;	/* terminal device name */
	char	*ty_getty;	/* command to execute, usually getty */
	char	*ty_type;	/* terminal type for termcap (3X) */
	int	ty_status;	/* status flags (see below for defines) */
	char 	*ty_window;	/* command to start up window manager */
	char	*ty_comment;	/* usually the location of the terminal */
};

#define BSD43_TTY_ON	0x1	/* enable logins (startup getty) */
#define BSD43_TTY_SECURE	0x2	/* allow root to login */

extern struct bsd43_(ttyent) *bsd43_(getttyent)();
extern struct bsd43_(ttyent) *bsd43_(getttynam)();

/*----- NUMIPS: STRIP MACRO PREFIXES (BEGIN) ---------------------------------*/
/* 
 * Strip off "BSD43_" and "bsd43_" for use with standard BSD code.
 * (GENERATED AUTOMATICALLY -- DON'T EDIT BY HAND)
 */
#ifdef __SYSTYPE_BSD43__
#   define TTY_ON BSD43_TTY_ON
#   define TTY_SECURE BSD43_TTY_SECURE
#endif
/*----- NUMIPS: STRIP MACRO PREFIXES (END) -----------------------------------*/


