/*
 *   Univac U100 line protocol emulator.
 */

#define	NO	0
#define	YES	1
#define NUV	4		/* number of pseudo-stations */
#define UVHOG	256		/* maximum queued output per user */
#define UVIHWM	512		/* max queued input per user */
#define UVILWM	32		/* min queued input per user */
#define UOBUFS	256		/* size of host output buffer */


/*
 * Host message types
 */
#define M_NULL		(-1)
#define M_TEXT		0
#define M_POLL		1
#define M_APOLL		2
#define M_STAT		3
#define M_ASTAT		4
#define M_DNAK		5

/*
 * Station response types
 */
#define R_NULL		(-1)
#define	R_TEXT		0
#define	R_TRAFFIC	1
#define	R_ACK		2
#define R_EOT		3
#define	R_DENQ		4
#define	R_AGAIN		5
#define R_WABT		6
#define R_THRU		7

/*
 * ASCII characters
 */
#define	NUL	'\000'
#define	SOH	'\001'
#define	STX	'\002'
#define	ETX	'\003'
#define	ENQ	'\005'
#define	BEL	'\007'
#define	DLE	'\020'
#define DC1	'\021'
#define	DC3	'\023'
#define	NAK	'\025'
#define	SYN	'\026'
#define	EOM	'\031'
#define DEL	'\177'

/*
 * General polling addresses
 */
#define GSID	'P'		/* general site id */
#define GDID	'p'		/* general device id */

/*
 *   Last message sent Polling address
 */
#define	OSOH	(uv[0].uv_obuf[0])
#define	ORID	(uv[0].uv_obuf[1])
#define	OSID	(uv[0].uv_obuf[2])
#define	ODID	(uv[0].uv_obuf[3])


/*
 * Information about a single pseudo-terminal station
 */
struct station {
	char	st_trid;		/* communication address */
	char	st_tsid;
	char	st_tdid;
	struct	clist	st_inq;		/* input to user from host */
	struct	clist	st_outq;	/* output from user to host */
	int	st_msgcount;		/* count of lines in outq */
	int	st_state;		/* internal state */
};

/*
 * Information about pseudo-multiplexor line
 */
struct	univac	{
	struct	tty	*uv_line;	/* tty structure of line device */
	int	uv_nactive;		/* number of active stations */
	char	uv_rid;			/* poll address */
	char	uv_sid;
	char	uv_did;
	char	*uv_text;		/* start of text part in ibuf */
	int	uv_tlen;		/* length of text part of ibuf */
	char	uv_obuf[UOBUFS];	/* output buffer */
	int	uv_olen;		/* length of message in output buffer */
	char	uv_qbuf[32];		/* separate output buffer for DENQ response */
};
