h06468
s 00266/00000/00000
d D 1.1 82/08/02 16:27:39 cecily 1 0
e
u
U
t
T
I 1
/*
 * Sanders phototypesetter emulator
 *	Input	- output from 'troff | pt | order'
 *	Output	- control codes for Sanders
 * If an argument is given, prints in debug format instead of real Sanders
 * escape codes
 */
#include <stdio.h>

#define XUNIT		(1000*432)
#define YUNIT		(10000*144)

#define XFACTOR		1000
#define SXFACTOR	432
#define YFACTOR		10000
#define SYFACTOR	(35*144)

#define MAXHOR		2000
#define MAXHORCOUNT	19
#define	BOLDMOTION	3		/* troff motion between fake bold chars */

int	pagelength	= 11*YUNIT;
int	pagewidth	= 8*XUNIT;

extern int	width2[], width3[];
int	fontmap[4] = { 2, 3, 2, 2 };
int	*widthtab[4] = { width2, width3, width2, width2 };

int	ch, size, font, esc, lead;
int	xpos;
int	ypos = -31*YFACTOR;	/* compensate for initial vertical space */
int     sxpos, sypos;
int	lastch;			/* last char printed */
int	boldlead;		/* adjusted bold motion */
int	startline = 1;
int	horcount;
int	currentfont = 0;

int	debug = 0;

main(argc, argv)
char **argv;
{
	if (argc > 1)
		debug = 1;
	if (! debug) {
		/*
		 * Initialize Sanders:
		 *	Initialize
		 *	Font 2
		 *	Left margin 1 mil
		 *	Line height 0
		 *	Line length 10 inches
		 *	Page length > 12 inches
		 *	Ribbon Usage: 1
		 */
		printf("\033\032I");
		printf("\033aB");
		printf("\033f@@A");
		printf("\033k@@");
		printf("\033eB\\P");
		printf("\033iC@@");
		printf("\033rA");
	}
	while (getline()) {
		boldadjust();
		if (checkend())		/* troff finished ? */
			break;

		vertical();
		horizontal();
		if (font != currentfont)
			changefonts();
		print();
		if (boldlead)  {
			lead = boldlead;
			boldlead = 0;
			vertical();
			}
	}
	endline();
	if (!debug) {
		/* Clear Sanders for next unwary user */
		printf("\033\032I");
	}
}

getline()
{
	return(scanf("%d %d %d %d %d\n", &ch, &size, &font, &esc, &lead) == 5);
}

/*
 *   if this char and last char are the same, and last motion
 *   is small (BOLDMOTION), then make a small vertical movement
 *   as well.
 */
boldadjust()
{
	boldlead = 0;
	if (ch != lastch)  {
		lastch = ch;
		return;
		}

	if (esc != BOLDMOTION  ||  lead != 0)
		/* non bold char */
		return;

	/* make fine vert. motion, and reset by adjusting 'lead' */
	lead = 0;
	lead = -lead;
	vertical();
	boldlead = -lead;
	lead = 0;

	return;
}

vertical()
{
	register offset;

	if (lead == 0)
		return;
	endline();
	ypos += lead*YFACTOR;
	offset = (ypos - sypos)/SYFACTOR;
	sypos += offset*SYFACTOR;
	if (sypos < 0) {
		fprintf(stderr, "Move past top of page?\n");
		exitsrc/cmd/troff/filters/s.ftHI8.c                                                                        444       3       3         2675  2752704230  11475                                                                                                                                                                                                                                                                                                                                                                      h58226
s 00194/00000/00000
d D 1.1 82/08/02 16:26:30 cecily 1 0
e
u
U
t
T
I 1
char	ftHI[256-32] = {
15,	/*   */
14,	/* ! */
15,	/* " */
20,	/* # */
17,	/* $ */
23,	/* % */
19,	/* & */
8,	/* ' */
12,	/* ( */
13,	/* ) */
12,	/* * */
15,	/* + */
8,	/* , */
8,	/* - */
8,	/* . */
8,	/* / */
8,	/* 0 */
8,	/* 1 */
8,	/* 2 */
8,	/* 3 */
8,	/* 4 */
8,	/* 5 */
8,	/* 6 */
8,	/* 7 */
8,	/* 8 */
8,	/* 9 */
8,	/* : */
8,	/* ; */
8,	/* < */
8,	/* = */
8,	/* > */
8,	/* ? */
8,	/* @ */
8,	/* A */
8,	/* B */
8,	/* C */
8,	/* D */
8,	/* E */
8,	/* F */
8,	/* G */
8,	/* H */
8,	/* I */
8,	/* J */
8,	/* K */
8,	/* L */
8,	/* M */
8,	/* N */
8,	/* O */
8,	/* P */
8,	/* Q */
8,	/* R */
8,	/* S */
8,	/* T */
8,	/* U */
8,	/* V */
8,	/* W */
8,	/* X */
8,	/* Y */
8,	/* Z */
8,	/* [ */
8,	/* \ */
8,	/* ] */
8,	/* ^ */
8,	/* _ */
8,	/* ` */
8,	/* a */
8,	/* b */
8,	/* c */
8,	/* d */
8,	/* e */
8,	/* f */
8,	/* g */
8,	/* h */
8,	/* i */
8,	/* j */
8,	/* k */
8,	/* l */
8,	/* m */
8,	/* n */
8,	/* o */
8,	/* p */
8,	/* q */
8,	/* r */
8,	/* s */
8,	/* t */
8,	/* u */
8,	/* v */
8,	/* w */
8,	/* x */
8,	/* y */
8,	/* z */
8,	/* { */
8,	/* | */
8,	/* } */
8,	/* ~ */
6,
8,
0,
0,
8,
8,
0,
0,
0,
8,
16,
16,
16,
24,
24,
0,
0,
0,
0,
8,
8,
8,
0,
3,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
