h49208
s 00116/00000/00000
d D 1.1 82/08/02 16:06:08 cecily 1 0
e
u
U
t
T
I 1
/*
 * MSM disk driver - 67MB and 256MB
 */

#include <sys/param.h>
#include <sys/inode.h>
#include "saio.h"

#define NBPC67  (32*5)          /* blocks per cylinder - 67MB */
#define NBPC256 (32*19)         /* blocks per cylinder - 256MB */
#define NBPT	32		/* blocks per track */

#define	ALTBSY	0x20
#define	UNS	0x10
#define UNREADY	0x08
#define	SINC	0x02
#define	OFFL	0x01

#define	DISABLE	0x80
#define ENABLE	0x40
#define	DISARM	0xc0
#define SETHEAD	0x20
#define	SETCYL	0x10
#define	SEEK	0x02
#define RELEASE	0xb0

#define	CNTL_UNRCV	0xc1
#define	CYL_OV		0x10
#define IDLE		0x02

#define CREAD            0x01
#define CWRITE           0x02
#define CRESET           0x08

#define	STOP	0x48
#define	GO	0x50
#define	READ_GO	0x70
#define SELCHBSY	0x08

char    msmaddr[4]      = { 0xfc, 0xfd, 0xfe, 0xff };
char    msmcntl         = 0xfb;
char    msmselch        = 0xf1;

static int      curcntl;        /* controller address for msmidle */

msmstrategy(io, func, nbpc)
register struct iob *io;
{
	register drive, cntl, selch, stat;
	register bn, tn, cn, sn;

	if ((drive = io->i_deva) == 0) drive = msmaddr[io->i_unit];
	if ((cntl = io->i_cntl) == 0) cntl = msmcntl;
	if ((selch = io->i_selch) == 0) selch = msmselch;
	curcntl = cntl;
	cn = io->i_bn / nbpc;
	bn = io->i_bn % nbpc;
	tn = bn / NBPT;
	sn = (bn % NBPT) << 1;
	msmidle();
	while (ss(drive) & ALTBSY) ;
	wh(drive, cn);
	msmidle();
	oc(drive, SETCYL | DISARM) ;
	msmidle();
	oc(drive, SEEK);
	msmidle();
	while ((stat=ss(drive)) & UNREADY) ;
	if (stat & (UNS|SINC|OFFL|ALTBSY)) {
		printf("MSM error: cyl=%d track=%d sect=%d er=%x ad=%x\n",
		    cn, tn, sn, stat, drive);
		return(-1);
	}
	oc(selch, STOP);
	wdh(selch, io->i_ma);
	wdh(selch, io->i_ma + io->i_cc - 1);
	wh(drive, tn);
	oc(drive, SETHEAD);
	msmidle();
	wd(cntl, sn);
	wh(cntl, (tn<<10) | cn);
	wh(drive, tn);
	oc(drive, SETHEAD);
	msmidle();
	if (func == READ) {
		oc(cntl, CREAD);
		oc(selch, READ_GO);
	} else {
		oc(cntl, CWRITE);
		oc(selch, GO);
	}
	while (ss(selch) & SELCHBSY) ;
	oc(selch, STOP);
	msmidle();
	if ((stat=ss(cntl)) & (CNTL_UNRCV|CYL_OV)) {
		printf("MSM error: cyl=%d track=%d sect=%d er=%x ad=%x\n",
		    cn, tn, sn, stat, cntl);
		return(-1);
	}
	return(io->i_cc);
}
msmidle()
{
	while (! (ss(curcntl) & IDLE) ) ;
}
d67strategy(io, func)
struct iob *io;
{
	msmstrategy(io, func, NBPC67);
}

d256strategy(io, func)
struct iob *io;
{
	msmstrategy(io, func, NBPC256);
}
E 1
