h64482
s 00187/00000/00000
d D 1.1 82/08/02 16:05:45 cecily 1 0
e
u
U
t
T
I 1

***********************************************
* Runtime startoff for UNIX bootstrap program *
*                                             *
*   Initialization for P-E 7/32, 8/32, 3220   *
***********************************************

	entry   _rtt
	entry   ss,oc,rd,rh,rdh,wd,wh,wdh
	extrn   edata,end,main

* Registers

r0      equ     0
r1      equ     1
r2      equ     2
r3      equ     3
r4      equ     4
r5      equ     5
r6      equ     6
sp      equ     7
re      equ     14
rf      equ     15

* PSW definitions

PS_START equ    x'30f0'         MM & AF traps enabled, reg set 15

* Note:
*       This code must be loaded at physical location 0.  Since UNIX 'ld'
*       does not permit an ABS segment, it must be faked as PURE.

	pure
low     equ     *       Physical location 0

	org     low+x'60'       entry point from LSU loader
	b       start           go to real entry point

	org     low+x'80'       entry point from '50-sequence' loader
start50 equ     *

* Initial entry from '50-sequence'

	la      r2,start        mem address of first record to read
	li      r3,1            increment
	la      r4,edata-1      end of last record to read
	lb      r1,x'78'        get input device address
read    st      r2,rdbuf        mem start address for next record
	ai      r2,79           read 80-byte records
	st      r2,rdbuf+adc    mem end address for next record
	oc      r1,x'79'        issue read command to input device
	rb      r1,rdbuf        read next record
	bxle    r2,read         repeat until all read

	b       start           go to real entry point

	align   adc
rdbuf   das     2               parameters for 'rd' instruction

* Initial entry from LSU

	org     start50+80
start   equ     *
	li      r1,PS_START     disable everything
	epsr    r0,r1

*  Clear bss segment

	la      r1,edata        start at end of initialized data
	li      r2,adc          increment by wordlength
	la      r3,end-adc      finish at end of program
	li      r0,0
clear   st      r0,0(r1)        clear a word
	bxle    r1,clear        increment r1 and repeat

*  Set up stack

	la      sp,8*1024(r1)   allow 8k beyond end of data

*  Call main() to read in a.out file after bootstrap

	st      sp,-adc(sp)     start address for a.out
	si      sp,adc
	bal     rf,main         read it in
	ai      sp,adc

*  Relocate bootstrap program after program just read in

	lr      r1,r0           start at end of a.out
	li      r2,0            start relocating from low core
	li      r3,adc          move a word at a time
	la      r4,eseg1        until end of first segment
reloc   l       r5,0(r2)        move a word
	st      r5,0(r1,r2)
	bxle    r2,reloc        repeat
	la      r2,sseg2        continue relocating from second segment
	la      r4,edata        until end of initialized data
reloc1  l       r5,0(r2)        move a word
	st      r5,0(r1,r2)
	bxle    r2,reloc1       repeat

*  Continue execution in relocated copy

	b       cont-low(r1)
cont    equ     *

*  Relocate a.out program to low core

	lr      r1,sp           start at beginning of a.out
	li      r2,0            start relocating to low core
	lr      r4,r0           until end of a.out
reloc2  l       r5,0(r1,r2)     move a word
	st      r5,0(r2)
	bxle    r2,reloc2       repeat

*  Call a.out program

	bal     rf,x'60'        start at 'LSU' entry point
_rtt    equ     *

*  Relocate bootstrap back to low core

	lr      r1,rf           relocated address of _rtt (from bal)
	si      r1,_rtt-low     relocated address of bootstrap
	li      r2,0            start relocating to low core
	li      r3,adc          move a word at a time
	li      r4,edata        until end of bootstrap
reloc3  l       r5,0(r1,r2)     move a word
	st      r5,0(r2)
	bxle    r2,reloc3       repeat

*  Restart bootstrap

	b       start-low       go back to low-core copy
eseg1   equ     *               end of first segment

	org     low+x'400'      make room for MAC registers
sseg2   equ     *               start of second segment

*  I/O instruction routines

ss	equ	*	sense status
	l	r1,0(sp)
	ssr	r1,r0
	br	rf

oc	equ	*	output command
	l	r1,0(sp)
	lb	r0,7(sp)	*** do ocr instead of oc
	ocr	r1,r0		*** because of timing bug on 7/32
	br	rf

wd	equ	*	write data
	l	r1,0(sp)
	wd	r1,7(sp)
	br	rf

wh	equ	*	write halfword
	l	r1,0(sp)
	wh	r1,6(sp)
	br	rf

wdh	equ	*	write 3 bytes
	l	r1,0(sp)
	wd	r1,5(sp)
	wh	r1,6(sp)
	br	rf

rd	equ	*	read data
	l	r1,0(sp)
	rdr	r1,r0
	br	rf

rh	equ	*	read halfword
	l	r1,0(sp)
	rhr	r1,r0
	br	rf

rdh	equ	*	read 3 bytes
	l	r1,0(sp)
	rdr	r1,r2
	rhr	r1,r0
	exhr	r2,r2
	or	r0,r2
	br	rf

	end
E 1
