h42488
s 00104/00000/00000
d D 1.1 82/08/02 16:30:55 cecily 1 0
e
u
U
t
T
I 1
#include	<stdio.h>
#include	<signal.h>

#define		TRUE		1
#define		FALSE		0
#define		NMOUNT		32
#define		FNS		128

/*
 *   umount: dismount file-systems.
 */

struct	m	{
	char	sp[FNS];
	char	dp[FNS];
	char	cp[FNS];
	char	fp[FNS];
	}	m[NMOUNT];

char	*dev;


main(argc, argv)
char *argv[ ];
{
	register int nmount;
	register int i;
	register int up;
	register int found;
	register struct m *p;


	signal(SIGHUP, SIG_IGN);
	signal(SIGINT, SIG_IGN);
	signal(SIGQUIT, SIG_IGN);
	signal(SIGTERM, SIG_IGN);

	up = FALSE;
	nmount = 0;
	p = &m[0];
	while (getmtab(p->sp, p->dp, p->cp, p->fp) >= 0)  {
		nmount++;
		p++;
		}

	i = 1;
	while (--argc)  {
		if (*argv[i] == '-')  switch (*(argv[i]+1))  {
			case 'u':
				up = TRUE;
				break;

			default:
				fprintf(stderr, "%s: -%c unknown\n", argv[0], *(argv[i]+1));
				exit(1);
			}

		else  {
			if (!dev)
				dev = argv[i];
			else
				fprintf(stderr, "%s: too many names\n", argv[0]);
			}

		i++;
		}

	if (!dev)  {
		fprintf(stderr, "%s: device name required\n", argv[0]);
		exit(1);
		}

	if (!up)
		if (umount(dev) < 0)  {
			perror("umount");
			exit(1);
			}

	/*  update mount table  */
	p = &m[0];
	found = FALSE;
	i = 0;
	while (nmount--)  {
		if (strcmp(p->sp, dev) != 0)  {
			putmtab(p->sp, p->dp, p->cp, p->fp);
			i++;
			}
		else
			found = TRUE;

		p++;
		}

	if (!found)  {
		fprintf(stderr, "%s: %s not in mount table\n", argv[0], dev);
		exit(1);
		}

	if (!i)
		/* last entry deleted */
		emptymtab();

	exit(0);
}
E 1
