/*
 * 
 * $Copyright
 * Copyright 1993, 1994 , 1995 Intel Corporation
 * INTEL CONFIDENTIAL
 * The technical data and computer software contained herein are subject
 * to the copyright notices; trademarks; and use and disclosure
 * restrictions identified in the file located in /etc/copyright on
 * this system.
 * Copyright$
 * 
 */
 
/*
 * Copyright (c) 1991-1995, Locus Computing Corporation
 * All rights reserved
 */
/*
 * $Log: rvp_subr.c,v $
 * Revision 1.20  1995/02/01  21:52:25  bolsen
 *  Reviewer(s): Jerry Toman
 *  Risk: Medium (lots of files)
 *  Module(s): Too many to list
 *  Configurations built: STD, LITE, & RAMDISK
 *
 *  Added or Updated the Locus Copyright message.
 *
 * Revision 1.19  1994/11/18  20:44:13  mtm
 * Copyright additions/changes
 *
 * Revision 1.18  1994/10/25  23:31:27  yazz
 *  Reviewer: Nandini Ajmani
 *  Risk: High -- many lines changed in many files
 *  Benefit or PTS #: 9853
 *  Testing: EATs: controlc, sched, os_interfaces, messages, rmcall
 *  Module(s):
 * 	server/bsd/init_main.c
 * 	server/bsd/kern_exit.c
 * 	server/bsd/kern_fork.c
 * 	server/bsd/kern_prot.c
 * 	server/bsd/kern_sig.c
 * 	server/bsd/mach_signal.c
 * 	server/sys/proc.h
 * 	server/sys/user.h
 * 	server/tnc/chkpnt_pproc.c
 * 	server/tnc/rvp_subr.c
 * 	server/tnc/tnc_svipc.c
 * 	server/uxkern/bsd_2.defs
 * 	server/uxkern/syscall_subr.c
 * Side-thread changes.  Init (and zero) u.u_procp at the correct time to
 * respect more thorough assertions in several thread setup/teardown routines.
 *
 * Revision 1.17  1994/10/25  22:01:28  yazz
 *  Reviewer: Nandini Ajmani
 *  Risk: Lo
 *  Benefit or PTS #: 11128
 *  Testing: EATs: controlc, sched, messages, os_interfaces, rmcall
 *  Module(s):
 * 	server/i386/bsd_machdep.c
 * 	server/i386/slock.s
 * 	server/i860/bsd_machdep.c
 * 	server/i860/slock.s
 * 	server/kern/parallel.h
 * 	server/kern/sched_prim.c
 * 	server/sys/unix_defs.h
 * 	server/tnc/rvp_subr.c
 * 	server/uxkern/cred_servers.c
 * 	server/uxkern/emul_user.c
 * 	server/uxkern/fsvr_subr.c
 * 	server/uxkern/ux_server_loop.c
 *
 * Revision 1.16  1994/09/29  23:20:08  yazz
 *  Author of fix: Chris Peak
 *  Reviewer: Bob Yasi, Nandini Ajmani
 *  Risk: Medium
 *  Benefit or PTS #: 9346 (plus 10485, 6266, 7916, 9265, 8194)
 *  Testing: control-c EAT case 3 (20 iterations), other EATs os_interfaces,
 * 		xtrnl, controlc, rmcall, fileio, message
 *  Module(s):
 * 	server/sys/vproc.h
 * 	server/uxkern/proc_to_task.h
 * 	server/uxkern/proc_to_task.c
 * 	server/tnc/dvp_vpops.c
 * 	server/tnc/rvp_subr.c
 *
 * Abolish the renaming of vproc ports for send rights on remote nodes.
 * No longer try to prevent the arrival of new vproc ports during dvpop_free().
 *
 * Revision 1.15  1994/09/06  21:49:38  yazz
 *  Author of change: slk
 *  Reviewer: Bob Yasi
 *  Risk: Lo
 *  Benefit or PTS #: Augmented panic msg to help with #9346
 *  Testing: Build & boot
 *  Module(s): server/tnc/rvp_subr.c
 *
 * Augmented panic message in install_vproc_port().
 *
 * Revision 1.14  1993/12/08  19:37:08  cfj
 * Merge from R1_2 branch.
 *
 *  Reviewer:
 *  Risk:
 *  Benefit or PTS #:
 *  Testing:
 *  Module(s):
 *
 * Revision 1.13.2.1  1993/12/08  19:35:26  cfj
 * Put back pid validation check into tnc_fetch_vproc_pid().
 *
 *  Reviewer:cfj,slk@sd.locus.com
 *  Risk:L
 *  Benefit or PTS #:7336  This was regression introduced into R1.2
 *  Testing:
 *  Module(s):server/tnc/rvp_subr.c
 *
 * Revision 1.13  1993/11/03  19:17:56  yazz
 * Establish a sequence number mechanism whereby process group signals, such as
 * those generated by CTRL/C, are guaranteed to be delivered to child processes
 * of a reproducing (fork(), rfork(), rforkmulti(), etc.) task.  Many unixes
 * have a timing window where new child procs can miss out on a pgrp-style signal.
 *
 * Revision 1.12  1993/10/11  18:36:03  cfj
 * Modify the panic in tnc_install_vproc_port() when mach_port_rename() returns
 * an error so that the return code, the old port name and the new port name
 * are printed.
 *
 * Revision 1.11  1993/07/14  18:34:24  cfj
 * OSF/1 AD 1.0.4 code drop from Locus.
 *
 * Revision 1.1.1.7  1993/07/01  20:47:37  cfj
 * Adding new code from vendor
 *
 * Revision 1.10  1993/05/19  21:17:59  cfj
 * Do not use cube_io_node_list in is_tnc_node_valid().
 *
 * Revision 1.9  1993/05/18  03:20:24  cfj
 * Complete MI Driver merge.
 *
 * Revision 1.8  1993/05/06  19:25:03  cfj
 * ad103+tnc merged with Intel code.
 *
 * Revision 1.1.1.5  1993/05/03  17:46:56  cfj
 * Initial 1.0.3 code drop
 *
 * Revision 1.7  1993/04/09  15:28:16  cfj
 * Merge with T9.5
 *
 * Revision 1.5.4.2  1993/04/09  15:06:01  cfj
 * Add forward reference for is_node_valid().
 *
 * Revision 1.5.4.1  1993/04/08  23:02:52  cfj
 * VPROC LOCK fix from Locus.
 *
 * Revision 1.6  1993/04/03  03:09:26  brad
 * Merge of PFS branch (tagged PFS_End) into CVS trunk (tagged
 * Main_Before_PFS_Merge).  The result is tagged PFS_Merge_Into_Main_April_2.
 *
 * Revision 1.1.2.4.2.3  1993/02/16  20:06:15  brad
 * Merged trunk (as of the T8_EATS_PASSED tag) into the PFS branch.
 *
 * Revision 1.5  1993/01/21  20:43:23  cfj
 * 01-20-93 Locus code drop.
 *
 * Revision 1.1.2.4.2.2  1992/12/16  06:03:03  brad
 * Merged trunk (as of the Main_After_Locus_12_1_92_Bugdrop_OK tag)
 * into the PFS branch.
 *
 * Revision 1.1.2.4.2.1  1992/12/14  23:21:59  brad
 * Merged tip of old NX branch with PFS branch.
 *
 * Revision 1.4  1992/12/11  03:02:32  cfj
 * Merged 12-1-92 bug drop from Locus.
 *
 * Revision 1.3  1992/11/30  22:48:31  dleslie
 * Copy of NX branch back into main trunk
 *
 * Revision 1.1.2.5  1992/11/24  21:41:45  cfj
 * is_node_valid() now searches CUBE_IO_NODE_LIST if present.
 *
 * Revision 1.1.2.4  1992/11/13  17:01:39  cfj
 * Added RCS revision comments from Locus.
 *
 * Revision 1.1.2.3  1992/11/13  03:41:22  cfj
 * Fix rlogin crash when not on root_fs_node
 *
 * Revision 3.27  93/05/05  16:35:58  bolsen
 * [Bug 239] changed is_node_valid() function to is_tnc_node_valid()
 * 
 * Revision 3.26  93/05/04  16:52:31  yazz
 * Added missing forward reference for is_node_valid().
 * 
 * Revision 3.25  1993/04/22  16:40:45  roman
 * Minor formatting fixes.
 *
 * Revision 3.24  93/01/26  14:39:23  yazz
 * Better fix for bug #0152:
 * Move the check for invalid node-of-origin within pid to routine
 * tnc_fetch_vproc_port() and #ifdef it with OSF1_SERVER since Mach
 * IPC to an invalid node hangs.
 * 
 * Revision 3.23  93/01/05  09:43:33  chrisp
 * [Bug #137] In validate_vproc_port(), install port by calling
 * 	tnc_install_vproc_port() instead of doing it explicitly
 * 	(and incorrectly).
 * 
 * Revision 3.22  92/12/01  11:38:40  chrisp
 * Add routines tnc_dispose_vproc_port() and tnc_dispose_vproc_port_array()
 * 	to safely deallocate send rights to vprocs despite port
 * 	renaming: this requires a LOCATE_VPROC_PID, VPROC_RELEASE
 * 	sequence.
 * 
 * Revision 3.21  92/11/23  10:37:50  klh
 * Make panice messages print the objectionable return code.
 * (klh for mjl)
 * 
 * Revision 3.20  92/11/13  08:09:41  chrisp
 * [Bug #103] Rename [start|end]_rpvpsop_table() as a more general-sounding
 * 	[start|end]_rpvpsop_dummy_setup() for use by operations other
 * 	than table() - i.e. release_ctty() in particular.
 * 
 * Revision 3.19  92/11/02  12:23:06  roman
 * Add new routine vproc_list_counts() to count the number of vprocs in
 * 	the assorted vproc lists associated with a particular vproc.
 * 
 * Revision 3.18  92/10/29  13:38:34  chrisp
 * Remove explicit include for parallel.h since it's included by unix_defs.h
 * 	and multiple definitions result if building with MACH_LDEBUG.
 * 
 * Revision 3.17  92/10/28  15:54:22  roman
 * Add new routines start_rpvpsop_table() and end_rpvpsop_table()
 * 	to do uarea setup for the table pvpsops.
 * Add missing call to uarea_teminate() in end_rpvpop_server_op(), which
 * 	was leaving random ucreds lieing around.
 * 
 * Revision 3.16  92/10/09  10:01:02  roman
 * Add procedure prototype for clean i860 compilations.
 * 
 * Revision 3.15  92/09/29  08:18:00  roman
 * Change node_array type to node_t.
 * Have code private virtual process system operations (pvpsops) where
 * 	relevent.
 * 
 * Revision 3.14  92/07/30  16:17:11  chrisp
 * vproc port sequence count is now distinct from proc port sequence counting.
 * 
 * Revision 3.13  92/07/10  09:04:37  chrisp
 * Call vproc_end_port_op() on completion of remote vproc ops to update
 * 	sequence count and potentially release a pending migration.
 * 
 * Revision 3.12  92/07/08  09:10:33  roman
 * Remove tnc_mynode variable, and use this_node variable instead
 * 	(this_node is used by the rest of OSF/1 AD).
 * 
 * Revision 3.11  92/05/06  09:24:56  chrisp
 * Change explicit mutex_[un]lock(&pvp->pvp_lock) to instead use the new
 * 	VPROC_[UN]LOCK_FLAG macros.
 * 
 * Revision 3.10  92/03/27  11:32:13  roman
 * Changes to incorporate the new OSF/1 AD v0.8.5.1 allocation and
 * 	deallocation of dummy processes.
 * 
 * Revision 3.9  92/03/12  15:39:43  roman
 * Major changes to tnc_install_vproc_port() and tnc_bestow_vproc_port()
 * where vproc send rights are now always present on a vproc port,
 * even if send rights are held.
 * Add routine validate_vproc_port(), which used to be in rvp_server.c. This
 * routine now performs the correct locking and renaming of vprocs.
 * 
 * Revision 3.8  92/02/26  08:17:11  roman
 * Add new routine is_node_valid(), which check the array "node_array" to
 * see if the node number is present in the array.
 * 
 * Revision 3.7  92/02/20  09:29:59  roman
 * Get rid of routine tnc_uninstall_vproc_port(), as it is no longer used.
 * Restructure routines tnc_install_vproc_port() and tnc_bestow_vproc_port()
 * to have an additional parameter and to manipulate the
 * pvproc PV_IS_LOCAL flag. This simplifies the code
 * that calls these routines.
 * Correct tnc_install_vproc_port() to make sure it always sets the
 * PV_HAS_REMOTE_RIGHT pvproc flag.
 * Correct assorted comments for accuracy.
 * Get rid of unused variables.
 * 
 * Revision 3.6  92/02/14  08:59:47  roman
 * Change tnc_bestow_vproc_port() to do different actions depending upon
 * whether the vproc port has a receive right or not.
 * Add new routine tnc_uninstall_vproc_port() to get rid of a vproc
 * receive right (when it is moving back on error).
 * 
 * Revision 3.5  92/01/28  16:26:03  roman
 * Change *_tncserver_op and *_rvpserver_op to do a crget() and crfree()
 * on every invocation. This is new interface used by file servers.
 * 
 * Revision 3.4  92/01/10  10:16:00  roman
 * For start_tncserver_op(), return a Mach error number rather than
 * a Unix error number (the error is in the Mach error name space).
 * 
 * Revision 3.3  92/01/02  12:28:38  roman
 * Remove dead code for restarting system calls (as in OSF/1 AD 0.74).
 * 
 * Revision 3.2  91/12/24  10:36:26  roman
 * Add new routine tnc_bestow_vproc_port(), change name of
 * tnc_establish_vproc_port() to tnc_fetch_vproc_port(). Rewrite
 * tnc_fetch_vproc_port() and tnc_install_vproc_port() to work correctly in
 * a multithreaded environment with send rights to vprocs being passed
 * many times (in same message and different messages).
 * 
 * Revision 3.1  91/12/13  11:06:22  roman
 * Add numerous routines to support rfork/rexec/migrate.
 * 
 * Revision 3.0  91/10/25  10:31:58  roman
 * Initial submission of remote pvproc ops server subroutines.
 * 
 */

#include <sys/param.h>
#include <sys/user.h>
#include <sys/proc.h>
#include <sys/vproc.h>
#include <sys/signal_macros.h>
#include <uxkern/bsd_msg.h>
#include <uxkern/proc_to_task.h>
#include <uxkern/syscall_subr.h>
#include <machine/reg.h>
#include <sys/unix_defs.h>
#include <sys/tty.h>
#include <sys/vnode.h>
#include <uxkern/import_mach.h>
#include <tnc/dpvproc.h>


/* forward references */
int tnc_install_vproc_port(struct vproc *, mach_port_t, int);
int is_tnc_node_valid(node_t);


/*
 * Routines used for starting up and shutting down remote pvproc ops
 * on the server node.
 */
void
start_rpvpop_server_op(
	mach_port_t	vp_port)
{
	struct vproc		*vp;
	struct uthread		*uth = &u;
	struct proc		*p;
	extern struct proc	*fsvr_get_proc();

	/*
	 * Make sure the vproc is really there.
	 */
	vp = port_to_vproc_lookup(vp_port);
	if (vp == NULL)
		panic("start_rvpop_server_op: cannot locate vproc");

	/*
	 * Get a dummy proc for this request. There should always be
	 * enough dummy procs around for us - fsvr_get_proc() panics if not.
	 */
	p = fsvr_get_proc(uth);

	/*
	 * Get a credentials structure for use by the dummy process.
	 */
	ASSERT(p->p_rcred == NOCRED);
	p->p_rcred = crget();

	/*
	 * Get ready for the remote pvproc op.
	 */
	uth->uu_procp = 0;	/* uarea_init() requires this */
	uarea_init(uth, p);	/* fsvr_uarea_init() would mess up creds */

	/* 
	 * Point dummy proc at vproc 
	 */
	u.u_procp->p_vproc = vp;
}

void
end_rpvpop_server_op()
{
	struct uthread		*uth = &u;
	struct proc		*p = u.u_procp;
	struct vproc		*vp = p->p_vproc;
	extern struct proc	*fsvr_release_proc();

	/*
	 * Undo the uarea_init() done above.
	 */
	uarea_terminate(uth);

	/*
	 * Decrement the reference count on the credentials structure that
	 * was temporarily assigned to the dummy process by
	 * start_rvpserver_op().
	 */
	crfree(p->p_rcred);
	p->p_rcred = NOCRED;  

	/*
	 * Free the dummy process.
	 */
	fsvr_release_proc(uth, p);
	ASSERT(uth->uu_master_lock == 0);

	/*
	 * Adjust port sequence counts to mark end of the vproc op.
	 */
	vproc_end_vp_port_op(vp, "end_rvp_server_op");
}


/*
 * This routine is called with a local vproc pointer only.  It
 * ensures that the local vproc structure has a send right to the
 * remote vproc.  If the local vproc does not already have such a
 * send right, one will be obtained using PVPSOP_GET_VPROC_PORT().
 * Note that the caller DOES NOT supply a vproc port to the routine.
 */
int
tnc_fetch_vproc_port(
	struct vproc 	*vp)
{
	mach_port_t 	vp_port;
	int		status;

	/* 
	 * Check and see if the send right has been established.
	 * If so then we're all done. No need to do this under
	 * lock control, since the vproc can't disappear and the
	 * worst that can happen is we get an extra send right that
	 * we just discard later.
	 */
	if ( PVP(vp)->pvp_flag & PV_HAS_PORT_RIGHT ) {
		return(ESUCCESS);
	}

	/*
	 * We have to go get a right.  But until Mach IPC to a non-existant
	 * node is fixed -- presently it hangs -- verify that the pid's
	 * node-of-origin is valid.
	 */
#ifdef  OSF1_SERVER
	if (!is_tnc_node_valid(VPROCNODE(vp->vp_pid)))
		return(ESRCH);
#endif

	status = PVPSOP_GET_VPROC_PORT(VPROCNODE(vp->vp_pid), vp, &vp_port); 
	if (status) {
		if ( status == EINVAL || status == ESRCH )
			return(ESRCH);	/* invalid node means no such pid */
		panic("tnc_fetch_vproc_port: PVPSOP_GET_VPROC_PORT failure, "
		       "status=%d", status);
	}

	/*
	 * Get tnc_install_vproc_port to associate the port with the vproc.
	 */
	return( tnc_install_vproc_port(vp, vp_port, 0) );
}


/*
 * This routine is called with both a local vproc pointer and a
 * send right or receive right for the vproc port.  The right is installed
 * in the local vproc structure.  If necessary, extra references to 
 * send rights are deallocated.
 *
 * Installation of a receive right - but not a send right - involves
 * renaming it to the vproc address. Whether or not renaming occurs,
 * the corresponding port name is recorded in the vproc.
 */
int
tnc_install_vproc_port(
	struct vproc 	*vp,
	mach_port_t	vp_port,
	int		flag)
{
	kern_return_t	ret;
	struct pvproc	*pvp = PVP(vp);
	char str1[400], str2[400];	/*for excessive debug info (temp)*/

	/*
	 * Try using a shortcut that doesn't involve getting the vproc
	 * lock. This shortcut can be used if the vproc already has
	 * the PV_HAS_REMOTE_RIGHT flag set (and we are not installing
	 * a receive right).
	 */
	if ((pvp->pvp_flag & PV_HAS_REMOTE_RIGHT) != 0 &&
			(flag & INSTALL_RECEIVE_RT) == 0) {
		ASSERT((pvp->pvp_flag & PV_HAS_PORT_RIGHT) != 0);
		ret = mach_port_deallocate(mach_task_self(), 
					   vproc_to_port_lookup(vp));
		if ( ret != KERN_SUCCESS ) {
			panic("tnc_install_vproc_port: dealloc failure, "
			      "ret=0x%x", ret);
		}
		return(ESUCCESS);
	}

	/*
	 * Lock the vproc for the duration of this call.
	 */
	VPROC_LOCK_FLAG(vp, "tnc_install_vproc_port");

	if ((flag & INSTALL_RECEIVE_RT) != 0 && vp_port != (mach_port_t)vp) {
		/*
		 * Rename the port right to the vproc itself.
		 * This optimizes port_to_vproc_lookup()s on
		 * nodes holding the receive right. 
		 */
		ret = mach_port_rename(mach_task_self(), 
				       vp_port, 
				       (mach_port_t) vp);
		if ( ret != KERN_SUCCESS ) {
			panic("tnc_install_vproc_port: rename failed "
			      "ret=0x%x", ret);
		}
		vp_port = (mach_port_t) vp;
		vp->vp_port_name = vp_port;
	}
	/* 
	 * Check and see if a send right is here already.
	 */
	if (pvp->pvp_flag & PV_HAS_PORT_RIGHT) {
		/*
		 * If the port already has a send right and we received another
		 * send right, deallocate the extra send right. Note that 
		 * the name may have changed since the Mach message was 
		 * dequeued, hence the deallocation is done with the "real" 
		 * port name.
		 */
		if ((flag & INSTALL_RECEIVE_RT) == 0) {
			ret = mach_port_deallocate(mach_task_self(), 
					           vproc_to_port_lookup(vp));
		 	if ( ret != KERN_SUCCESS ) {
		    		panic("tnc_install_vproc_port: dealloc failed "
				      "ret=0x%x", ret);
	        	}
		}
	} else {
		/*
		 * If we are installing a receive right for the first
		 * time, then we must make sure there is a send right
		 * also.
		 */
		if ((flag & INSTALL_RECEIVE_RT) != 0) {
			ret = mach_port_insert_right(mach_task_self(),
						     vp_port,
						     vp_port,
						     MACH_MSG_TYPE_MAKE_SEND);
			if ( ret != KERN_SUCCESS ) {
				panic("tnc_install_vproc_port: insert failed "
				      "ret=0x%x", ret);
			}
		}
	}

	/*
	 * Mark the vproc as having a port right and for having received its 
	 * port rights remotely. Turn on PV_HAS_REMOTE_RIGHT this late to 
	 * allow the shortcut at the beginning of the routine.
	 * Record the port name - which will be the vproc address only
	 * if a receive right is present.
	 */
	vp->vp_port_name = vp_port;
	pvp->pvp_flag |= (PV_HAS_PORT_RIGHT | PV_HAS_REMOTE_RIGHT);

	/*
	 * We're done. Unlock and exit.
	 */
	VPROC_UNLOCK_FLAG(vp, "tnc_install_vproc_port");
	return(ESUCCESS);
}


/*
 * This routine is called to give away send rights or receive rights to a 
 * vproc to another server. It should be invoked for all vproc port rights 
 * that are placed in server-to-server MiG messages.
 */
mach_port_t 
tnc_bestow_vproc_port(
	struct vproc		*vp,
	int			flag)
{
	struct pvproc		*pvp = PVP(vp);

	/*
	 * Mark the vproc as having given away rights to a remote
	 * location.
	 */
	if ((pvp->pvp_flag & PV_HAS_REMOTE_RIGHT) == 0 ||
			(flag & BESTOW_RECEIVE_RT) != 0) {
		VPROC_LOCK_FLAG(vp, "tnc_bestow_vproc_port");
		pvp->pvp_flag |= PV_HAS_REMOTE_RIGHT;
		VPROC_UNLOCK_FLAG(vp, "tnc_bestow_vproc_port");
	}

	return(vproc_to_port_lookup(vp));
}


/*
 * This routine is used by the client side of remote pvproc ops. It
 * checks to see if the local vproc has a send right to the remote vproc.  
 * If the local vproc does not have a send right, one will be obtained using 
 * PVPSOP_GET_VPROC_PORT().  The returned port will also be renamed to the 
 * local vproc following vproc operational conventions.
 */
int
validate_vproc_port(
	struct vproc 	*vp)
{
	struct pvproc	*pvp = PVP(vp);
	mach_port_t 	vp_port;
	int		status;
	kern_return_t	ret;

	/* 
	 * Check and see if the send right has been established.
	 * If it has, then we are done.
	 */
	if ((pvp->pvp_flag & PV_HAS_PORT_RIGHT) != 0)
		return(ESUCCESS);

	/*
	 * Get a port right for the vproc port (from the vproc origin node)
	 */
	status = PVPSOP_GET_VPROC_PORT(VPROCNODE(vp->vp_pid), vp, &vp_port); 
	if ( status == ESRCH ) 
		return(status);

	/*
	 * Install the port using the approved method.
	 */
	tnc_install_vproc_port(vp, vp_port, 0);

	return(ESUCCESS);
}



/*
 * Start a TNC call: verify port is our server port; set up U area.
 * For this call, no credentials port is expexted, and 
 *	credentials initialization is not done.
 */
int
start_tncserver_op(
	mach_port_t		server_port,
	int			syscode)
{
	struct proc		*p;
	struct uthread		*uth = &u;
	int 			error = 0;
	extern mach_port_t	this_node_tnc_server_port;
	extern struct proc	*fsvr_get_proc();

	/*
	 * Make sure that port is not bogus. Should never happen though...
	 */
	if (server_port != this_node_tnc_server_port) {
		return(KERN_INVALID_ARGUMENT);		/* foil spoofing */
	}
	
	/*
	 * Get a dummy proc for this request. There should always be
	 * enough dummy procs around for us - fsvr_get_proc() panics if not.
	 */
	p = fsvr_get_proc(uth);

	/*
	 * Get a credentials structure for use by the dummy process.
	 */
	ASSERT(p->p_rcred == NOCRED);
	p->p_rcred = crget();

	/*
	 * Do the generic uarea initialization. 
	 */
	uth->uu_procp = 0;	/* uarea_init() requires this */
	uarea_init(uth, p);	/* fsvr_uarea_init() would mess up creds */

	/* Link dummy proc to vproc */
	u.u_procp->p_vproc = VPROCPTR(p->p_pid);

	/*
	 * If tracing system calls, then print some info. Note that pid should
	 * actually be correct, as it was set up from the credentials
	 * structure.
	 */
#ifdef	SYSCALLTRACE
	if (syscalltrace &&
			(syscalltrace == p->p_pid || syscalltrace < 0))
		printf("[%d]%s", p->p_pid, syscallnames[syscode]);
#endif	SYSCALLTRACE

	return(error);
}

int
end_tncserver_op(
	int		error)
{
	struct uthread		*uth = &u;
	struct proc		*p = uth->uu_procp;
	extern struct proc	*fsvr_release_proc();

	/*
	 * Do some output if we're tracing system calls.
	 */
#ifdef	SYSCALLTRACE
	if (syscalltrace &&
			(syscalltrace == p->p_pid || syscalltrace < 0))
		printf("    [%d] returns %d\n", 
				p->p_pid, 
				error);
#endif	SYSCALLTRACE

	/*
	 * Decrement the reference count on the credentials structure that
	 * was temporarily assigned to the dummy process by
	 * start_tncserver_op().
	 */
	crfree(p->p_rcred);
	p->p_rcred = NOCRED;  

	uarea_terminate(uth);

	/*
	 * Free the dummy process.
	 */
	fsvr_release_proc(uth, p);
	ASSERT(uth->uu_master_lock == 0);

	return(error);
}


/*
 * Check whether a node is in the node table.
 */
int
is_tnc_node_valid(
	node_t		node)
{
	node_t		low, high, mid;
	extern node_t	node_array[][2];
	extern int	node_array_entries;

	ASSERT(node_array_entries > 0);

	/*
	 * Use a simple binary search algorithm.
	 */
	low = 0;
	high = node_array_entries - 1;
	while (low <= high) {
		mid = (low + high) >> 1;
		if (node < node_array[mid][0])
			high = mid - 1;
		else if (node > node_array[mid][1])
			low = mid + 1;
		else
			return(TRUE);
	}

	return(FALSE);
}


/*
 * Routines that are called at the start and end of the
 * remote server pvpsop routines, if required.
 *
 * These routines count on the fact that the pvpsop server routines
 * do not set up a dummy vproc context at all by default, and so some
 * pvpsop routines must do so explicitly if required.
 */
int
start_rpvpsop_dummy_setup()
{
	struct uthread	*uth = &u;
	struct proc	*p;
	kern_return_t	ret;
	extern struct proc *fsvr_get_proc();

	/*
	 * Get a dummy proc for this request. There should always be
	 * enough dummy procs around for us - fsvr_get_proc() panics if not.
	 */
	p = fsvr_get_proc(uth);
	p->p_pid = 0;

	/*
	 * Refer to the proc structure's credentials. This results in the
	 * dummy process looking like the super-user.
	 */
	p->p_rcred = crget();
	uth->uu_nd.ni_cred = p->p_rcred;
	crhold(uth->uu_nd.ni_cred);

	/*
	 * Set the reply port appropriately for a message-based system call.
	 */
	uth->uu_reply_msg = NULL;
	uth->uu_master_lock = 0;

	return(ESUCCESS);
}

int
end_rpvpsop_dummy_setup()
{
	struct uthread	*uth = &u;
	struct proc	*p = u.u_procp;
	int		dummy;

	/* Get rid of uarea credentials */
	crfree(uth->uu_nd.ni_cred);
	uth->uu_nd.ni_cred = NOCRED;
	crfree(p->p_rcred);
	p->p_rcred = NOCRED;  

	/* Release the dummy vproc */
	fsvr_release_proc(uth, p);
	ASSERT(uth->uu_master_lock == 0);

	return(ESUCCESS);
}

/*
 * Subroutine to get the lengths of the vproc lists associated with a
 * vproc.
 */
void
vproc_list_counts(
	struct vproc	*v,
	unsigned int	*child_cnt,
	unsigned int	*foster_child_cnt,
	unsigned int	*pgrp_member_cnt,
	unsigned int	*sess_member_cnt)
{
	struct vproc	*w;
	unsigned int	cnt;
	struct pvproc	*pv = PVP(v);

	for (w = pv->pvp_head_childl, cnt = 0;
			w != NULL;
			w = PVP(w)->pvp_childl, cnt++)
		;
	*child_cnt = cnt;

	for (w = pv->pvp_head_foster_childl, cnt = 0;
			w != NULL;
			w = PVP(w)->pvp_foster_childl, cnt++)
		;
	*foster_child_cnt = cnt;

	if (pv->pvp_flag & PV_PGRPLEADER) {
		for (w = pv->pvp_head_pgrpl, cnt = 0;
				w != NULL;
				w = PVP(w)->pvp_pgrpl, cnt++)
			;
		*pgrp_member_cnt = cnt;
	} else
		*pgrp_member_cnt = 0;

	if (pv->pvp_flag & PV_SESSIONLEADER) {
		for (w = pv->pvp_sessionl, cnt = 0;
				w != NULL;
				w = PVP(w)->pvp_sessionl, cnt++)
			;
		*sess_member_cnt = cnt;
	} else
		*sess_member_cnt = 0;

}

/*
 * Function to safely dispose of a vproc port. The sequence of
 * locating, installing port and releasing ensures that the send right
 * is deallocated correctly even though the port might have been
 * renamed concurrently.
 */
void
tnc_dispose_vproc_port(
	pid_t		pid,
	mach_port_t	port)
{
	register struct vproc *v;

	if (port == MACH_PORT_NULL)
		return;

	v = LOCATE_VPROC_PID(pid);
	if (v == NULL)
		panic("tnc_dispose_vproc_port: unable to locate vproc");
	tnc_install_vproc_port(v, port, 0);
	VPROC_RELEASE(v, "tnc_dispose_vproc_port");
}

/*
 * Function to safely dispose of a vproc pid/port vector pair.
 */
void
tnc_dispose_vproc_port_array(
	pid_t		pid_array[],
	mach_port_t	port_array[],
	unsigned int	nports)
{
	register unsigned int i;

	for (i = 0; i < nports; i++)
		tnc_dispose_vproc_port(pid_array[i], port_array[i]);

}
