/*
 * 
 * $Copyright
 * Copyright 1993, 1994 , 1995 Intel Corporation
 * INTEL CONFIDENTIAL
 * The technical data and computer software contained herein are subject
 * to the copyright notices; trademarks; and use and disclosure
 * restrictions identified in the file located in /etc/copyright on
 * this system.
 * Copyright$
 * 
 */
 
/*
 * @OSF_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log: tcp_subr.c,v $
 * Revision 1.5  1994/11/18  20:35:39  mtm
 * Copyright additions/changes
 *
 * Revision 1.4  1994/10/25  21:02:38  hobbes
 *  Benefit or PTS #:11347
 *  Testing: TCP/IP EATS and developer tests to verify improved ftp performance
 *  Module(s): uxkern/boot_config.c netinet/tcp_subr.c
 *
 * Revision 1.3.6.1  1994/02/12  01:40:07  hobbes
 *  Reviewer: Roy Larsen
 *  Risk: Low
 *  Benefit or PTS #: 7560
 *  Testing: rand tcp and HIPPI eats.
 *  Module(s): tcp_subr.c
 *
 * enable the configuration of tcp_send and tcp_recv space via bootmagic.
 *
 * Revision 1.3  1993/05/06  20:27:18  brad
 * ad103+tnc merged with Intel code.
 *
 * Revision 1.1.1.1  1993/05/03  17:34:22  cfj
 * Initial 1.0.3 code drop
 *
 * Revision 1.2  1992/11/30  22:29:51  dleslie
 * Copy of NX branch back into main trunk
 *
 * Revision 1.1.2.1  1992/11/05  23:28:01  dleslie
 * Local changes for NX through noon, November 5, 1992.
 *
 * Revision 4.1  1992/11/04  00:22:03  cfj
 * Bump major revision number.
 *
 * Revision 2.3  1992/10/22  23:18:24  hobbes
 * Added the RFC_1323 extensions.
 *
 * Revision 2.2  1991/08/31  13:44:40  rabii
 * 	Initial V2.0 Checkin
 *
 * Revision 3.1  91/07/31  15:37:09  sp
 * Upgrade to 1.0.2
 * 
 * Revision 1.12.4.2  91/04/29  12:10:36  tmt
 * 	Init tcp_sendspace to reasonable minimum value.
 * 	[91/04/10  09:54:46  tmt]
 * 
 * Revision 1.12  90/10/07  14:36:01  devrcs
 * 	Added EndLog Marker.
 * 	[90/09/28  11:16:42  gm]
 * 
 * Revision 1.11  90/08/09  13:26:39  devrcs
 * 	Finish Reno update - REASS_MBUF.
 * 	[90/07/26  10:37:54  tmt]
 * 
 * Revision 1.10  90/07/27  09:02:08  devrcs
 * 	Update to BSD Reno release.
 * 	Drop allocate of tcp_template and just put it in the tcpcb.
 * 	[90/07/19  17:40:45  tmt]
 * 
 * Revision 1.9  90/06/22  20:39:27  devrcs
 * 	Parallelization repairs. Socket locks, then inpcb locks.
 * 	Take inpcbhead locks directly. Do refcounting right.
 * 	[90/06/07  16:13:49  tmt]
 * 
 * Revision 1.8  90/05/13  18:45:05  devrcs
 * 	tcp_respond didn't set m_pkthdr.
 * 	[90/05/04  16:29:05  tmt]
 * 
 * Revision 1.7  90/04/27  19:19:15  devrcs
 * 	Change code to handle new _NO_BITFIELDS ip and tcp headers.
 * 	[90/04/20  13:04:21  tmt]
 * 
 * Revision 1.6  90/04/14  00:33:36  devrcs
 * 	Add void's, delete function decls.
 * 	[90/04/09  16:35:12  tmt]
 * 
 * Revision 1.5  90/02/05  15:50:54  robert
 * 	Use macros for inpcb_islocked.
 * 	[90/01/19  15:07:04  tmt]
 * 
 * Revision 1.4  90/01/18  08:48:00  gm
 * 	In_pcbnotify is now as before argument-wise.
 * 	Lose old mbuf code for tcp_template and stick with MALLOC.
 * 	[90/01/08  16:13:04  tmt]
 * 
 * 	OSF/1 "one" snapshot revision.
 * 	[90/01/02  12:00:00  tmt]
 * 
 * 	- Base is BSD 4.4 (Alpha) networking.
 * 	- Encore multiprocessing merged in with some structural
 * 	  modifications to support flexible configuration.
 * 	- Glue for compiling and running in MACH or Unix 4.4 environments,
 * 	  lock testing under Unix, thread or software interrupt netisr's,
 * 	  locking and/or spl synchronization, single or multiple CPUs.
 * 	[89/12/20  12:00:00  tmt]
 * 
 * Revision 1.3  90/01/03  12:42:03  gm
 * 	Fixes for first snapshot.
 * 	[90/01/03  09:39:19  gm]
 * 
 * Revision 1.2  89/12/26  10:15:45  gm
 * 	New networking code from BSD.
 * 	[89/12/16            tmt]
 * 
 * $EndLog$
 */
/*
 * Copyright (C) 1988,1989 Encore Computer Corporation.  All Rights Reserved
 *
 * Property of Encore Computer Corporation.
 * This software is made available solely pursuant to the terms of
 * a software license agreement which governs its use. Unauthorized
 * duplication, distribution or sale are strictly prohibited.
 *
 */
/*
 * Copyright (c) 1982, 1986, 1988, 1990 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted provided
 * that: (1) source distributions retain this entire copyright notice and
 * comment, and (2) distributions including binaries display the following
 * acknowledgement:  ``This product includes software developed by the
 * University of California, Berkeley and its contributors'' in the
 * documentation or other materials provided with the distribution and in
 * all advertising materials mentioning features or use of this software.
 * Neither the name of the University nor the names of its contributors may
 * be used to endorse or promote products derived from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 *	Base:	%W% (Berkeley) %G%
 *	Merged:	tcp_subr.c	7.18 (Berkeley) 6/28/90
 */

#include "net/net_globals.h"

#include "sys/param.h"
#include "sys/time.h"
#include "sys/errno.h"

#include "sys/mbuf.h"
#include "sys/socket.h"
#include "sys/socketvar.h"
#include "sys/protosw.h"

#include "net/if.h"
#include "net/route.h"

#include "netinet/in.h"
#include "netinet/in_systm.h"
#include "netinet/ip.h"
#include "netinet/in_pcb.h"
#include "netinet/ip_var.h"
#include "netinet/ip_icmp.h"
#include "netinet/tcp.h"
#include "netinet/tcpip.h"
#include "netinet/tcp_fsm.h"
#include "netinet/tcp_seq.h"
#include "netinet/tcp_timer.h"
#include "netinet/tcp_var.h"

#include "net/net_malloc.h"

LOCK_ASSERTL_DECL

struct	inpcb tcb;		/* head of queue of active tcpcb's */
struct	tcpstat tcpstat;	/* tcp statistics */
tcp_seq	tcp_iss;

/* patchable/settable parameters for tcp */
int	tcp_ttl = TCP_TTL;
int 	tcp_mssdflt = TCP_MSS;
int 	tcp_rttdflt = TCPTV_SRTTDFLT / PR_SLOWHZ;
int	tcp_compat_42 = TCP_COMPAT_42;

#if	RFC_1323
/* These are for disabling time-stamps and echo replies, window scaling,
 * and selective acknowledgements.
 */
int	tcp_dont_tsecho = 0;
int	tcp_dont_winscale = 0;
int	tcp_dont_sack = 1;
#endif

#if	NETSYNC_LOCK
simple_lock_data_t	misc_tcp_lock;
#endif

/*
 * Tcp initialization
 */

#if RFC_1323
#define TCP_SPACE_MIN	4096
#define TCP_SPACE_MAX	524288

u_long tcp_space_size = 0;
#endif

void
tcp_init()
{
	extern u_long tcp_sendspace;
	extern u_long tcp_recvspace;
#if RFC_1323
	u_long tcp_compsize;
#endif

	tcp_iss = 1;		/* wrong */
	tcb.inp_next = tcb.inp_prev = &tcb;
	if (max_protohdr < sizeof(struct tcpiphdr))
		max_protohdr = sizeof(struct tcpiphdr);
	if (max_linkhdr + sizeof(struct tcpiphdr) > MHLEN)
		panic("tcp_init");

#if RFC_1323
	/*
	 * To facilitate tuning on those systems with HIPPI
	 * we've added the ability to configure via BOOTMAGIC
	 * tcp_sendspace and tcp_recvspace.
	 */
	if ((tcp_space_size >= TCP_SPACE_MIN) && 
		(tcp_space_size <= TCP_SPACE_MAX)) {
		if ((tcp_space_size % TCP_SPACE_MIN) == 0)
			tcp_sendspace = tcp_recvspace = tcp_space_size;
		else {
			tcp_compsize = ((tcp_space_size / TCP_SPACE_MIN)
						* TCP_SPACE_MIN);
			tcp_sendspace = tcp_recvspace = tcp_compsize;
			printf("Setting tcp_sendspace and tcp_recvspace to %d, instead of %d\n", tcp_compsize, tcp_space_size);
		}
	} else if (tcp_space_size >= TCP_SPACE_MAX) {
		tcp_sendspace = tcp_recvspace = TCP_SPACE_MAX;
		printf("Using maximum value {%d} for tcp_sendspace and tcp_recvspace\n", TCP_SPACE_MAX);
	} else {
		tcp_sendspace = tcp_recvspace = TCP_SPACE_MIN;
		printf("Using default value {%d} for tcp_sendspace and tcp_recvspace\n", TCP_SPACE_MIN);
	}
#endif /* RFC_1323 */

	if (tcp_sendspace < 2 * MCLBYTES)
		tcp_sendspace = 2 * MCLBYTES;
	INPCBRC_LOCKINIT(&tcb);		/* in_pcbnotify, tcp_slowtimo frob */
	tcb.inp_refcnt = 2;
	INHEAD_LOCKINIT(&tcb);
	TCPMISC_LOCKINIT();
	NETSTAT_LOCKINIT(&tcpstat.tcps_lock);
}

/*
 * Fill in template to be used to send tcp packets on a connection.
 * Skeletal tcp/ip header, minimizing the amount of work
 * necessary when the connection is used.
 */
void
tcp_template(tp)
	struct tcpcb *tp;
{
	register struct inpcb *inp = tp->t_inpcb;
	register struct tcpiphdr *n = &tp->t_template;

	n->ti_next = n->ti_prev = 0;
	n->ti_x1 = 0;
	n->ti_pr = IPPROTO_TCP;
	n->ti_len = htons(sizeof (struct tcpiphdr) - sizeof (struct ip));
	n->ti_src = inp->inp_laddr;
	n->ti_dst = inp->inp_faddr;
	n->ti_sport = inp->inp_lport;
	n->ti_dport = inp->inp_fport;
	n->ti_seq = 0;
	n->ti_ack = 0;
	n->ti_xoff = sizeof (struct tcphdr) << 2;
	n->ti_flags = 0;
	n->ti_win = 0;
	n->ti_sum = 0;
	n->ti_urp = 0;
}

/*
 * Send a single message to the TCP at address specified by
 * the given TCP/IP header.  If m == 0, then we make a copy
 * of the tcpiphdr at ti and send directly to the addressed host.
 * This is used to force keep alive messages out using the TCP
 * template for a connection tp->t_template.  If flags are given
 * then we send a message back to the TCP which originated the
 * segment ti, and discard the mbuf containing it and any other
 * attached mbufs.
 *
 * In any case the ack and sequence number of the transmitted
 * segment are as specified by the parameters.
 */
void
tcp_respond(tp, ti, m, ack, seq, flags)
	struct tcpcb *tp;
	register struct tcpiphdr *ti;
	register struct mbuf *m;
	tcp_seq ack, seq;
	int flags;
{
	int win = 0, tlen;
	struct route *ro = 0;

	if (tp) {
		win = sbspace(&tp->t_inpcb->inp_socket->so_rcv);
		ro = &tp->t_inpcb->inp_route;
	}
	if (m == 0) {
		m = m_gethdr(M_DONTWAIT, MT_HEADER);
		if (m == NULL)
			return;
		if (tcp_compat_42)
			tlen = 1;
		else
			tlen = 0;
		m->m_data += max_linkhdr;
		*mtod(m, struct tcpiphdr *) = *ti;
		ti = mtod(m, struct tcpiphdr *);
		flags = TH_ACK;
	} else {
		m_freem(m->m_next);
		m->m_next = 0;
		m->m_data = (caddr_t)ti;
		tlen = 0;
#define xchg(a,b,type) { type t; t=a; a=b; b=t; }
		xchg(ti->ti_dst.s_addr, ti->ti_src.s_addr, u_long);
		xchg(ti->ti_dport, ti->ti_sport, u_short);
#undef xchg
	}
	m->m_len = sizeof (struct tcpiphdr) + tlen;
	ti->ti_next = ti->ti_prev = 0;
	ti->ti_x1 = 0;
	ti->ti_len = htons((u_short)(sizeof (struct tcphdr) + tlen));
	ti->ti_seq = htonl(seq);
	ti->ti_ack = htonl(ack);
	ti->ti_xoff = sizeof (struct tcphdr) << 2;
	ti->ti_flags = flags;
#if	RFC_1323
	if ( tp )
		ti->ti_win = htons( (u_short) (win >> tp->rcv_scale) );
	else
		ti->ti_win = htons((u_short)win);
#else
	ti->ti_win = htons((u_short)win);
#endif
	ti->ti_urp = 0;
	ti->ti_sum = in_cksum(m, sizeof (struct tcpiphdr) + tlen);
	((struct ip *)ti)->ip_len = sizeof (struct tcpiphdr) + tlen;
	((struct ip *)ti)->ip_ttl = tcp_ttl;
	if (m->m_flags & M_PKTHDR) {
		m->m_pkthdr.rcvif = 0;
		m->m_pkthdr.len = ((struct ip *)ti)->ip_len;
	} else
		panic("tcp_respond");
	(void) ip_output(m, (struct mbuf *)0, ro, 0);
}

/*
 * Create a new TCP control block, making an
 * empty reassembly queue and hooking it to the argument
 * protocol control block.
 */
struct tcpcb *
tcp_newtcpcb(inp)
	struct inpcb *inp;
{
	register struct tcpcb *tp;

	LOCK_ASSERT("tcp_newtcpcb", INPCB_ISLOCKED(inp));
	NET_MALLOC(tp, struct tcpcb *, sizeof *tp, M_PCB, M_NOWAIT);
	if (tp == NULL)
		return ((struct tcpcb *)0);
	bzero((caddr_t)tp, sizeof *tp);
	tp->seg_next = tp->seg_prev = (struct tcpiphdr *)tp;
	tp->t_maxseg = tcp_mssdflt;

	tp->t_flags = 0;		/* sends options! */
	tp->t_inpcb = inp;
	/*
	 * Init srtt to TCPTV_SRTTBASE (0), so we can tell that we have no
	 * rtt estimate.  Set rttvar so that srtt + 2 * rttvar gives
	 * reasonable initial retransmit time.
	 */
	tp->t_srtt = TCPTV_SRTTBASE;
	tp->t_rttvar = tcp_rttdflt * PR_SLOWHZ << 2;
	tp->t_rttmin = TCPTV_MIN;
	TCPT_RANGESET(tp->t_rxtcur, 
	    ((TCPTV_SRTTBASE >> 2) + (TCPTV_SRTTDFLT << 2)) >> 1,
	    TCPTV_MIN, TCPTV_REXMTMAX);
#if	RFC_1323
	tp->snd_cwnd = TCP_MAXWIN<<TCP_MAX_WINSHIFT;
	tp->snd_ssthresh = TCP_MAXWIN<<TCP_MAX_WINSHIFT;
#else
	tp->snd_cwnd = TCP_MAXWIN;
	tp->snd_ssthresh = TCP_MAXWIN;
#endif
	inp->inp_ip.ip_ttl = tcp_ttl;
	tp->t_timestamp = tcp_iss;

#if	RFC_1323
	if ( ! tcp_dont_winscale )
		tp->t_flags |= TF_REQ_SCALE;
	if ( ! tcp_dont_tsecho )
		tp->t_flags |= TF_REQ_TSTMP;
#endif

	inp->inp_ppcb = (caddr_t)tp;
	return (tp);
}

/*
 * Drop a TCP connection, reporting
 * the specified error.  If connection is synchronized,
 * then send a RST to peer.
 */
struct tcpcb *
tcp_drop(tp, errno)
	register struct tcpcb *tp;
	int errno;
{
	struct socket *so = tp->t_inpcb->inp_socket;

	if (TCPS_HAVERCVDSYN(tp->t_state)) {
		tp->t_state = TCPS_CLOSED;
		(void) tcp_output(tp);
		NETSTAT_LOCK(&tcpstat.tcps_lock);
		tcpstat.tcps_drops++;
	} else {
		NETSTAT_LOCK(&tcpstat.tcps_lock);
		tcpstat.tcps_conndrops++;
	}
	NETSTAT_UNLOCK(&tcpstat.tcps_lock);
	if (errno == ETIMEDOUT && tp->t_softerror)
		errno = tp->t_softerror;
	so->so_error = errno;
	return (tcp_close(tp));
}

/*
 * Close a TCP control block:
 *	discard all space held by the tcp
 *	discard internet protocol block
 *	wake up any sleepers
 */
struct tcpcb *
tcp_close(tp)
	register struct tcpcb *tp;
{
	register struct tcpiphdr *t;
	struct inpcb *inp = tp->t_inpcb;
	struct socket *so = inp->inp_socket;
	register struct mbuf *m;
#ifdef RTV_RTT
	register struct rtentry *rt;
#endif
	ROUTE_LOCK_DECL()

	LOCK_ASSERT("tcp_close", INPCB_ISLOCKED(inp));

#ifdef RTV_RTT
	/*
	 * If we sent enough data to get some meaningful characteristics,
	 * save them in the routing entry.  'Enough' is arbitrarily 
	 * defined as 4K (default tcp_sendspace) * 16.  This would
	 * give us 16 rtt samples assuming we only get one sample per
	 * window (the usual case on a long haul net).  16 samples is
	 * enough for the srtt filter to converge to within 5% of the correct
	 * value; fewer samples and we could save a very bogus rtt.
	 *
	 * Don't update the default route's characteristics and don't
	 * update anything that the user "locked".
	 */
	ROUTE_WRITE_LOCK();
	if (SEQ_LT(tp->iss+(4096*16), tp->snd_max) &&
	    (rt = inp->inp_route.ro_rt) &&
	    ((struct sockaddr_in *) rt_key(rt))->sin_addr.s_addr !=
	    INADDR_ANY) {
		register u_long i;

		if ((rt->rt_rmx.rmx_locks & RTV_RTT) == 0) {
			i = tp->t_srtt *
			    (RTM_RTTUNIT / (PR_SLOWHZ * TCP_RTT_SCALE));
			if (rt->rt_rmx.rmx_rtt && i)
				/*
				 * filter this update to half the old & half
				 * the new values, converting scale.
				 * See route.h and tcp_var.h for a
				 * description of the scaling constants.
				 */
				rt->rt_rmx.rmx_rtt =
				    (rt->rt_rmx.rmx_rtt + i) / 2;
			else
				rt->rt_rmx.rmx_rtt = i;
		}
		if ((rt->rt_rmx.rmx_locks & RTV_RTTVAR) == 0) {
			i = tp->t_rttvar *
			    (RTM_RTTUNIT / (PR_SLOWHZ * TCP_RTTVAR_SCALE));
			if (rt->rt_rmx.rmx_rttvar && i)
				rt->rt_rmx.rmx_rttvar =
				    (rt->rt_rmx.rmx_rttvar + i) / 2;
			else
				rt->rt_rmx.rmx_rttvar = i;
		}
		/*
		 * update the pipelimit (ssthresh) if it has been updated
		 * already or if a pipesize was specified & the threshhold
		 * got below half the pipesize.  I.e., wait for bad news
		 * before we start updating, then update on both good
		 * and bad news.
		 */
		if ((rt->rt_rmx.rmx_locks & RTV_SSTHRESH) == 0 &&
		    (i = tp->snd_ssthresh) && rt->rt_rmx.rmx_ssthresh ||
		    i < (rt->rt_rmx.rmx_sendpipe / 2)) {
			/*
			 * convert the limit from user data bytes to
			 * packets then to packet data bytes.
			 */
			i = (i + tp->t_maxseg / 2) / tp->t_maxseg;
			if (i < 2)
				i = 2;
			i *= (u_long)(tp->t_maxseg + sizeof (struct tcpiphdr));
			if (rt->rt_rmx.rmx_ssthresh)
				rt->rt_rmx.rmx_ssthresh =
				    (rt->rt_rmx.rmx_ssthresh + i) / 2;
			else
				rt->rt_rmx.rmx_ssthresh = i;
		}
	}
	ROUTE_WRITE_UNLOCK();
#endif RTV_RTT
	/* free the reassembly queue, if any */
	t = tp->seg_next;
	while (t != (struct tcpiphdr *)tp) {
		t = (struct tcpiphdr *)t->ti_next;
		m = REASS_MBUF((struct tcpiphdr *)t->ti_prev);
		remque(t->ti_prev);
		m_freem(m);
	}
	NET_FREE(tp, M_PCB);
	inp->inp_ppcb = 0;
	soisdisconnected(so);
	in_pcbdetach(inp);
	NETSTAT_LOCK(&tcpstat.tcps_lock);
	tcpstat.tcps_closed++;
	NETSTAT_UNLOCK(&tcpstat.tcps_lock);
	return ((struct tcpcb *)0);
}

void
tcp_drain()
{

}

/*
 * Notify a tcp user of an asynchronous error;
 * store error as soft error, but wake up user
 * (for now, won't do anything until can select for soft error).
 */
void
tcp_notify(inp, error)
	struct inpcb *inp;
	int error;
{
	register struct socket *so = inp->inp_socket;

	LOCK_ASSERT("tcp_notify so", SOCKET_ISLOCKED(so));
	LOCK_ASSERT("tcp_notify inpcb", INPCB_ISLOCKED(inp));
	((struct tcpcb *)inp->inp_ppcb)->t_softerror = error;
	wakeup((caddr_t) &so->so_timeo);
	sorwakeup(so);
	sowwakeup(so);
}

void
tcp_ctlinput(cmd, sa, ip)
	int cmd;
	struct sockaddr *sa;
	register struct ip *ip;
{
	register struct tcphdr *th;
	void (*notify)() = tcp_notify;

	if (cmd == PRC_QUENCH)
		notify = tcp_quench;
	else if ((unsigned)cmd > PRC_NCMDS || inetctlerrmap[cmd] == 0)
		return;
	if (ip) {
		th = (struct tcphdr *)((caddr_t)ip + ((ip->ip_vhl&0x0f) << 2));
		in_pcbnotify(&tcb, sa, th->th_dport, ip->ip_src, th->th_sport,
			cmd, notify);
	} else
		in_pcbnotify(&tcb, sa, 0, zeroin_addr, 0, cmd, notify);
}

/*
 * When a source quench is received, close congestion window
 * to one segment.  We will gradually open it again as we proceed.
#if	NETSYNC_LOCK
 * Entered with INPCB lock held.
#endif
 */
void
tcp_quench(inp)
	struct inpcb *inp;
{
	struct tcpcb *tp = intotcpcb(inp);

	if (tp)
		tp->snd_cwnd = tp->t_maxseg;
}
