/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1987,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */

/* $Header:utils.c 12.0$ */
/* $ACIS:utils.c 12.0$ */
/* $Source: /ibm/acis/usr/sys/standca/RCS/utils.c,v $ */

#ifndef lint
static char *rcsidutils = "$Header:utils.c 12.0$";
#endif

#ifndef isdigit
#include <ctype.h>
#endif
char *prompt();
char *index();

/*
 * utility routines that don't warrent their own files yet are
 * used in more than one routine
 */

int
yes(str, def)
	register char *str;
	char	def;
{
	register char *cp;

	cp = prompt(str, def);
	if (!*cp)
		cp = &def;
	while (*cp != 'y' && *cp != 'n')
		cp = prompt("Huh, yes or no? ");
	return(*cp == 'y');
}


/*
 * Print prompt and wait for reply
 */

char * prompt(msg,d1)
	char *msg;
	int d1;		/* optional data value */
{
	static char reply[132];

	printf(msg,d1);
	printf("     \b\b\b\b\b");
	gets(reply);
/*	putchar('\n');	/* */
	return (reply);
}

/*
 * from the given filename figure out the unit number
 * (for utility version this is just the last digit
 * for standalone version this is the first digit).
 * if we don't find a decimal digit then we use a hex
 * digit instead.
 */

int getunit(file)
	register char *file;
{
	register int unit;
#ifdef STANDALONE
	register char *p=file;

	unit = 0;
	while (*p++ !=0)
		if (isdigit(*p))
			{
			unit = *p - '0';
			break;
			}
#else !STANDALONE
	register char *p = index(file,0);
	int found = 0;

	unit = 0;
	while (--p > file)
		if (isdigit(*p))
			{
			unit = *p - '0';
			found++;
			break;
			}
	/* unit is not found, must be a hex digit */
	if (!found) {
		p = index(file,0) - 2;
		unit = (*p - 'a') + 10;
		if (unit < 10 || unit > 15) {
			unit =0;
		}
	}
#endif STANDALONE
	return(unit);
}
/*
 * compare string s1 with command s2. 
 */
cmdcmp(s1,s2)
register char *s1, *s2;
{
	register int l2 = strlen(s2);
	register int l1;
	register char * p = index(s1,' ');

	if (p)
		l1 = p-s1;
	else
		l1 = strlen(s1);
	if (l1 > l2)
		l1=l2;
	return(strncmp(s1,s2,l1) == 0);
}

