/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986,1987,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:boot.c 12.0$ */
/* $ACIS:boot.c 12.0$ */
/* $Source: /ibm/acis/usr/sys/standca/RCS/boot.c,v $ */

#ifndef lint
static char *rcsid = "$Header:boot.c 12.0$";
#endif

#include "param.h"
#include "inode.h"
#include "fs.h"
#include "vm.h"
#include <a.out.h>
#include "saio.h"
#include "reboot.h"

/*
 * Boot program... arguments passed in r10 and r11 determine
 * whether boot stops to ask for system name and which device
 * boot comes from.
 */

/* Types in r10 specifying major device */
char devname[][2] = {
	'h', 'd',		       /* 0 = hd */
	'd', 'k',		       /* 1 = dk */
	'u', 'd',		       /* 2 = ud */
	'f', 'd',		       /* 3 = fd */
};
#include "../machine/rdb.h"		/* get POST address */
#define POST_END	(POST_START+POST_SIZE)       /* next location after the POST */

#define BSS_SLOP 8 * 512		/* extra bss to clear */

#if defined(ATR)
#include "../ca_atr/pcif.h"
#endif ATR
char line[100] = "hd(0,0)vmunix";
char defline[100] = "hd(0,0)vmunix";
char *bootmsg = "Default: %s (just press Enter or wait ~30 seconds%s)\n\n";
char *morebootmsg = "";	 /* more boot message */

int retry = 0;
int getchar_timeout = 3000000;	       /* to get an auto cr */
char getchar_char = '\r';	       /* return a CR */
#define BASEMASK 0x0ff80000	       /* mask for calculating base address */
#define RB_LOAD	0x200			/* just load program - don't call it */

#ifndef SAUTIL
#undef main			       /* don't need debugger */
#endif

extern	unsigned opendev;

#define BOOTDEV (* (int *) 0xc04)

main()
{
	register howto=0, devtype=0;       /* howto=r11, devtype=r10 */
	int io;
	int x = BOOTDEV;

#ifdef lint
	howto = 0;
	devtype = 0;
#endif
#ifdef JUSTASK
	howto = RB_ASKNAME | RB_SINGLE;
#endif
	if (devtype == 0 && (x&0xf0) == 0xd0) {
		defline[3] = line[3] = (x&7)+'0';	/* set unit */
#ifdef ATR
		{	extern struct postconfig post_config;
			if (post_config.cpu == 2)
				defline[5] = line[5] = '4';
		}
#endif ATR
	}
	if ((howto & RB_ASKNAME) == 0) {
		if (devtype >= 0 && devtype < sizeof(devname) / 2
		    &&devname[devtype][0]) {
			defline[0] = line[0] = devname[devtype][0];
			defline[0] = line[1] = devname[devtype][1];
		} else
			howto = RB_SINGLE | RB_ASKNAME;
	}
	printf("\n4.3 BSD UNIX Standalone Boot Program $Revision: 12.0 $\n\n");
	printf(bootmsg, defline, morebootmsg);
	putchar(07);		       /* ring my chimes */
	for (;;) {
		if (howto & RB_ASKNAME) {
			printf(": ");
			gets(line);
		} else
			printf(": %s\n", line);
		if (line[0] == 0) {
			howto = 0;     /* default: come up multiple */
			strcpy(line, defline);
			printf(": %s\n", line);
		}
		if (*line == '*') {
			howto |= RB_LOAD; continue;	/* just load it */
		}
		io = open(line, 0);
		if (io >= 0) {
			copyunix(howto, opendev, io);
			close(io);
		} else if ((errno == ESRCH || errno == ENXIO) && (howto & RB_ASKNAME) == 0 &&
				(retry&1))
			if (++line[3] == '3')
				line[3] = '0';	/* try bumping unit number */
		if (++retry > 5)
			howto = RB_SINGLE | RB_ASKNAME;
	}
}

#define INSIDE(addr,low,high) ((int)(low) <= (int)(addr) && (int)(addr) < (int)(high))

/*ARGSUSED*/
copyunix(howto, devtype, io)
	register howto, io;
{
	struct exec x;
	register int i;
	char *addr;
	register int baseaddr;	       /* segment base address */
	register int bootstart = BASEMASK & fnaddr(main);
	register int size;
	extern char end;

	i = read(io, (char *) & x, sizeof x);
	if (i != sizeof x ||
	    (x.a_magic != 0407 && x.a_magic != 0413 && x.a_magic != 0410))
		_stop("Bad format\n");
	size = x.a_text+x.a_data;
	baseaddr = ((int)x.a_entry) & BASEMASK;	/* same base as entry */
/*
 * following allows boot to boot itself without overwritting itself (which
 * tends not to work very well).
 */
	if (INSIDE(baseaddr,bootstart,&end) ||
			INSIDE(bootstart, baseaddr, baseaddr+size)) {
		register int newbase = baseaddr ^ 0x80000;
		printf("would overlay boot - loading at %x rather than %x\n", newbase, baseaddr);
		baseaddr = newbase;    /* hope it's relocatable! */
		x.a_entry = (x.a_entry & ~BASEMASK) + baseaddr;
	}

/*	printf("baseaddr=%x end=%x bootstart=%x bootend=%x\n",baseaddr,baseaddr+x.a_text+x.a_data+x.a_bss,bootstart,&end); /* DEBUGGING */
	/*
	 * test if program will overlap boot 
	 * first test if program start address is inside boot program
	 * then test if boot start address is inside program.
	 */
	if (INSIDE(baseaddr,bootstart,&end) ||
			INSIDE(bootstart, baseaddr, baseaddr+size))
		_stop("help: program overlaps boot!");
	/*
	 * now see if entire program (including bss) overlaps boot)
	 */
	if (INSIDE(bootstart, baseaddr, baseaddr+size+x.a_bss+BSS_SLOP)) {
		printf("bss would clobber boot; bss not cleared\n");
		x.a_bss = 0;
	}
	printf("%d", x.a_text);
	if (x.a_magic == 0413 && lseek(io, NBPG, 0) == -1)
		goto shread;
	/*
	 * protect the POST by splitting up any read the crosses the POST
	 * into three reads (refusing to read data into the POST.
	 */
	if (baseaddr <= POST_START && x.a_text > POST_END) {
		/* text will span the POST */
		register int len = POST_START - baseaddr;
		register char *p;
		char buff[POST_END - POST_START]; /* data for POST */

		if (read(io, (char *)baseaddr, len) != len)
			goto shread;   /* read up to POST */
		if (read(io, buff, POST_END - POST_START) != POST_END - POST_START)
			goto shread;   /* read POST */
		for (len = 0, p = buff; p < buff + POST_END - POST_START; ++p)
			if (*p)
				++len;
		if (len)
			printf("(%d non-zero POST)", len);
		else
			printf("*");   /* POST ok marker */
		len = x.a_text - (POST_END - baseaddr);
		if (read(io, (char *)POST_END, len) != len)
			goto shread;
	} else if (baseaddr + x.a_text < POST_END)
		printf("text/data inside POST\n");
	else			       /* fall thru to the normal case */

	if (read(io, (char *)baseaddr, x.a_text) != x.a_text)
		goto shread;
	addr = (char *)x.a_text + baseaddr;
	if (x.a_magic == 0413 || x.a_magic == 0410)
		while ((int)addr & CLOFSET)
			*addr++ = 0;
	printf("+%d", x.a_data);
	if (read(io, addr, x.a_data) != x.a_data)
		goto shread;
	addr += x.a_data;
	printf("+%d", x.a_bss);
	if (x.a_bss)
		x.a_bss += BSS_SLOP;	       /* slop */
	for (i = 0; i < x.a_bss; i++)
		*addr++ = 0;
	x.a_entry &= 0x0fffffff;       /* remove segment number */
	printf(" start 0x%x\n", x.a_entry);
	delay(100);		       /* give time to read it */
	if (howto&RB_LOAD)
		return;
	if (*(short *)x.a_entry != 0)
		{
		close(io);
		callabs(x.a_entry,howto,devtype);
		}
	_stop("Entry instruction zero");
shread:
	_stop("Short read\n");
}
