
/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION  1986,1987
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:hd.h 11.0$ */
/* $ACIS:hd.h 11.0$ */
/* $Source: /ibm/acis/usr/sys/standatr/RCS/hd.h,v $ */

#ifndef lint
static char *rcsidhd_atr = "$Header:hd.h 11.0$";
#endif

#define NHD	2
#define MAXHDBAD MAXBADBLKS	/* use config file information */
#define MAXTRANS (32 * 1024)	/* 32K max tranfser	*/

struct partab hdoff[NHD][8];	

#define CYL0	(hdinfo[unit]->pstart+BOOTCYLS)*hdinfo[unit]->ntpc*hdinfo[unit]->nspt

#define HD_OK	0		       /* ok result from check_error */
#define HD_BAD	1		       /* not ok */

#define PRINTF(format) printf format

/* Disk block definitions */

#define	BSIZE	DEV_BSIZE
#define	BSHIFT	DEV_BSHIFT

#define RETRY_COUNT	2	       /* number of times to retry errors */
#define NO_ADDR	0x80000000	       /* a non-existant address of adunload */

#define	DATA	data
#define ERR	err
#define PCMP	err
#define SCT	sct
#define	SNO	sno
#define	CYLL	cyll
#define CYLH	cylh
#define	SDH	sdh
#define	STAT	stat
#define	CMD	stat
#define INTR	intr

struct hddevice *adapters[NHD >> 1] = {
	(struct hddevice *)  0x000001f0, /* adapter 1 */
};

/* Partition table */

#define NHDST 6		       /* support 6 (1 dummy) drives (for now) */

struct partab hdinit_sizes[8] = {/* dummy disk for non-recognized types */
	0, 0,				  /* spare */
	0, 0,				  /* spare */
	34, 0,				  /* c - first two tracks */
	0, 0,				  /* spare */
	0, 0,				  /* spare */
	0, 0,				  /* spare */
	0, 0,				  /* spare */
	0, 0,				  /* spare */
}, hd40m_sizes[8] = {
	15884,	1,		/* A=cyl 1 thru 187 */
	10032,	188,		/* B=cyl 188 thru 306 */
	87040,	0,		/* C=cyl 0 thru 1023 */
	15884,	307,		/* D=cyl 307 thru 493 */
	0,	0,
	43945,	494,		/* F=cyl 494 thru 1010 */
	59840,	307,		/* G=cyl 307 thru 1010 */
	0,	0,
}, hd70m_sizes[8] = {
	15884, 1,		/* A=cyl 1 thru 117 */
	33440, 118,		/* B=cyl 118 thru 363 */
	139264, 0,		/* C=cyl 0 thru 1023 */
	15884, 364,		/* D=cyl 364 thru 480 */
	55936, 481,		/* E=cyl 481 thru 892 */
	16592, 893,		/* F=cyl 893 thru 1014 */
	88536, 364,		/* G=cyl 364 thru 1014 */
	0, 0,
}, hd40r_sizes[8] = {
	15884,	1,		/* A=cyl 1 thru 134 */
	10032,	135,		/* B=cyl 135 thru 219 */
	87227,	0,		/* C=cyl 0 thru 732 */
	15884,	220,		/* D=cyl 220 thru 353 */
	0,	0,
	43911,	354,		/* F=cyl 354 thru 722 */
	59857,	220,		/* G=cyl 220 thru 722 */
	87227,	0,		/* H=cyl 0 thru 732 */
}, hd70c_sizes[8] = {
	15884,	1,		/* A=cyl 1 thru 104 */
	33440,	105,		/* B=cyl 105 thru 323 */
	141525,	0,		/* C=cyl 0 thru 924 */
	15884,	324,		/* D=cyl 324 thru 427 */
	55936,	428,		/* E=cyl 428 thru 793 */
	18819,	794,		/* F=cyl 794 thru 916 */
	90729,	324,		/* G=cyl 324 thru 916 */
	0,	0,
}, hd70r_sizes[8] = {
	15884,	1,		/* A=cyl 1 thru 64 */
	33440,	65,		/* B=cyl 65 thru 197 */
	142632,	0,		/* C=cyl 0 thru 565 */
	15884,	198,		/* D=cyl 198 thru 261 */
	55936,	262,		/* E=cyl 262 thru 483 */
	19404,	484,		/* F=cyl 484 thru 560 */
	91476,	198,		/* G=cyl 198 thru 560 */
	0,	0,
}, hd20i_sizes[8] = {		/* DBB This is AT BIOS drive type 2 */
	15844,	2,		/* A=cyl 2 thru 234 */
	8908, 	235,		/* B=cyl 235 thru 365 */
	41752,	0,		/* C=cyl 0 thru 613 */
	0,	0,
	0,	0,
	0,	0,
	15844,	366,		/* G=cyl 366 thru 598 */
	0,	0,
};



			/* st structures for atr drives */
struct atr_hdst {
	struct partab *off;	       /* partition table */
	u_short ncpd;		       /* number of cylinders / drive */
	u_short nbps;		       /* number of bytes / sector */
	u_char nspt;		       /* number of sectors / track */
	u_char ntpc;		       /* number of tracks / cylinder */
	u_short nspc;		       /* number of sectors / cylinder */
	u_long partoff;		       /* offset of 4.2 partition (in blocks) */
} atr_hdst[2] = {

 /*
 *
 *     off	ncpd	nbps	nspt	ntpc	nspc 
 */

   { hdoff[0],	0,  	0,  	0,	0, 	0 },	/* ATR disk 0 */
   { hdoff[1],	0,  	0,  	0,	0, 	0 },	/* ATR disk 1 */
};

struct hdst {

	struct partab *off;	       /* 0: partition table */
	u_short ncpd;		       /* 4: number of cylinders / drive */
	u_short pcmp;		       /* 6: write precompensation cylinder */
	u_short nbps;		       /* 8: number of bytes / sector */
	u_char nspt;		       /* 10: number of sectors / track */
	u_char ntpc;		       /* 11: number of tracks / cylinder */
	u_short nspc;		       /* 12: number of sectors / cylinder */
	u_short step;		       /* 14: drive stepping rate */
	/* 16 total */

} hdst[NHDST+NHD] = {

/*
 * hdinit_sizes is a dummy record that will work with all disks enough
 * to read the configuration record. It must be first in the following table.
 *
 *	     off	ncpd	pcmp	nbps	nspt	ntpc	nspc	step 
 */

	{ hdinit_sizes,	1,	1024,	512,	17,	2,	17 * 2,	0 },	/* 70 MB */
	{ hd70m_sizes,	1024,	1024,	512,	17,	8,	17 * 8,	0 },	/* 70 MB */
	{ hd40m_sizes,	1024,	1024,	512,	17,	5,	17 * 5,	0 },	/* 40 MB */
	{ hd40r_sizes,	733,	300,	512,	17,	7,	17 * 7,	0 },	 /* 40MB IBM */
	{ hd70c_sizes,	925,	925,	512,	17,	9,	17 * 9,	0 },	/* 70 MB */
	{ hd70r_sizes,	566,	300,	512,	36,	7,	36 * 7,	0 },	 /* 70MB IBM */
	{ hd20i_sizes,	615,	300,	512,	17,	4, 	17 * 4, 0 },	/* 20 MB */
};

char hdtype_names[NHDST+NHD][8] = {
	"hdinit", "hd70m", "hd40m", "hd40r", "hd70c", "hd70r", "hd20i",
};

int hd_type[NHD];		       /* type drive types (index into hdst) */
int hd_disk_op = 0;
int hd_drive_stat[NHD];  
#define	HD_INIT		0x0001
#define HD_BBSET	0x0002
char hd_ecc_msgs;
int hderrblk;			       /* the current block number in error */

#ifdef DEBUG
#define HDDEBUG(how,stmt) if (hddebug & (how)) stmt	/* print it */
#else
#define HDDEBUG(how,stmt)	/* do nothing */
#endif

#define	SHOW_STRAT	0x01
#define SHOW_START	0x02
#define SHOW_REGS	0x04
#define SHOW_INIT	0x08
#define SHOW_WAIT	0x10
#define SHOW_COUNT	0x20
#define SHOW_XFER	0x40
#define SHOW_ORDWR	0x80
#define SHOW_BAD	0x800
#define SHOW_CONFIG	0x2000
#define SHOW_IOCTL	0x4000

struct hdbad  *hdbad[NHD];       /* the drives bad sector maps */

struct pc_dpl hd_dpl[NHD];

int hddebug;
int hdquiet;
int hdquietinit;	/* To satisfy RT hd.c ??? (sigh) */

