/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1987,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:pcparam.h 12.0$ */
/* $ACIS:pcparam.h 12.0$ */
/* $Source: /ibm/acis/usr/sys/pc_code/RCS/pcparam.h,v $ */

#if !defined(lint) && !defined(LOCORE)	&& defined(RCS_HDRS)
static char    *rcsidpcparam = "$Header:pcparam.h 12.0$";
#endif

#ifdef ABIOS
#define NOMALLOC
#endif /* ABIOS */

#if !defined(FUN_DCL) && !defined(OS2_CODE)
#include "fun_dcl.h"
#endif /* FUNDCL */


typedef unsigned long u_long;
typedef unsigned short u_short;
typedef unsigned char u_char;
typedef unsigned long paddr_t;	/* Physical Address Type  */
typedef char far *caddr_t;	/* Far Character	Pointer */

#define SETBIT(reg,bit) outp((reg),(bit|8))	/* set a reg bit on */
#define RSETBIT(reg,bit) outp((reg),(bit))	/* set a reg bit off */
#define RSETALL(reg) outp((reg),0x10)	/* reset all bits */


#ifdef __HIGHC__
/* following are for compiling on ROMP under hc */
#define LOBYTE(x)	((x)&0xff)
#define HIBYTE(x)	(((x)>>8)&0xff)
#define LOWORD(X)	(((long)X)&0xffff)
#define HIWORD(X)	(((long)X>>16)&0xffff)
#else
#define LOBYTE(X)	(((unsigned char *)&X)[0])
#define HIBYTE(X)	(((unsigned char *)&X)[1])
#define LOWORD(X)	(((unsigned int *)&X)[0])
#define HIWORD(X)	(((unsigned int *)&X)[1])
#endif
#define MAKEPADDR(s,o) ((((paddr_t)(s)<<4) + (u_short)o))
#define MAKESADDR(s,o) ((((paddr_t)(s)<<16) + (u_short)o))
#define BELL 007

#ifdef DEBUG
#define DEBUGF(cond,stmt) if (cond) stmt
#else
#define DEBUGF(cond,stmt)
#endif

#ifdef DEBUG
#define INITDEBUG  0x01
#define DISKDEBUG  0x02
#define BMDEBUG    0x04		/* Block Move messages */
#define BLIPDEBUG  0x08
#define MAINDEBUG  0x10
#define RDTDEBUG   0x20		/* On when debugging using RDT */
#define KBDDEBUG   0x40
#define BBTDEBUG   0x80
#define MOVDEBUG   0x100
#define BIOSDEBUG  0x200
#define MSDEBUG    0x400
#define UBDEBUG    0x800
#define MASKDEBUG  0x1000
#define OPDISKDEBUG  0x2000
#define LPDEBUG    0x4000
#define ABIOSDEBUG 0x8000
#define PCINTDEBUG 0x10000L
#define VGADEBUG   0x20000L
#define TAPEDEBUG  0x40000L
#define ALLDEBUG 0x7FFFFL
#define DEFAULTDEBUG BLIPDEBUG
#endif /* DEBUG */

/*
 *   Physical address for bootable version
 */


#define INITRETRY 10
#define MEMBLOCK  (1024 * 32)
#define QSIZE  0x10
#define UNIXPOST 0x800		/* Address of POST area on ROMP */
#define UNIXPOSTMISC 0xc00	/* Address of misc POST area on ROMP */
#define UNIXRESTART	0xa00	/* address of restart control block */
#define STACKSIZE 0x400


#define PCPLQADDR pcplqaddr_dos

/*
 * Use the same macro names for port access as the 4.2 code
 */

#define IOIN(p) inp(p)
#define IOOUT(p,v) outp(p,v)


/*
 * XXX Make this a function that provides a precice microsecond delay
 */

#define DELAY_COUNT 1
#define DELAY(n) {unsigned int i1=n,j; while(i1--) for(j=0;j<DELAY_COUNT;j++);}

#define FALSE 0
#define TRUE 0xff
#define NHD 2
#define NFD 3

#define MAXBADBLOCKS 100

/* PS/2 To Romp IRQ levels for drivers that have PS/2 code.  */
/* These IRQ levels DO NOT have to be the same as the actual */
 /* irq level that the adapter uses.			     */ 


#define KBIRQ 0x09		/* irq 1 info 1 */
#define MSIRQ 0x11		/* irq 1 info 2 */
#define SPIRQ 0x19		/* irq 1 info 3 */
#define UBIRQ 0x03
#define HDIRQ 0x05
#define FDIRQ 0x06
#define LPIRQ 0x07		/* line printer IRQ */

#define BIOSIRQ 0x07

#define FAKEPOLL(irq) (0x80 + (irq))

/*
 * Values used for the memconfig field in the config structure.
 * These values simulate the Memory Configuration Register of
 * the IBM RT PC. See the RT Hardware Tech. Ref. Vol.1 pg 5-73
 */

#define CONFIG2MB 0xfd
#define CONFIG4MB 0xf8
#define CONFIG8MB 0xfc

/*
 *  CPU types
 */
#define PS_2	 0
#define	AT	 1
#define OLD_AT   2
#define MODEL_80 3
