/* 
 * USC-ACSC UNIX Monitor: $Header:maskint.c 12.0$
 * Copyright University of Southern California, 1988
 */



#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <stdio.h>
#include <fcntl.h>
#include <io.h>
#include "pctype.h"
#include "pcparam.h"
#include "rb.h"
#include "os2data.h"

int	maskint_flag =  1;		/* default is no rompints */
extern	struct	mask_int old_mask;
static struct mask_int mdpl;

maskint(unixaddr)
u_long	unixaddr;
{

	struct mask_int *dplptr = &mdpl;
	int             i, rc;
	char far       *pcaddr;


	/*
	 * save the old mask
	 */
	old_mask.slave = mdpl.slave;
	old_mask.master = mdpl.master;

	/*
	 * First read the DPL down from Unix 
	 */

	i = sizeof(struct mask_int);
	pcaddr = (char far *) dplptr;

	rc = movein(unixaddr, pcaddr, i);
	if ( rc < 0  )printf("maskint movein error\n");
#ifdef	MASK_DEBUG	
	printf("maskint: master = %x slave = %x\n",(u_short)dplptr->master,
				(u_short)dplptr->slave);
#endif
	if (rc < 0)
	{
		printf("maskintreq: Can't read DPL\n");
	}

	/* don't do it now since standalone does not take it well */
/*
	if(((dplptr->master & 0xff) != 0) || ((dplptr->slave & 0xff) != 0)) 
						maskint_flag = 1;
	else maskint_flag = 0;
*/
	return (rc);
}
