/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/*
 * $Header:lan.h 12.0$
 * $ACIS:lan.h 12.0$
 * $Source: /ibm/acis/usr/sys/os2code/RCS/lan.h,v $
 * Copyright University of Southern California, 1988
 */

/* lan token ring adapter data */

struct lan_adapter {
	u_int	port;		/* the base port address */
	u_int	intr_level;	/* interrupt level */
	u_long	ram_addr;	/* address of Ram */
	u_long	mmio_addr;	/* mmio addr (ROM?) */
};

#define NO_LANS	2	/* maximum number of lan cards */

/* port addresses of primary and alternate lan cards */

#define PRIMARY_LAN	0xa20
#define ALT_LAN		0xa24

#define LAN_RESET(base)	(IOOUT((base)+1,0))
#define LAN_MMIO_ADDR(base) (u_long)(((u_long)((IOIN(base)&0xfc))<<11)+0x80000)

#define LAN_ACA_OFFSET	0x1e00	/* Attachment Control Area offset */
#define LAN_ACA_ADDR(adapter_data) (adapter_data.mmio_addr+LAN_ACA_OFFSET)

#define LAN_RAM_ADDR(base) (u_long)((u_long)((IOIN(base+2)&0xfe))<<12)

#define LAN_INT_TYPE(base)	(IOIN(base)&0x03)
#define LAN_INT_TTOLVL(t)	((t & 0x02 ? 8:0) + (t & 0x01 ? 1:0) + 2)

#define HIGH_WORD(l_word)	(u_int)(((u_long)(l_word) >> 16) & 0xffff)
#define LOW_WORD(l_word)	(u_int)((u_long)(l_word) & 0xffff)
