/*
 * USC-ACSC UNIX Monitor
 *
 * $Header:dio.h 12.0$
 * $ACIS:dio.h 12.0$
 * $Source: /ibm/acis/usr/sys/os2code/RCS/dio.h,v $
 * Copyright University of Southern California, 1988
 */



#define SECSIZE 512
#define DISK 0x13

#define DISKOP_RESET    0x00	/* reset the drive */
#define DISKOP_STATUS   0x01	/* get drive status */
#define DISKOP_READ     0x02	/* read request */
#define DISKOP_WRITE    0x03	/* write request */
#define DISKOP_VERIFY   0x04	/* verify request */
#define DISKOP_FORMAT   0x05	/* format request */
#define DISKOP_SMT      0x18	/* set media type for diskette format */


#define BBT_DIO 0x70
#define HD_RETRY_COUNT 5
#define FLOPPY_RETRY_COUNT 10
#define HD_STATUS_REG 0x1F7
#define HD_ERROR_REG  0x1F1
#define HD_SEC_CNT    0x1F2


#define DSDD 0x1		/* Double Sided Diskette drive */
#define HCDD 0x2		/* High Capacity Diskette drive */
#define PSDDLO 0x3		/* 720Kb 3.5 Diskette Drive */
#define PSDDHI 0x4		/* 1.44MB 3.5 Diskette Drive */

#define ISFLOPPY(drive) ((drive) < 128)

#define RESET(drive) io(DISKOP_RESET,drive, 0, 0, 0, 0, NULL)
#define DMAERROR(rc) ((rc & 0x00ff) == 0x0008)
#define BOOTRETRY 10		/* Number of times we try to read disk in
				 * loadboot */

#define BOOTCYLS 0		/* Number of cylinders used by boot record */

#define XTRACTCYL(C,S) ((u_short) ((((S) & 0xc0) << 2) | LOBYTE(C)))
