/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:rvdconst.h 12.0$ */
/* $ACIS:rvdconst.h 12.0$ */
/* $Source: /ibm/acis/usr/sys/netinet/RCS/rvdconst.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidrvdconst = "$Header:rvdconst.h 12.0$";
#endif


#define RVDVERSION	4	/* This implements protocol version 4 */

/* Size of RVD Block */
#define	RVDDSIZE	(1 << RVDDSHIFT) /* for now = 512 */
#define	RVDDSHIFT	9		/* Must be log(2) of RVDDSIZE */
#define	RVDDLONG	(RVDDSIZE >> 2)	/* size of RVD data in longwords */
#ifndef GWRVD
#define RVDMXBPP	2	/* Max RVD Blocks per packet */
#else
#define RVDMXBPP	1	/* Max RVD Blocks per packet */
#endif

#ifndef M_WAIT
#ifdef KERNEL
#include "../h/mbuf.h"
#else
#include <sys/mbuf.h>
#endif
#endif M_WAIT
#define	RVD_WAIT	M_WAIT
#define	RVD_DONT_WAIT	M_DONT_WAIT

/* IP protocol number */
/* #define	RVDPROTO	66 */
#define	RVDTTL		30

/* Packet types */
#define	RVDSPIN		1	/* SPIN-UP packet */
#define	RVDSDOWN	2	/* SPIN-DOWN packet */
#define	RVDREAD		3	/* READ packet */
#define	RVDWRITE	4	/* WRITE packet */
#define	RVDSTAT		5	/* Host requests server status */
#define	RVDHOST		6	/* Hosts status */
#define	RVDRESPIN	7	/* RESPIN-UP packet */
#define	RVDAUTHSPIN	8	/* AUTHSPIN-UP packet */
#define	RVDSPACK	17	/* Ack for SPIN-UP */
#define	RVDERROR	18	/* ERROR packet */
#define	RVDACK		19	/* Ack for SPIN-DOWN */
#define	RVDBLOCK	20	/* Block of data */
#define	RVDWACK		21	/* Ack for WRITE */
#define	RVDSSTAT	22	/* Servers status */
#define RVDHOSTR	23	/* Server requests host status */

/* masks for status word */
#define RVDSTVAL	0001	/* Not (Is data valid?) (i.e. if 0 then valid */
#define RVDSTCNT	0036	/* Count of tries on foreign end - 1 */
#define RVDSTADR	0040	/* Bad block address */
#define	RVDSTWRL	0100	/* Write attemped on read-only disk */
#define	RVDSTDIS	0200	/* Physical device disused. */

/* Opening modes */
#define	RVDMRO		0001	/* Read-only mode */
#define RVDMSHR		0002	/* Shared mode */
#define	RVDMEXC		0004	/* Exclusive mode */
#define	RVDHARD		0200	/* Hard spinup: Ored with one of other modes */

/* Error types */
#define	RVDENOER	0000	/* No error */
#define	RVDEND		0001	/* Non-existant drive */
#define	RVDEBPWD	0002	/* Bad password for mode */
#define	RVDEOMD		0003	/* Already open in a different mode */
#define	RVDECKSM	0004	/* Invalid Checksum */
#define	RVDEIDX		0005	/* Index correction */
#define	RVDEPACK	0006	/* Non-existant disk-pack */
#define	RVDESPN		0007	/* Drive already spun up */
#define	RVDEBMD		0010	/* Bad mode */
#define	RVDEPKT		0011	/* Unknown packet type */
#define	RVDENAH		0012	/* Non Active Host */
#define	RVDEXMD		0013	/* Pack already spun up in EXCLUSIVE mode */
#define	RVDEZBL		0014	/* Zero blocks requested */
#define	RVDETBL		0015	/* Too many blocks requested */
#define	RVDEPNM		0016	/* Pack not physically mounted */
#define	RVDETCG		0017	/* Too many connections for server to support */
#define	RVDETGH		0020	/* Too many connections for this host */
#define	RVDESNA		0021	/* Server not currently active */
#define	RVDEIDA		0022	/* Identical pack already spun up in this
				   drive, in the requested mode */
#define	RVDEPDIS	0023	/* Physical device disused. */
#define	RVDETBMD	0024	/* Temporarily bad mode */

/* Locally used errors */
#define	RVDETIM		0064	/* Timeout */
#define RVDEBVER	0065	/* Invalid version */
