#!/bin/sh -
# 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1987,1988
# LICENSED MATERIALS - PROPERTY OF IBM
# REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
# $Header:init.sh 12.0$
# $ACIS:init.sh 12.0$
# $Source: /ibm/acis/usr/sys/dist/etc/RCS/init.sh,v $ 
# installation menu
(
trap ":" 1 2 3 15

# environment
PATH=/etc:/usr/ucb:/bin:/usr/bin:/lib:/usr/ibm:.
export PATH
TERM=ibmapa8
export TERM

# special strings
REVISION='$Revision: 12.0 $'
export REVISION
CLEAR=" K"
export CLEAR
ESC=""
export ESC

if test -r /vmunix.atr
then
	ATR=1
	NAME="4.3/6152"
	HARDWARE="the IBM 6152 Academic System"
else
	ATR=0
	NAME="4.3/RT"
	HARDWARE="the IBM RT PC"
fi
export ATR
export NAME
export HARDWARE

# strings to eval
CONT='echo -n "Press any key to continue. "; wait="`onechar -n`"'
MAIN='echo -n "Press any key to return to main menu. "; wait="`onechar -n`"'
MENU='echo -n "Press any key to return to menu. "; wait="`onechar -n`"'
export CONT
export MAIN
export MENU

WelcomeSeen=0
RefreshMenu=1

while : top level menu
do
	case $WelcomeSeen in
	0)	install.welcome
		WelcomeSeen=1;;
	esac

	case $RefreshMenu in
	1)	install.mainmenu;;
	*)	RefreshMenu=1;;
	esac

	echo -n "Choice? "
	response="`onechar`"

	case "$response" in

	1)	echo
		again=1
		while :
		do
			echo -n "
Please enter the time and date in the format 'yymmddHHMM', where

	yy	is the last two digits of the year,
	mm	is the (two-digit) number of the month,
	dd	is the (two-digit) day of the month, and
	HHMM	is the time (Pacific Time Zone) on a 24-hour clock,

or just press Enter to leave the system clock unchanged.

Enter new date [yymmddHHMM] and press Enter: "
			read newdate junk
			date $newdate > /dev/null 2>&1
			case $? in
			0)	break;;	# displayed date
			2)	break;;	# set date
			1)	;;	# failed to set date
			esac
		done

		case "$newdate" in
		"")	echo "The system clock is unchanged.";;
		*)	echo "The system clock was set to: `date`";;
		esac
		eval $MAIN;;

	2)	echo
		install.driver && eval $MAIN;;

	3 | "$ESC" )
		while :
		do
			echo -n "Halt the system? [y/n] "
			case "`onechar`" in
			[Yy])	exec halt;;
			[Nn])	break;;
			*)	echo "Type 'y' to halt the system, or
     'n' to continue with the installation.";;
			esac
		done;;
	
	4)	echo "
Press <CTRL-D> to leave the Bourne shell"
		sh
		echo; eval $MAIN;;
	
	"")	RefreshMenu=0;;

	*)	echo '
Press "1" to change the system clock,
      "2" to proceed with installation,
      "3" to halt the system, or
      "4" for customized installation.'
		RefreshMenu=0;;

	esac
done
) < /dev/console > /dev/console 2>&1
