/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:xio.h 12.0$ */
/* $ACIS:xio.h 12.0$ */
/* $Source: /ibm/acis/usr/sys/cacons/RCS/xio.h,v $ */

#ifndef lint
static char *rcsidxio = "$Header:xio.h 12.0$";
#endif

/* 
 * xio.h  - X Window Manager I/O command definitions
 * Author:	David O. Bundy
 *		IBM
 *		IRIS/BROWN
 * Date:	Wed Sept 25 1985
 *
 *	derived from (vsio.h - VS100 I/O command definitions)
 *		Author:	Christopher A. Kent
 *			Digital Equipment Corporation
 *			Western Research Lab
 *		Date:	Tue Jun 21 1983
 */
static char rcs_id[] = "$Header:xio.h 12.0$";

/* 
 * Event queue entries
 */
#ifdef KERNEL
#include "../machinecons/qevent.h"
#else
#include <machinecons/qevent.h>
#endif

/*
 *	X IO Event queue information
 */
typedef struct _XIoAddr {
	short    status;
	XEvent  *ibuff;
	int	 iqsize;		/* may assume power of 2 */
	int	 ihead;			/* atomic write */
	int	 itail;			/* atomic read */
	XCursor mouse;			/* atomic read/write */
	XCursor hotspot;		/* atomic read/write */
	XBox	 mbox;			/* atomic read/write */
	int	make_break;		/* =0 then make =1 then break */
	short	mthreshold;		/* Mouse motion parameter */
	short	mscale;			/* Mouse scale factor (if negative
					   then do square).	*/
	MSBox	 hmbox;			/* Hide mouse box atomic read/write */
} XIoAddr;
typedef XIoAddr *XIoAddrAddr;

/*
 *	Event Queue Buffer Area
 */
#define XMAXEVQ		64		/* Must be a power of 2 */
#define EVROUND(x)	((x) & (XMAXEVQ - 1))

struct XBuffArea {
	XIoAddr xioa;
	XEvent	ibuff[XMAXEVQ];
	unsigned short color_plane;
};

#define XBASIZE		(sizeof (struct XBuffArea))
#define MagicXBuffAddr	0xEF000000

/* status defines in xioa structure */
#define X_BLT_IN_PROGRESS 1
#define SET_BLT_IN_PROGRESS(s)		(s)->status |= X_BLT_IN_PROGRESS
#define CLEAR_BLT_IN_PROGRESS(s)	(s)->status &= ~X_BLT_IN_PROGRESS

#define X_ISOPEN	1
#define TOY		((time.tv_sec * 100) + (time.tv_usec / 10000))

/* The break code of a make break key (All keys) */
#define BREAK		0xF0
