/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986,1987
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */

/* $Header:kbd_emul.h 12.0$ */
/* $ACIS:kbd_emul.h 12.0$ */
/* $Source: /ibm/acis/usr/sys/cacons/RCS/kbd_emul.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidkeyboard = "$Header:kbd_emul.h 12.0$";
#endif


#ifdef KERNEL
#include "../machinecons/kbde_codes.h"
#else
#include <machinecons/kbde_codes.h>
#endif KERNEL

#define KBD_STRING_SPACE (KBD_STRINGS * KBD_STRING_LENGTH)

#ifdef KERNEL

char getchar_char;			  /* the character to return */
int debug_key;


char kbd_strings[KBD_STRING_SPACE];	/* strings */
int kbd_string_ptr;		/* the current end of string area */
int kbd_string_cnt;		/* counter of number defined */
int kbd_state, make_break;
#endif KERNEL


/*
 * the following structure is used to return/set values for
 * each scan code 
 */
struct kbdarg {
char kbd_scan;				/* scan code */
char kbd_index;				/* the position to change */
char kbd_length;			/* the length following */
char kbd_text[KBD_STRING_LENGTH];	/* the text */
char kbd_end;				/* a null end flag just in case */
char kbd_type;				/* is it a meta function */
};

/*
 * this is the old structure left for compatibility
 */
struct kbdoarg {
char kbd_scan;				/* scan code */
char kbd_index;				/* the position to change */
char kbd_length;			/* the length following */
char kbd_text[KBD_STRING_LENGTH];	/* the text */
char kbd_end;				/* a null end flag just in case */
};


#define KBDCGET	_IOWR(k,0,struct kbdarg)	/* get current definition */
#define KBDCSET	_IOW(k,1,struct kbdarg)		/* set new definition */
#define KBDCOGET _IOWR(k,0,struct kbdoarg)	/* old get current definition */
#define KBDCOSET _IOW(k,1,struct kbdoarg)	/* old set new definition */
#define KBDCRESET	_IO(k,2)		/* reset keyboard to standard */
#define KBDCRST	_IO(k,3)			/* reset (clear) string table */
#define KBDCSSTD	_IO(k,4)		/* set standard table */
#define KBDSGET	_IOR(k,5,int)			/* get available string space */
#define KBDGCLICK	_IOR(k,6,int)		/*  get click */
#define KBDSCLICK	_IOW(k,7,int)		/*  set click */
#define KBDSSECURE	_IOW(k,8,int)		/* set secure bit */

#define KBD_INDEX_NORMAL	0		/* normal position */
#define KBD_INDEX_SHIFT		1		/* shifted */
#define KBD_INDEX_CAPS		2		/* caps'ed */
#define KBD_INDEX_CONTROL	3		/* control'ed */
#define KBD_INDEX_ALT		4		/* alt'ed */
#define KBD_INDEX_ACTION	5		/* action'ed */

#define	KBDE_OPEN		0x01		/* emulator is open */

#define CLICK_FREQ_HIGH 0x08	       /* click frequency */
#define CLICK_FREQ_LOW  0xc0	       /* click frequency */
#define CLICK_TIME 0x00		       /* minimal time */
