/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1987
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:display_debug.h 12.0$ */
/* $ACIS:display_debug.h 12.0$ */
/* $Source: /ibm/acis/usr/sys/ca_atr/RCS/display_debug.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsiddisplay_debug = "$Header:display_debug.h 12.0$";
#endif

/*******************************************/
/*					   */
/*   display_debug.h	1.0	87/06/15   */
/*					   */
/*******************************************/

/*  This include file is used to systematically trace through the
 *  various display device driver related code. Currently, the
 *  divice drivers that include this file are:
 *
 *  ca_atr/vga.c       - VGA adapter device driver
 *  ca_atr/ibm8514.c   - IBM8514/A adapater device driver
 *  ca_atr/pc_bios.c   - interface to IBM PC BIOS
 *  ca_atr/pc_afi.c    - interface to IBM PC Advance Function Interface
 */


/*---------------------------------------------------------------*
 * Variable display_debug contains the flags indicating which	 *
 * routines in the display oriented code to trace through.	 *
 *---------------------------------------------------------------*/

static long display_debug = 0;	      /* note: every file that includes this */
				      /*   file will have its own variable   */
				      /*   flag, display_debug. 	     */


/*---------------------------------------------------------------*
 * 'display_debug' flag settings                                 *
 *---------------------------------------------------------------*/

#define PCDRIVER_BIOS		  0x10000000  /* bits 31-28 of display_debug */
#define PCDRIVER_AFI		  0x20000000  /* indicates which PC DRIVER   */

#define DISPLAY_VGA		  0x01000000  /* bits 27-24 of display_debug */
#define DISPLAY_IBM8514 	  0x02000000  /* indicates which DISPLAY     */

#define ROUTINE_OPEN		  0x00010000  /* bits 23-16 of display_debug */
#define ROUTINE_CLOSE		  0x00020000  /* indicates which PC DRIVER   */
#define ROUTINE_IOCTL		  0x00040000  /* routine to trace.	     */
#define ROUTINE_INT		  0x00080000
#define ROUTINE_CALL		  0x00100000
#define ROUTINE_GETMEM		  0x00200000
#define ROUTINE_FREEMEM 	  0x00400000
#define ROUTINE_PCPROBE 	  0x00800000

#define ROUTINE_INIT_REGS	  0x00000001  /* bits 15-00 of display_debug */
#define ROUTINE_INIT		  0x00000002  /* indicates which DISPLAY     */
#define ROUTINE_CLEAR		  0x00000004  /* routine to trace.	     */
#define ROUTINE_ATTR		  0x00000008
#define ROUTINE_PUTC		  0x00000010
#define ROUTINE_BLANK		  0x00000020
#define ROUTINE_MOVE		  0x00000040
#define ROUTINE_POS_CRSR	  0x00000080
#define ROUTINE_PROBE		  0x00000100
#define ROUTINE_PAINT		  0x00000200
#define ROUTINE_COLOR		  0x00000400


/*---------------------------------------------------------------*
 * When DDEBUG is called, the first argument is one of the	 *
 * following defines to indicate which routine the instruction	 *
 * pointer is at. This 'routine' flag setting is AND'd with the  *
 * current debugging flags (display_debug). If these bits are	 *
 * set, debugging information os produced.			 *
 *---------------------------------------------------------------*/

/* within IBM PC BIOS interface device driver, ../ca_atr/pc_bios.c */
#define BIOS_OPEN		( PCDRIVER_BIOS    |  ROUTINE_OPEN	)
#define BIOS_CLOSE		( PCDRIVER_BIOS    |  ROUTINE_CLOSE	)
#define BIOS_IOCTL		( PCDRIVER_BIOS    |  ROUTINE_IOCTL	)
#define BIOS_INT		( PCDRIVER_BIOS    |  ROUTINE_INT	)
#define BIOS_CALL		( PCDRIVER_BIOS    |  ROUTINE_CALL	)
#define BIOS_GETMEM		( PCDRIVER_BIOS    |  ROUTINE_GETMEM	)
#define BIOS_FREEMEM		( PCDRIVER_BIOS    |  ROUTINE_FREEMEM	)
#define BIOS_PROBE		( PCDRIVER_BIOS    |  ROUTINE_PCPROBE	)

/* within IBM Advance Function Interface device driver, ../ca_atr/pc_afi.c */
#define AFI_OPEN		( PCDRIVER_AFI	   |  ROUTINE_OPEN	)
#define AFI_CLOSE		( PCDRIVER_AFI	   |  ROUTINE_CLOSE	)
#define AFI_IOCTL		( PCDRIVER_AFI	   |  ROUTINE_IOCTL	)
#define AFI_INT 		( PCDRIVER_AFI	   |  ROUTINE_INT	)
#define AFI_CALL		( PCDRIVER_AFI	   |  ROUTINE_CALL	)
#define AFI_GETMEM		( PCDRIVER_AFI	   |  ROUTINE_GETMEM	)
#define AFI_FREEMEM		( PCDRIVER_AFI	   |  ROUTINE_FREEMEM	)
#define AFI_PROBE		( PCDRIVER_AFI	   |  ROUTINE_PCPROBE	)

/* within IBM VGA device driver, ../ca_atr/vga.c */
#define VGA_INIT_REGS		( DISPLAY_VGA	   |  ROUTINE_INIT_REGS )
#define VGA_INIT		( DISPLAY_VGA	   |  ROUTINE_INIT	)
#define VGA_CLEAR		( DISPLAY_VGA	   |  ROUTINE_CLEAR	)
#define VGA_ATTR		( DISPLAY_VGA	   |  ROUTINE_ATTR	)
#define VGA_PUTC		( DISPLAY_VGA	   |  ROUTINE_PUTC	)
#define VGA_BLANK		( DISPLAY_VGA	   |  ROUTINE_BLANK	)
#define VGA_MOVE		( DISPLAY_VGA	   |  ROUTINE_MOVE	)
#define VGA_POS_CRSR		( DISPLAY_VGA	   |  ROUTINE_POS_CRSR	)
#define VGA_PROBE		( DISPLAY_VGA	   |  ROUTINE_PROBE	)
#define VGA_PAINT		( DISPLAY_VGA	   |  ROUTINE_PAINT	)
#define VGA_COLOR		( DISPLAY_VGA	   |  ROUTINE_COLOR	)

/* within IBM 8514 device driver, ../ca_atr/ibm8514.c */
#define IBM8514_INIT_REGS	( DISPLAY_IBM8514  |  ROUTINE_INIT_REGS )
#define IBM8514_INIT		( DISPLAY_IBM8514  |  ROUTINE_INIT	)
#define IBM8514_CLEAR		( DISPLAY_IBM8514  |  ROUTINE_CLEAR	)
#define IBM8514_ATTR		( DISPLAY_IBM8514  |  ROUTINE_ATTR	)
#define IBM8514_PUTC		( DISPLAY_IBM8514  |  ROUTINE_PUTC	)
#define IBM8514_BLANK		( DISPLAY_IBM8514  |  ROUTINE_BLANK	)
#define IBM8514_MOVE		( DISPLAY_IBM8514  |  ROUTINE_MOVE	)
#define IBM8514_POS_CRSR	( DISPLAY_IBM8514  |  ROUTINE_POS_CRSR	)
#define IBM8514_PROBE		( DISPLAY_IBM8514  |  ROUTINE_PROBE	)
#define IBM8514_PAINT		( DISPLAY_IBM8514  |  ROUTINE_PAINT	)
#define IBM8514_COLOR		( DISPLAY_IBM8514  |  ROUTINE_COLOR	)


/*---------------------------------------------------------------*
 *  Macro to produce debugging information			 *
 *---------------------------------------------------------------*/

#ifdef DEBUG
#define DDEBUG(routine, stmt) if ((display_debug & (routine)) == (routine)) stmt
#else
#define DDEBUG(routine, stmt)
#endif DEBUG
