/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:callback.er.c 12.0$ */
/* $ACIS:callback.er.c 12.0$ */
/* $Source: /ibm/acis/usr/sys/afsint/RCS/callback.er.c,v $ */

#ifndef lint
static char *rcsid = "$Header:callback.er.c 12.0$";
#endif

#include "../h/types.h"
#include "../h/socket.h"
#include "../h/file.h"
#include "../h/stat.h"
#include "../netinet/in.h"
#include "../h/time.h"
#include "../rpc/types.h"
#include "../rpc/xdr.h"

#define R_INTERNALS	1
#include "../afs/osi.h"
#include "../afs/r.h"
#undef R_INTERNALS

RCallBack_ExecuteRequest (conn, pb)
    register struct r_connection *conn;
    register struct r_packet *pb;
{
    register struct r_packet *pb2 = (struct r_packet *) 0;
    int op;

    if (!xdr_int(&pb->xdrs, &op)) goto fail;
    switch (op) {
#include		"../afsint/rvice.h"

#define		CALLBACK					200
#define		CALLBACKCONNECTBACK		201
#define		CALLBACKRECEIVEDSTORE	202
#define		CALLBACKBULK				203
#define NULL	0
	case CALLBACK: {
	    extern struct r_packet *_RCallBack();
	    pb2 = _RCallBack(conn, pb);
	    break;
	}
	case CALLBACKCONNECTBACK: {
	    extern struct r_packet *_RCallBackConnectBack();
	    pb2 = _RCallBackConnectBack(conn, pb);
	    break;
	}
	case CALLBACKRECEIVEDSTORE: {
	    extern struct r_packet *_RCallBackReceivedStore();
	    pb2 = _RCallBackReceivedStore(conn, pb);
	    break;
	}
	case CALLBACKBULK: {
	    extern struct r_packet *_RCallBackBulk();
	    pb2 = _RCallBackBulk(conn, pb);
	    break;
	}
	default:
	    r_FreePacket(pb);
	    ;
    }
    if (pb2 == (struct r_packet *) 1)
	/* Special case: caller will reply later. */
	return 0;
    if (pb2 != (struct r_packet *) 0) {
	r_SendResponse(conn, pb2);
	return 0;
    }
    pb = 0;
fail:
    if (pb != 0)
	r_FreePacket(pb);
    /* Clean up socket if anything went wrong. */
    r_NoResponse(conn);
    return -1;
}
