

struct boothdr {
char	boot_ibma[4];		/* 0: IBMA in EBCDIC */
long	boot_check;		/* 4: reserved */
short	boot_lastcyl;		/* 8: last available cyl number */
char	boot_lasttrack;		/* 10: last track number */
char	boot_lastsect;		/* 11: last sector number */
short	boot_sectorsize;	/* 12-13: block/sector size (bytes) */
char	boot_reserved1[4];	/* 14-18: reserved */
char	boot_interleave;	/* 19: interleave factor */
char	boot_reserved2[3];	/* 20-23: reserved */
int	boot_sectorcount;	/* 24-27: disk size */
long	boot_formatdate;	/* 28-31: reserved */
short	boot_cyl;		/* 32-33: cyl number of boot */
char	boot_track;		/* 34: track number of boot */
char	boot_sector;		/* 35: sector to boot */
long	boot_length;		/* 36-39: length in sectors */
long	boot_entry;		/* 40-43: entry point */
long	boot_vrmminidisk;	/* 44-47: block number of vrm minidisk */
long	boot_llp;		/* 48-51: Loadlist processor block number */
long	boot_vrmlength;		/* 52-55: length of VRM minidisk */
char	boot_fill[512-56];	/* reserved */
} ;




#define CONFIG_MAGIC	0xF8E9DACB 	/* configuration record magic # */
/*
 * hard disk configuration format 
 */
struct hdconfig
{				/* manufacturers configuration record */
int	conf_magic;		/* 0: always 0xF8E9DACB */
int	conf_sectorcount;	/* 4: number of sectors on device */
short	conf_landing;		/* 8: reserved */
char	conf_interleave;	/* 10: interleave */
char	conf_sectsize;		/* 11: sectors size 02 = 512 */
short	conf_lastcyl;		/* 12: last data cylinder */
char	conf_lasttrack;		/* 14: last head number */
char	conf_lastsect;		/* 15: last sector number */
char	conf_precomp;		/* 16: precomp or 0xff */
#define NOPCMP	0xff
char	conf_status;		/* 17: used by loadable post */
short	conf_maxcyl;		/* 18: last physical cyl */
#define conf_ce_cyl conf_maxcyl
short	conf_end_of_life;	/* 20: max # bad blocks */
struct seek_curve {
	short seek_x;		/* x position (cylinders?) */
	short seek_y;		/* y position (milliseconds?) */
	short seek_slope;	/* slope millseconds/cylinder?) */
} conf_seek[5];			/* 22-51: seek curve characeristics */
short	conf_size;		/* 52-53: approximate # megabytes */
char	conf_mfr;		/* 54: mfr code */
char	conf_adapter;		/* 55: adapter type */
#define HD_ADAPTER_AT		0x00
#define HD_ADAPTER_ESDI		0x01
#define HD_ADAPTER_HESDI	0x02
short	conf_srn;		/* 56-57: service request num */
char	conf_label;		/* 58: ascii drive type id */
char	conf_skew;		/* 59: head switch sector skewing */
short	conf_hidmax;		/* 60-61: max # hidden defects */
char	conf_fill1[256-62];	/* fill up to halfway */
char	conf_name[8];		/* 256-263: name of disk (ACIS) */
char	conf_fill2[512-264];	/* fill up to the end */
				/* 512: total size */
} ;

struct miniheader {
        long number;            /* number of entries */
        long level;             /* revision level */
        short unused;           /* index of next unused entry */
        short lastused;         /* index of entry most recently used */
        short first;            /* first entry */
        short last;             /* last entry index */
        long bad_block;         /* first bad block */
        long bad_size;          /* number of bad blocks */
        long unused2;           /* reserved */
        long unused3;           /* reserved */
};


struct minidisk {
        short previous;         /* 0 link to previous entry */
        short next;             /* 2 line to next entry */
        char name[4];           /* 4 name of minidisk */
        unsigned :32;           /* 8 */
        long date;              /* 12 the date of creation */
        short iodn;             /* 16 the IODN used */
#define nextfree iodn           /*      hokey way of doing it! */
        char blocksize;         /* 18 filesystem block size (bits 0-3) */
#define BLOCK_512       0
#define BLOCK_1024      1
#define BLOCK_2048      3
        char type;              /* 19 type flags */
#define TYPE_RESERVED   0x80    /* reserved */
#define TYPE_NOBADBLOCK 0x40    /* no bad block forwarding on this disk */
#define TYPE_PAGE       0x20    /* pageing space */
#define TYPE_FILE       0x10    /* AIX file system */
#define TYPE_AIX        0x08    /* AIX system minidisk */
#define TYPE_PC         0x04    /* coprocessor disk */
#define TYPE_VRM        0x02    /* VRM */
#define TYPE_IPL        0x01    /* IPL'able */
        long unused;            /* 20 */
        long start;             /* 24 start block of partition */
        long size;              /* 28 size of partition */
                                /* 32 total length */
};

