/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:signal.h 12.0$ */
/* $ACIS:signal.h 12.0$ */
/* $Source: /ibm/acis/usr/sys/h/RCS/signal.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidsignal = "$Header:signal.h 12.0$";
#endif

#ifdef STANDUTIL
#include "../h/nfs_defines.h"
#else
#if !defined(KERNEL) && !defined(STANDALONE)
#include <sys/nfs_defines.h>
#endif
#endif

/*
 * Copyright (c) 1982, 1986 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)signal.h	7.1 (Berkeley) 6/4/86
 */

#ifndef	NSIG
#define NSIG	32

#define	SIGHUP	1	/* hangup */
#define	SIGINT	2	/* interrupt */
#define	SIGQUIT	3	/* quit */
#define	SIGILL	4	/* illegal instruction (not reset when caught) */
#define	    ILL_RESAD_FAULT	0x0	/* reserved addressing fault */
#define	    ILL_PRIVIN_FAULT	0x1	/* privileged instruction fault */
#define	    ILL_RESOP_FAULT	0x2	/* reserved operand fault */
/* CHME, CHMS, CHMU are not yet given back to users reasonably */
#define	SIGTRAP	5	/* trace trap (not reset when caught) */
#define	SIGIOT	6	/* IOT instruction */
#define	SIGABRT	SIGIOT	/* compatibility */
#define	SIGEMT	7	/* EMT instruction */
#define	SIGFPE	8	/* floating point exception */
#define	    FPE_INTOVF_TRAP	0x1	/* integer overflow */
#define	    FPE_INTDIV_TRAP	0x2	/* integer divide by zero */
#define	    FPE_FLTOVF_TRAP	0x3	/* floating overflow */
#define	    FPE_FLTDIV_TRAP	0x4	/* floating/decimal divide by zero */
#define	    FPE_FLTUND_TRAP	0x5	/* floating underflow */
#define	    FPE_DECOVF_TRAP	0x6	/* decimal overflow */
#define	    FPE_SUBRNG_TRAP	0x7	/* subscript out of range */
#define	    FPE_FLTOVF_FAULT	0x8	/* floating overflow fault */
#define	    FPE_FLTDIV_FAULT	0x9	/* divide by zero floating fault */
#define	    FPE_FLTUND_FAULT	0xa	/* floating underflow fault */
#define	SIGKILL	9	/* kill (cannot be caught or ignored) */
#define	SIGBUS	10	/* bus error */
#define	SIGSEGV	11	/* segmentation violation */
#define	SIGSYS	12	/* bad argument to system call */
#define	SIGPIPE	13	/* write on a pipe with no one to read it */
#define	SIGALRM	14	/* alarm clock */
#define	SIGTERM	15	/* software termination signal from kill */
#define	SIGURG	16	/* urgent condition on IO channel */
#define	SIGSTOP	17	/* sendable stop signal not from tty */
#define	SIGTSTP	18	/* stop signal from tty */
#define	SIGCONT	19	/* continue a stopped process */
#define	SIGCHLD	20	/* to parent on child stop or exit */
#define	SIGCLD	SIGCHLD	/* compatibility */
#define	SIGTTIN	21	/* to readers pgrp upon background tty read */
#define	SIGTTOU	22	/* like TTIN for output if (tp->t_local&LTOSTOP) */
#define	SIGIO	23	/* input/output possible signal */
#define	SIGXCPU	24	/* exceeded CPU time limit */
#define	SIGXFSZ	25	/* exceeded file size limit */
#define	SIGVTALRM 26	/* virtual time alarm */
#define	SIGPROF	27	/* profiling time alarm */
#define SIGWINCH 28	/* window size changes */
#define SIGLOST 29 	/* resource lost (eg. VFS record-lock lost) */
#define SIGUSR1 30	/* user defined signal 1 */
#define SIGUSR2 31	/* user defined signal 2 */

#ifdef ibm032
/* screen control signals */
#define SIGRETRACT	SIGEMT		/* retract acces to the screen */
#define	SIGGRANT 	SIGUSR2		/* replace access to the screen */
#endif /* ibm032 */

#ifndef KERNEL
int	(*signal())();
#endif

/*
 * Signal vector "template" used in sigvec call.
 */
struct	sigvec {
	int	(*sv_handler)();	/* signal handler */
	int	sv_mask;		/* signal mask to apply */
	int	sv_flags;		/* see signal options below */
};
#define SV_ONSTACK	0x0001	/* take signal on signal stack */
#define SV_INTERRUPT	0x0002	/* do not restart system on signal return */
#define sv_onstack sv_flags	/* isn't compatibility wonderful! */

/*
 * Structure used in sigstack call.
 */
struct	sigstack {
	char	*ss_sp;			/* signal stack pointer */
	int	ss_onstack;		/* current status */
};

/*
 * Information pushed on stack when a signal is delivered.
 * This is used by the kernel to restore state following
 * execution of the signal handler.  It is also made available
 * to the handler to allow it to properly restore state if
 * a non-standard exit is performed.
 */
struct	sigcontext {
#ifdef __vax__
	int	sc_onstack;		/* sigstack state to restore */
	int	sc_mask;		/* signal mask to restore */
	int	sc_sp;			/* sp to restore */
	int	sc_fp;			/* fp to restore */
	int	sc_ap;			/* ap to restore */
	int	sc_pc;			/* pc to restore */
	int	sc_ps;			/* psl to restore */
#endif
#ifdef ibm032
#define MAXSIGREGS	27	/* (EX2_RSV-R0+1) number of regs passed to sighandler */
	int	sc_flags;		/* state to restore */
#define SC_ONSTACK	SV_ONSTACK	/* sc_flags:	on signal stack */
#define	SC_FLOATSAVE	0x8000		/* sc_flags:	floating point saved */
#define	SC_EXCEPTION	0x4000		/* sc_flags:	exception packets saved */
#define SC_RTFL		0x2000		/* sc_flags:	executing RTFL sequence */
#define sc_onstack sc_flags	/* isn't compatibility wonderful! */
	int	sc_mask;		/* signal mask to restore */
	int	sc_icscs;		/* Must be just before sc_regs! */
	int	sc_regs[MAXSIGREGS];	/* saved registers */
	int	sc_saveiar;		/* saved copy of IAR for RTFL */
/*
 * NOTE: the following values for subscripts are from machine/reg.h, but
 *	those defines are not used as they could conflict too easly with
 *	user programs that include this file and don't expect R0-R15 to
 *	be defined.
 */
#define	sc_iar	sc_regs[16]		/* IAR  */
#define sc_sp	sc_regs[1]		/* SP */
	char	*sc_floatsave;		/* SC_FLOATSAVE -> struct floatsave * */
#define sc_pc	sc_iar
#define sc_ps	sc_icscs
#endif
};

#define	BADSIG		(int (*)())-1
#define	SIG_DFL		(int (*)())0
#define	SIG_IGN		(int (*)())1

#ifdef KERNEL
#define	SIG_CATCH	(int (*)())2
#define	SIG_HOLD	(int (*)())3
#endif
#endif

/*
 * Macro for converting signal number to a mask suitable for
 * sigblock().
 */
#define sigmask(m)	(1 << ((m)-1))
#if defined(__cplusplus) || defined(__USE_FIXED_PROTOTYPES__)
extern int kill (long , int);
extern int raise (int);
#endif /* defined(__cplusplus) || defined(__USE_FIXED_PROTOTYPES__*/
