/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986,1987
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */

/* $Header:egatty.h 12.0$ */
/* $ACIS:egatty.h 12.0$ */
/* $Source: /ibm/acis/usr/sys/standca/RCS/egatty.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidegadefs = "$Header:egatty.h 12.0$";
#endif

/* Monocrome Console attribute byte definitions */
#define MONO_NORMAL_VIDEO	0x07	/* Normal Video */
#define MONO_REVERSE_VIDEO	0x70	/* Reverse Video */
#define MONO_UNDERLINE_VIDEO	0x01	/* under line */
#define MONO_HI_INTENSITY	0x08	/* High Intensity */
#define MONO_BLINK		0x80	/* blink bit */

/* Screen memory defintions */

#ifdef ATR
/*
 * For the ATR version of the system the screen buffer is really an
 * offset into the 128K byte window. We comptute this offset in
 * the probe routine, then place it into the static variable
 * ega_screen_buffer.
 */
#endif
#define SCREEN_BUFFER ((char *)0xf40b8000)

#define SCREEN_END	(SCREEN_BUFFER + SCREEN_SIZE)
#define EGA_SCREEN_LENGTH	25
#define EGA_SCREEN_WIDTH	80
#define EGA_NSWITCH		4
#define	EGA_SWITCH_BIT		0x10

/* sets Pointer where we are */
#define set_ptr(x, y) scrn_ptr = clines[y] + (x<<1)

/* EGA register I/O port addresses */

#define MISC_OUT	0x3C2		/* Miscellaneous Output register */
#define IN_STAT_0	0x3C2		/* Input Status 0 register */

/* Mode values for indexing the mode value table */
#ifndef IBMRTPC
#define EGA_MONO 	0	/* EGA/Mono display */
#define EGA_COLOR	1	/* EGA/CGD or ECD 80x25 char mode */
#define EGA_ENHANCED	2	/* EGA/ECD enhanced mode */
#define NMODES		3	/* number of modes */
#endif
#define NREGS			/* number of registers to be initialized */
