/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:vdconst.h 12.0$ */
/* $ACIS:vdconst.h 12.0$ */
/* $Source: /ibm/acis/usr/sys/caio/RCS/vdconst.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidvdconst = "$Header:vdconst.h 12.0$";
#endif


#include "../netinet/rvdconst.h"

#define	VD_CONTROL_UNIT	255	/* Only this unit can do ioctls */
#define	VD_CAPAB_LEN	32
#define	VD_NAME_LEN	32

#define STQLEN	127

/* Predicted time in msecs for a packet to get acked to avoid excessive
   retransmits on large requests. */
#define	VDPKTCOST 120

#define	FUTURE	(u_long)((long) -1)
#define	VD_WAIT		RVD_WAIT
#define	VD_DONT_WAIT	RVD_DONT_WAIT

#define	OFF		00	/* same as SPUNDOWN  */
#define	SPUNDOWN	00	/* Drive not currently active */
#define	UNUSED		01	/* Unitialized drive */
#define	SPINWAIT	02	/* Sent spin-up request, and waiting */
#define	SPUNUP		03	/* Spun up and active */
#define	SPINDWAIT	04	/* Sent a spin-down, waiting for an ACK */
#define	RESYNCH		05	/* Server has crashed. Trying to reconnect. */
#define CRASHED		06	/* Server has crashed. Disk unusable for now. */

#define	VDTIM		10	/* Retransmit and cleanup every 10 seconds */
#define	VDRTIM		VDTIM	/* Reads get retransmitted often */
#define	VDWTIM		5*VDTIM	/* Writes, not so often... */
#define	VDMAXWTRY	18	/* writes trys  */
#define	VDMAXRTRY	5	/* reads trys */
#define	VDSPINTRY	5	/* spinups and spindowns tries*/
#define VDMAXTRY	60	/* Retries before declare server down */
#define	VDSPINTIM	55	/* How much shorter we wait for server on
				 * spinups than for regular blocks. For
				 * example, if VDMAXTRY is 60 and VDSPINTIM
				 * is 40, then we wait 60 * VDTIM seconds for
				 * the server to time out if we have blocks 
				 * in progress, but only 20 * VDTIM seconds if
				 * we are waiting for it to spin up.
				 */
#define VDBSIZE	RVDDSIZE	/* Number of bytes in virtual disk block */
#define VDBSHIFT	RVDDSHIFT	/* log base 2 of VDBSIZE, for shifting purposes */

#ifndef VDMAXBURST
/* VDMAXBURST Now defined in buf.h */
/* #include "../h/buf.h"*/
#define VDMAXBURST	32	/* Must be sizeof(buf.b_bitmap) in bits */
				/* Max number of blocks in a single transfer */
#endif

#define	VDMAXBF		RVDMXBPP	/* Virtual disk max blocking factor */

#define	NOTSEEN		0
#define	INBURST		1
