/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986,1987
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */

/* $Header:keyboard.h 12.0$ */
/* $ACIS:keyboard.h 12.0$ */
/* $Source: /ibm/acis/usr/sys/cacons/RCS/keyboard.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidkeyboard = "$Header:keyboard.h 12.0$";
#endif

#define CLICK_OFF	0x00
#define CLICK_HARD	0x01		/* hardware click */
#define CLICK_SOFT	0x02		/* software click */
#define CLICK_BOTH	0x03		/* both (dumb) */
#define	KBDPRI		(PZERO+5)

#ifdef KERNEL
int _init_kbd;				  /* flag to determine if init_kbd done */
int kbd_state, make_break;		/* from kbd_emul.h */
#endif

#define KBDMAXCOUNT	5
#ifdef KERNEL
struct kbdq {
	struct kbdq	*qp_next;
	struct klsq	cmd[KBDMAXCOUNT];
	int		count;
	int		ercnt;
	int		maxcnt;
	int		(*free)();
};

#define KBDPOOLSZ	4
#define	KBD_LED_QUEUED	0x01
#define	KBD_LED_WAIT	0x02
#endif

#define MONO_SHIFT1 		0x12
#define MONO_SHIFT2		0x59
#define MONO_ALT1		0x19
#define MONO_ALT2		0x39
#define MONO_CAPS_LOCK		0x14
#define MONO_CNTRL		0x11
#define MONO_PAUSE		0x62
#define MONO_PRINT		0x57
#define MONO_NUM_LOCK		0x76
#define MONO_SCROLL_LOCK	0x5f
#define MONO_ESC		0x08
#define MONO_ACTION		0x58

#define SHIFT1_MODE	0x01		/*  shift mode */
#define CAPS_MODE	0x02		/* caps mode */
#define CTL_MODE	0x04		/* control mode */
#define ALT1_MODE	0x08		/* alt mode */
#define ACTION_MODE	0x10		/* action mode */
#define NUM_LOCK_MODE	0x20		/* num-lock mode */
#define SWAP_MODE	0x40		/* if swapping functions */
#define SET_MODE	0x80		/* set pf key */
/* scroll lock is TT_STOP which is 0x100 */
#define KBD_SECURE	0x200		/* secure bit is on */
#define SHIFT2_MODE	0x400		/*  shift mode */
#define ALT2_MODE	0x800		/*  shift mode */

#ifdef ATR
#ifdef OLD_KB_FLAGS
/*  GRL DEBUG */
#define CAPS_MODE	0x01	       /*  caps mode */
#define ALT_MODE	0x02	       /* alt mode */
#define CAPS_LOCK	0x08		/* caps lock */
#endif
#endif
