/* $Header:kbde_codes.h 12.0$ */
/* $ACIS:kbde_codes.h 12.0$ */
/* $Source: /ibm/acis/usr/sys/cacons/RCS/kbde_codes.h,v $ */
 
#if !defined(lint) && !defined(LOCORE)  && defined(RCS_HDRS)
static char *rcsidkbde_codes = "$Header:kbde_codes.h 12.0$";
#endif
 
#define FN_IGNORE  (META+0)
#define FN_BREAK   (META+1)
#define FN_SHIFT   (META+2)
#define FN_CONTROL (META+3)
#define FN_ALT     (META+4)
#define FN_NUM_LOCK (META+5)
#define FN_CAPS_LOCK (META+6)
#define FN_ACTION  (META+7)
#define FN_DEBUG   (META+8)
#define FN_CLICK   (META+9)
#define FN_PRINT   (META+10)
#define FN_LOG     (META+11)
#define FN_SCROLL  (META+12)
#define FN_SWITCH  (META+13)
#define FN_SWRESET (META+14)
#define FN_KILL    (META+15)
#define FN_SWAP    (META+16)
#define FN_BEEP    (META+17)
#define FN_RESET   (META+18)
#define FN_SET     (META+19)
#define FN_SHIFT2  (META+20)
#define FN_ALT2    (META+21)
#define	FN_SHIFT1	FN_SHIFT
#define FN_ALT1		FN_ALT
#define MAX_CODE_LENGTH	3		/* number of characters per key entry*/
#define MAX_CHAR_LENGTH	2		/* number of characters per key */
#define KBD_STRING_LENGTH	32	/* maximum string length */
#define KBD_STRINGS		100	/* number of kbd strings of max len */
#define META	0x80			/* meta flag */
#define META_STRING	0x40		/* meta string */
#define ISSTRING(p) ((p)&META_STRING)
#define NONE	FN_IGNORE	/* other possible choice is FN_BEEP */
#define MAX_CODES  96
#define MAX_TYPES  6
#ifdef KERNEL
char code_map[256];	/* working code map */ 
char std_code_map[256]  = {	/* standard code map */
FN_IGNORE,          	/*   0 0x00  */
FN_IGNORE,          	/*   1 0x01  */
FN_IGNORE,          	/*   2 0x02  */
FN_IGNORE,          	/*   3 0x03  */
FN_IGNORE,          	/*   4 0x04  */
FN_IGNORE,          	/*   5 0x05  */
FN_IGNORE,          	/*   6 0x06  */
56,                 	/*   7 0x07  "\033S" "\033I" "\033S" {NONE} {NONE} {NONE} f1 */
46,                 	/*   8 0x08  "\33" "\33" "\33" "\33" {NONE} {NONE} esc */
FN_IGNORE,          	/*   9 0x09  */
FN_IGNORE,          	/*  10 0x0a  */
FN_IGNORE,          	/*  11 0x0b  */
FN_IGNORE,          	/*  12 0x0c  */
72,                 	/*  13 0x0d  "\t" "\b" "\t" {NONE} {NONE} {NONE} tab */
74,                 	/*  14 0x0e  "`" "~" "`" {NONE} {NONE} {NONE} */
57,                 	/*  15 0x0f  "\033T" "\033J" "\033T" {NONE} {NONE} {NONE} f2 */
FN_IGNORE,          	/*  16 0x10  */
FN_CONTROL,         	/*  17 0x11  meta FN_CONTROL ctrl */
FN_SHIFT,           	/*  18 0x12  meta FN_SHIFT shift1 */
93,                 	/*  19 0x13  {NONE} {NONE} {NONE} {NONE} {NONE} {NONE} world-trade-key */
FN_CAPS_LOCK,       	/*  20 0x14  meta FN_CAPS_LOCK caps-lock */
16,                 	/*  21 0x15  "q" "Q" "Q" "\21" {NONE} {NONE} */
27,                 	/*  22 0x16  "1" "!" "1" {NONE} {NONE} {NONE} */
58,                 	/*  23 0x17  "\033U" "\033K" "\033U" {NONE} {NONE} {NONE} f3 */
FN_IGNORE,          	/*  24 0x18  */
FN_ALT,             	/*  25 0x19  meta FN_ALT alt1 */
25,                 	/*  26 0x1a  "z" "Z" "Z" "\32" {NONE} {NONE} */
18,                 	/*  27 0x1b  "s" "S" "S" "\23" {NONE} {NONE} */
0,                  	/*  28 0x1c  "a" "A" "A" "\1" {NONE} {NONE} */
22,                 	/*  29 0x1d  "w" "W" "W" "\27" {NONE} {NONE} */
28,                 	/*  30 0x1e  "2" "@" "2" "\0" {NONE} {NONE} */
59,                 	/*  31 0x1f  "\033V" "\033L" "\033V" {NONE} {NONE} {NONE} f4 */
FN_IGNORE,          	/*  32 0x20  */
2,                  	/*  33 0x21  "c" "C" "C" "\3" {NONE} {NONE} */
23,                 	/*  34 0x22  "x" "X" "X" "\30" {NONE} {NONE} */
3,                  	/*  35 0x23  "d" "D" "D" "\4" {NONE} {NONE} */
4,                  	/*  36 0x24  "e" "E" "E" "\5" {NONE} {NONE} */
30,                 	/*  37 0x25  "4" "$" "4" {NONE} {NONE} {NONE} */
29,                 	/*  38 0x26  "3" "#" "3" {NONE} {NONE} {NONE} */
60,                 	/*  39 0x27  "\033W" "\033M" "\033W" {NONE} {NONE} {NONE} f5 */
FN_IGNORE,          	/*  40 0x28  */
47,                 	/*  41 0x29  "\40" "\40" "\40" "\40" {NONE} {NONE} space */
21,                 	/*  42 0x2a  "v" "V" "V" "\26" {NONE} {NONE} */
5,                  	/*  43 0x2b  "f" "F" "F" "\6" {NONE} {NONE} */
19,                 	/*  44 0x2c  "t" "T" "T" "\24" {NONE} {NONE} */
17,                 	/*  45 0x2d  "r" "R" "R" "\22" {NONE} {NONE} */
31,                 	/*  46 0x2e  "5" "%" "5" {NONE} {NONE} {NONE} */
61,                 	/*  47 0x2f  "\033P" "\033N" "\033P" {NONE} {NONE} {NONE} f6 */
FN_IGNORE,          	/*  48 0x30  */
13,                 	/*  49 0x31  "n" "N" "N" "\16" {NONE} {NONE} */
1,                  	/*  50 0x32  "b" "B" "B" "\2" {NONE} {NONE} */
7,                  	/*  51 0x33  "h" "H" "H" "\10" {NONE} {NONE} */
6,                  	/*  52 0x34  "g" "G" "G" "\7" {NONE} {NONE} */
24,                 	/*  53 0x35  "y" "Y" "Y" "\31" {NONE} {NONE} */
32,                 	/*  54 0x36  "6" "^" "6" "\36" {NONE} {NONE} */
62,                 	/*  55 0x37  "\033Q" "\033O" "\033Q" {NONE} {NONE} {NONE} f7 */
FN_IGNORE,          	/*  56 0x38  */
FN_ALT2,            	/*  57 0x39  meta FN_ALT2 alt2 */
12,                 	/*  58 0x3a  "m" "M" "M" "\15" {NONE} {NONE} */
9,                  	/*  59 0x3b  "j" "J" "J" "\12" {NONE} {NONE} */
20,                 	/*  60 0x3c  "u" "U" "U" "\25" {NONE} {NONE} */
33,                 	/*  61 0x3d  "7" "&" "7" {NONE} {NONE} {NONE} */
34,                 	/*  62 0x3e  "8" "*" "8" {NONE} {NONE} {NONE} */
63,                 	/*  63 0x3f  "\033R" "\033X" "\033R" {NONE} {NONE} {NONE} f8 */
FN_IGNORE,          	/*  64 0x40  */
40,                 	/*  65 0x41  "," "<" "," {NONE} {NONE} {NONE} */
10,                 	/*  66 0x42  "k" "K" "K" "\13" {NONE} {NONE} */
8,                  	/*  67 0x43  "i" "I" "I" "\11" {NONE} {NONE} */
14,                 	/*  68 0x44  "o" "O" "O" "\17" {NONE} {NONE} */
26,                 	/*  69 0x45  "0" ")" "0" {NONE} {NONE} {NONE} */
35,                 	/*  70 0x46  "9" "(" "9" {NONE} {NONE} {NONE} */
64,                 	/*  71 0x47  "\033Y" "\033-" "\033Y" {NONE} {NONE} {NONE} f9 */
FN_IGNORE,          	/*  72 0x48  */
42,                 	/*  73 0x49  "." ">" "." {NONE} {NONE} {NONE} */
43,                 	/*  74 0x4a  "/" "?" "/" {NONE} {NONE} {NONE} */
11,                 	/*  75 0x4b  "l" "L" "L" "\14" {NONE} {NONE} */
36,                 	/*  76 0x4c  ";" ":" ";" {NONE} {NONE} {NONE} */
15,                 	/*  77 0x4d  "p" "P" "P" "\20" {NONE} {NONE} */
41,                 	/*  78 0x4e  "-" "_" "-" "\37" {NONE} {NONE} */
65,                 	/*  79 0x4f  "\033<" "\033>" "\033<" {NONE} {NONE} {NONE} f10 */
FN_IGNORE,          	/*  80 0x50  */
FN_IGNORE,          	/*  81 0x51  */
39,                 	/*  82 0x52  "'" "\"" "'"" {NONE} {NONE} {NONE} */
94,                 	/*  83 0x53  {NONE} {NONE} {NONE} {NONE} {NONE} {NONE} world-trade-key */
38,                 	/*  84 0x54  "[" "{" "[" "\33" {NONE} {NONE} */
37,                 	/*  85 0x55  "=" "+" "=" {NONE} {NONE} {NONE} */
66,                 	/*  86 0x56  "\033[" "\033]" "\033[" {NONE} {NONE} {NONE} f11 */
92,                 	/*  87 0x57  {FN_PRINT} {NONE} {FN_PRINT} {FN_LOG} {NONE} {FN_SET} print-screen */
FN_ACTION,          	/*  88 0x58  meta FN_ACTION action */
FN_SHIFT2,          	/*  89 0x59  meta FN_SHIFT2 shift2 */
70,                 	/*  90 0x5a  "\r" "\r" "\r" "\r" {NONE} {NONE} enter */
73,                 	/*  91 0x5b  "]" "}" "]" "\35" {NONE} {NONE} */
68,                 	/*  92 0x5c  "\\" "|" "\\" "\34" {NONE} {NONE} */
FN_IGNORE,          	/*  93 0x5d  */
67,                 	/*  94 0x5e  "\033," "\033." "\033," {NONE} {NONE} {NONE} f12 */
90,                 	/*  95 0x5f  {FN_SCROLL} {FN_SWAP} {FN_SCROLL} {FN_SWRESET} {FN_SWITCH} {FN_CLICK} scroll-lock */
49,                 	/*  96 0x60  "\033B" "\033B" "\033B" {NONE} {NONE} {NONE} down-arrow */
51,                 	/*  97 0x61  "\033D" "\033D" "\033D" {NONE} {NONE} {NONE} left-arrow */
91,                 	/*  98 0x62  {FN_DEBUG} {FN_DEBUG} {FN_DEBUG} {NONE} {FN_KILL} {FN_RESET} pause/break */
48,                 	/*  99 0x63  "\033A" "\033A" "\033A" {NONE} {NONE} {NONE} up-arrow */
45,                 	/* 100 0x64  "\177" "\177" "\177" {NONE} {NONE} {NONE} delete */
53,                 	/* 101 0x65  "\033F" "\033f" "\033F" {NONE} {NONE} {NONE} end */
69,                 	/* 102 0x66  "\b" "\b" "\b" {NONE} {NONE} {NONE} backspace */
44,                 	/* 103 0x67  "\0" "\033\0" "\0" {NONE} {NONE} {NONE} insert */
FN_IGNORE,          	/* 104 0x68  */
76,                 	/* 105 0x69  "1" "1" "1" {NONE} {NONE} {NONE} num-1 */
50,                 	/* 106 0x6a  "\033C" "\033C" "\033C" {NONE} {NONE} {NONE} right-arrow */
79,                 	/* 107 0x6b  "4" "4" "4" {NONE} {NONE} {NONE} num-4 */
82,                 	/* 108 0x6c  "7" "7" "7" {NONE} {NONE} {NONE} num-7 */
52,                 	/* 109 0x6d  "\033E" "\033e" "\033E" {NONE} {NONE} {NONE} page-down */
55,                 	/* 110 0x6e  "\033H" "\033h" "\033H" {NONE} {NONE} {NONE} home */
54,                 	/* 111 0x6f  "\033G" "\033g" "\033G" {NONE} {NONE} {NONE} page-up */
75,                 	/* 112 0x70  "0" "0" "0" {NONE} {NONE} {NONE} num-0 */
88,                 	/* 113 0x71  "." "." "." {NONE} {NONE} {NONE} num-. */
77,                 	/* 114 0x72  "2" "2" "2" {NONE} {NONE} {NONE} num-2 */
80,                 	/* 115 0x73  "5" "5" "5" {NONE} {NONE} {NONE} num-5 */
81,                 	/* 116 0x74  "6" "6" "6" {NONE} {NONE} {NONE} num-6 */
83,                 	/* 117 0x75  "8" "8" "8" {NONE} {NONE} {NONE} num-8 */
FN_NUM_LOCK,        	/* 118 0x76  meta FN_NUM_LOCK num-lock */
89,                 	/* 119 0x77  "/" "/" "/" {NONE} {NONE} {NONE} num-/ */
FN_IGNORE,          	/* 120 0x78  */
71,                 	/* 121 0x79  "\r" "\r" "\r" "\r" {NONE} {NONE} num-enter */
78,                 	/* 122 0x7a  "3" "3" "3" {NONE} {NONE} {NONE} num-3 */
FN_IGNORE,          	/* 123 0x7b  */
86,                 	/* 124 0x7c  "+" "+" "+" {NONE} {NONE} {NONE} num-+ */
84,                 	/* 125 0x7d  "9" "9" "9" {NONE} {NONE} {NONE} num-9 */
85,                 	/* 126 0x7e  "*" "*" "*" {NONE} {NONE} {NONE} num-* */
FN_IGNORE,          	/* 127 0x7f  */
FN_IGNORE,          	/* 128 0x80  */
FN_IGNORE,          	/* 129 0x81  */
FN_IGNORE,          	/* 130 0x82  */
FN_IGNORE,          	/* 131 0x83  */
87,                 	/* 132 0x84  "-" "-" "-" {NONE} {NONE} {NONE} num-- */
FN_IGNORE,          	/* 133 0x85  */
FN_IGNORE,          	/* 134 0x86  */
FN_IGNORE,          	/* 135 0x87  */
FN_IGNORE,          	/* 136 0x88  */
FN_IGNORE,          	/* 137 0x89  */
FN_IGNORE,          	/* 138 0x8a  */
FN_IGNORE,          	/* 139 0x8b  */
FN_IGNORE,          	/* 140 0x8c  */
FN_IGNORE,          	/* 141 0x8d  */
FN_IGNORE,          	/* 142 0x8e  */
FN_IGNORE,          	/* 143 0x8f  */
FN_IGNORE,          	/* 144 0x90  */
FN_IGNORE,          	/* 145 0x91  */
FN_IGNORE,          	/* 146 0x92  */
FN_IGNORE,          	/* 147 0x93  */
FN_IGNORE,          	/* 148 0x94  */
FN_IGNORE,          	/* 149 0x95  */
FN_IGNORE,          	/* 150 0x96  */
FN_IGNORE,          	/* 151 0x97  */
FN_IGNORE,          	/* 152 0x98  */
FN_IGNORE,          	/* 153 0x99  */
FN_IGNORE,          	/* 154 0x9a  */
FN_IGNORE,          	/* 155 0x9b  */
FN_IGNORE,          	/* 156 0x9c  */
FN_IGNORE,          	/* 157 0x9d  */
FN_IGNORE,          	/* 158 0x9e  */
FN_IGNORE,          	/* 159 0x9f  */
FN_IGNORE,          	/* 160 0xa0  */
FN_IGNORE,          	/* 161 0xa1  */
FN_IGNORE,          	/* 162 0xa2  */
FN_IGNORE,          	/* 163 0xa3  */
FN_IGNORE,          	/* 164 0xa4  */
FN_IGNORE,          	/* 165 0xa5  */
FN_IGNORE,          	/* 166 0xa6  */
FN_IGNORE,          	/* 167 0xa7  */
FN_IGNORE,          	/* 168 0xa8  */
FN_IGNORE,          	/* 169 0xa9  */
FN_IGNORE,          	/* 170 0xaa  */
FN_IGNORE,          	/* 171 0xab  */
FN_IGNORE,          	/* 172 0xac  */
FN_IGNORE,          	/* 173 0xad  */
FN_IGNORE,          	/* 174 0xae  */
FN_IGNORE,          	/* 175 0xaf  */
FN_IGNORE,          	/* 176 0xb0  */
FN_IGNORE,          	/* 177 0xb1  */
FN_IGNORE,          	/* 178 0xb2  */
FN_IGNORE,          	/* 179 0xb3  */
FN_IGNORE,          	/* 180 0xb4  */
FN_IGNORE,          	/* 181 0xb5  */
FN_IGNORE,          	/* 182 0xb6  */
FN_IGNORE,          	/* 183 0xb7  */
FN_IGNORE,          	/* 184 0xb8  */
FN_IGNORE,          	/* 185 0xb9  */
FN_IGNORE,          	/* 186 0xba  */
FN_IGNORE,          	/* 187 0xbb  */
FN_IGNORE,          	/* 188 0xbc  */
FN_IGNORE,          	/* 189 0xbd  */
FN_IGNORE,          	/* 190 0xbe  */
FN_IGNORE,          	/* 191 0xbf  */
FN_IGNORE,          	/* 192 0xc0  */
FN_IGNORE,          	/* 193 0xc1  */
FN_IGNORE,          	/* 194 0xc2  */
FN_IGNORE,          	/* 195 0xc3  */
FN_IGNORE,          	/* 196 0xc4  */
FN_IGNORE,          	/* 197 0xc5  */
FN_IGNORE,          	/* 198 0xc6  */
FN_IGNORE,          	/* 199 0xc7  */
FN_IGNORE,          	/* 200 0xc8  */
FN_IGNORE,          	/* 201 0xc9  */
FN_IGNORE,          	/* 202 0xca  */
FN_IGNORE,          	/* 203 0xcb  */
FN_IGNORE,          	/* 204 0xcc  */
FN_IGNORE,          	/* 205 0xcd  */
FN_IGNORE,          	/* 206 0xce  */
FN_IGNORE,          	/* 207 0xcf  */
FN_IGNORE,          	/* 208 0xd0  */
FN_IGNORE,          	/* 209 0xd1  */
FN_IGNORE,          	/* 210 0xd2  */
FN_IGNORE,          	/* 211 0xd3  */
FN_IGNORE,          	/* 212 0xd4  */
FN_IGNORE,          	/* 213 0xd5  */
FN_IGNORE,          	/* 214 0xd6  */
FN_IGNORE,          	/* 215 0xd7  */
FN_IGNORE,          	/* 216 0xd8  */
FN_IGNORE,          	/* 217 0xd9  */
FN_IGNORE,          	/* 218 0xda  */
FN_IGNORE,          	/* 219 0xdb  */
FN_IGNORE,          	/* 220 0xdc  */
FN_IGNORE,          	/* 221 0xdd  */
FN_IGNORE,          	/* 222 0xde  */
FN_IGNORE,          	/* 223 0xdf  */
FN_IGNORE,          	/* 224 0xe0  */
FN_IGNORE,          	/* 225 0xe1  */
FN_IGNORE,          	/* 226 0xe2  */
FN_IGNORE,          	/* 227 0xe3  */
FN_IGNORE,          	/* 228 0xe4  */
FN_IGNORE,          	/* 229 0xe5  */
FN_IGNORE,          	/* 230 0xe6  */
FN_IGNORE,          	/* 231 0xe7  */
FN_IGNORE,          	/* 232 0xe8  */
FN_IGNORE,          	/* 233 0xe9  */
FN_IGNORE,          	/* 234 0xea  */
FN_IGNORE,          	/* 235 0xeb  */
FN_IGNORE,          	/* 236 0xec  */
FN_IGNORE,          	/* 237 0xed  */
FN_IGNORE,          	/* 238 0xee  */
FN_IGNORE,          	/* 239 0xef  */
FN_BREAK,           	/* 240 0xf0  meta FN_BREAK break */
FN_IGNORE,          	/* 241 0xf1  */
FN_IGNORE,          	/* 242 0xf2  */
FN_IGNORE,          	/* 243 0xf3  */
FN_IGNORE,          	/* 244 0xf4  */
FN_IGNORE,          	/* 245 0xf5  */
FN_IGNORE,          	/* 246 0xf6  */
FN_IGNORE,          	/* 247 0xf7  */
FN_IGNORE,          	/* 248 0xf8  */
FN_IGNORE,          	/* 249 0xf9  */
FN_IGNORE,          	/* 250 0xfa  */
FN_IGNORE,          	/* 251 0xfb  */
FN_IGNORE,          	/* 252 0xfc  */
FN_IGNORE,          	/* 253 0xfd  */
FN_IGNORE,          	/* 254 0xfe  */
FN_IGNORE           	/* 255 0xff  */
};
char kbde_codes[MAX_CODES][MAX_TYPES][MAX_CODE_LENGTH];
char std_codes[MAX_CODES][MAX_TYPES][MAX_CODE_LENGTH] = {
{ "\000a",   "\000A",   "\000A",   "\000\1",  {META,NONE},{META,NONE}, },  /*   0 */
{ "\000b",   "\000B",   "\000B",   "\000\2",  {META,NONE},{META,NONE}, },  /*   1 */
{ "\000c",   "\000C",   "\000C",   "\000\3",  {META,NONE},{META,NONE}, },  /*   2 */
{ "\000d",   "\000D",   "\000D",   "\000\4",  {META,NONE},{META,NONE}, },  /*   3 */
{ "\000e",   "\000E",   "\000E",   "\000\5",  {META,NONE},{META,NONE}, },  /*   4 */
{ "\000f",   "\000F",   "\000F",   "\000\6",  {META,NONE},{META,NONE}, },  /*   5 */
{ "\000g",   "\000G",   "\000G",   "\000\7",  {META,NONE},{META,NONE}, },  /*   6 */
{ "\000h",   "\000H",   "\000H",   "\000\10", {META,NONE},{META,NONE}, },  /*   7 */
{ "\000i",   "\000I",   "\000I",   "\000\11", {META,NONE},{META,NONE}, },  /*   8 */
{ "\000j",   "\000J",   "\000J",   "\000\12", {META,NONE},{META,NONE}, },  /*   9 */
{ "\000k",   "\000K",   "\000K",   "\000\13", {META,NONE},{META,NONE}, },  /*  10 */
{ "\000l",   "\000L",   "\000L",   "\000\14", {META,NONE},{META,NONE}, },  /*  11 */
{ "\000m",   "\000M",   "\000M",   "\000\15", {META,NONE},{META,NONE}, },  /*  12 */
{ "\000n",   "\000N",   "\000N",   "\000\16", {META,NONE},{META,NONE}, },  /*  13 */
{ "\000o",   "\000O",   "\000O",   "\000\17", {META,NONE},{META,NONE}, },  /*  14 */
{ "\000p",   "\000P",   "\000P",   "\000\20", {META,NONE},{META,NONE}, },  /*  15 */
{ "\000q",   "\000Q",   "\000Q",   "\000\21", {META,NONE},{META,NONE}, },  /*  16 */
{ "\000r",   "\000R",   "\000R",   "\000\22", {META,NONE},{META,NONE}, },  /*  17 */
{ "\000s",   "\000S",   "\000S",   "\000\23", {META,NONE},{META,NONE}, },  /*  18 */
{ "\000t",   "\000T",   "\000T",   "\000\24", {META,NONE},{META,NONE}, },  /*  19 */
{ "\000u",   "\000U",   "\000U",   "\000\25", {META,NONE},{META,NONE}, },  /*  20 */
{ "\000v",   "\000V",   "\000V",   "\000\26", {META,NONE},{META,NONE}, },  /*  21 */
{ "\000w",   "\000W",   "\000W",   "\000\27", {META,NONE},{META,NONE}, },  /*  22 */
{ "\000x",   "\000X",   "\000X",   "\000\30", {META,NONE},{META,NONE}, },  /*  23 */
{ "\000y",   "\000Y",   "\000Y",   "\000\31", {META,NONE},{META,NONE}, },  /*  24 */
{ "\000z",   "\000Z",   "\000Z",   "\000\32", {META,NONE},{META,NONE}, },  /*  25 */
{ "\0000",   "\000)",   "\0000",   {META,NONE},{META,NONE},{META,NONE}, },  /*  26 */
{ "\0001",   "\000!",   "\0001",   {META,NONE},{META,NONE},{META,NONE}, },  /*  27 */
{ "\0002",   "\000@",   "\0002",   "\000\0",  {META,NONE},{META,NONE}, },  /*  28 */
{ "\0003",   "\000#",   "\0003",   {META,NONE},{META,NONE},{META,NONE}, },  /*  29 */
{ "\0004",   "\000$",   "\0004",   {META,NONE},{META,NONE},{META,NONE}, },  /*  30 */
{ "\0005",   "\000%",   "\0005",   {META,NONE},{META,NONE},{META,NONE}, },  /*  31 */
{ "\0006",   "\000^",   "\0006",   "\000\36", {META,NONE},{META,NONE}, },  /*  32 */
{ "\0007",   "\000&",   "\0007",   {META,NONE},{META,NONE},{META,NONE}, },  /*  33 */
{ "\0008",   "\000*",   "\0008",   {META,NONE},{META,NONE},{META,NONE}, },  /*  34 */
{ "\0009",   "\000(",   "\0009",   {META,NONE},{META,NONE},{META,NONE}, },  /*  35 */
{ "\000;",   "\000:",   "\000;",   {META,NONE},{META,NONE},{META,NONE}, },  /*  36 */
{ "\000=",   "\000+",   "\000=",   {META,NONE},{META,NONE},{META,NONE}, },  /*  37 */
{ "\000[",   "\000{",   "\000[",   "\000\33", {META,NONE},{META,NONE}, },  /*  38 */
{ "\000'",   "\000\"",  "\000'",   {META,NONE},{META,NONE},{META,NONE}, },  /*  39 */
{ "\000,",   "\000<",   "\000,",   {META,NONE},{META,NONE},{META,NONE}, },  /*  40 */
{ "\000-",   "\000_",   "\000-",   "\000\37", {META,NONE},{META,NONE}, },  /*  41 */
{ "\000.",   "\000>",   "\000.",   {META,NONE},{META,NONE},{META,NONE}, },  /*  42 */
{ "\000/",   "\000?",   "\000/",   {META,NONE},{META,NONE},{META,NONE}, },  /*  43 */
{ "\000\0",  "\000\033\0","\000\0",  {META,NONE},{META,NONE},{META,NONE}, },  /*  44 insert */
{ "\000\177","\000\177","\000\177",{META,NONE},{META,NONE},{META,NONE}, },  /*  45 delete */
{ "\000\33", "\000\33", "\000\33", "\000\33", {META,NONE},{META,NONE}, },  /*  46 esc */
{ "\000\40", "\000\40", "\000\40", "\000\40", {META,NONE},{META,NONE}, },  /*  47 space */
{ "\000\033A","\000\033A","\000\033A",{META,NONE},{META,NONE},{META,NONE}, },  /*  48 up-arrow */
{ "\000\033B","\000\033B","\000\033B",{META,NONE},{META,NONE},{META,NONE}, },  /*  49 down-arrow */
{ "\000\033C","\000\033C","\000\033C",{META,NONE},{META,NONE},{META,NONE}, },  /*  50 right-arrow */
{ "\000\033D","\000\033D","\000\033D",{META,NONE},{META,NONE},{META,NONE}, },  /*  51 left-arrow */
{ "\000\033E","\000\033e","\000\033E",{META,NONE},{META,NONE},{META,NONE}, },  /*  52 page-down */
{ "\000\033F","\000\033f","\000\033F",{META,NONE},{META,NONE},{META,NONE}, },  /*  53 end */
{ "\000\033G","\000\033g","\000\033G",{META,NONE},{META,NONE},{META,NONE}, },  /*  54 page-up */
{ "\000\033H","\000\033h","\000\033H",{META,NONE},{META,NONE},{META,NONE}, },  /*  55 home */
{ "\000\033S","\000\033I","\000\033S",{META,NONE},{META,NONE},{META,NONE}, },  /*  56 f1 */
{ "\000\033T","\000\033J","\000\033T",{META,NONE},{META,NONE},{META,NONE}, },  /*  57 f2 */
{ "\000\033U","\000\033K","\000\033U",{META,NONE},{META,NONE},{META,NONE}, },  /*  58 f3 */
{ "\000\033V","\000\033L","\000\033V",{META,NONE},{META,NONE},{META,NONE}, },  /*  59 f4 */
{ "\000\033W","\000\033M","\000\033W",{META,NONE},{META,NONE},{META,NONE}, },  /*  60 f5 */
{ "\000\033P","\000\033N","\000\033P",{META,NONE},{META,NONE},{META,NONE}, },  /*  61 f6 */
{ "\000\033Q","\000\033O","\000\033Q",{META,NONE},{META,NONE},{META,NONE}, },  /*  62 f7 */
{ "\000\033R","\000\033X","\000\033R",{META,NONE},{META,NONE},{META,NONE}, },  /*  63 f8 */
{ "\000\033Y","\000\033-","\000\033Y",{META,NONE},{META,NONE},{META,NONE}, },  /*  64 f9 */
{ "\000\033<","\000\033>","\000\033<",{META,NONE},{META,NONE},{META,NONE}, },  /*  65 f10 */
{ "\000\033[","\000\033]","\000\033[",{META,NONE},{META,NONE},{META,NONE}, },  /*  66 f11 */
{ "\000\033,","\000\033.","\000\033,",{META,NONE},{META,NONE},{META,NONE}, },  /*  67 f12 */
{ "\000\\",  "\000|",   "\000\\",  "\000\34", {META,NONE},{META,NONE}, },  /*  68 */
{ "\000\b",  "\000\b",  "\000\b",  {META,NONE},{META,NONE},{META,NONE}, },  /*  69 backspace */
{ "\000\r",  "\000\r",  "\000\r",  "\000\r",  {META,NONE},{META,NONE}, },  /*  70 enter */
{ "\000\r",  "\000\r",  "\000\r",  "\000\r",  {META,NONE},{META,NONE}, },  /*  71 num-enter */
{ "\000\t",  "\000\b",  "\000\t",  {META,NONE},{META,NONE},{META,NONE}, },  /*  72 tab */
{ "\000]",   "\000}",   "\000]",   "\000\35", {META,NONE},{META,NONE}, },  /*  73 */
{ "\000`",   "\000~",   "\000`",   {META,NONE},{META,NONE},{META,NONE}, },  /*  74 */
{ "\0000",   "\0000",   "\0000",   {META,NONE},{META,NONE},{META,NONE}, },  /*  75 num-0 */
{ "\0001",   "\0001",   "\0001",   {META,NONE},{META,NONE},{META,NONE}, },  /*  76 num-1 */
{ "\0002",   "\0002",   "\0002",   {META,NONE},{META,NONE},{META,NONE}, },  /*  77 num-2 */
{ "\0003",   "\0003",   "\0003",   {META,NONE},{META,NONE},{META,NONE}, },  /*  78 num-3 */
{ "\0004",   "\0004",   "\0004",   {META,NONE},{META,NONE},{META,NONE}, },  /*  79 num-4 */
{ "\0005",   "\0005",   "\0005",   {META,NONE},{META,NONE},{META,NONE}, },  /*  80 num-5 */
{ "\0006",   "\0006",   "\0006",   {META,NONE},{META,NONE},{META,NONE}, },  /*  81 num-6 */
{ "\0007",   "\0007",   "\0007",   {META,NONE},{META,NONE},{META,NONE}, },  /*  82 num-7 */
{ "\0008",   "\0008",   "\0008",   {META,NONE},{META,NONE},{META,NONE}, },  /*  83 num-8 */
{ "\0009",   "\0009",   "\0009",   {META,NONE},{META,NONE},{META,NONE}, },  /*  84 num-9 */
{ "\000*",   "\000*",   "\000*",   {META,NONE},{META,NONE},{META,NONE}, },  /*  85 num-* */
{ "\000+",   "\000+",   "\000+",   {META,NONE},{META,NONE},{META,NONE}, },  /*  86 num-+ */
{ "\000-",   "\000-",   "\000-",   {META,NONE},{META,NONE},{META,NONE}, },  /*  87 num-- */
{ "\000.",   "\000.",   "\000.",   {META,NONE},{META,NONE},{META,NONE}, },  /*  88 num-. */
{ "\000/",   "\000/",   "\000/",   {META,NONE},{META,NONE},{META,NONE}, },  /*  89 num-/ */
{ {META,FN_SCROLL},{META,FN_SWAP},{META,FN_SCROLL},{META,FN_SWRESET},{META,FN_SWITCH},{META,FN_CLICK}, },  /*  90 scroll-lock */
{ {META,FN_DEBUG},{META,FN_DEBUG},{META,FN_DEBUG},{META,NONE},{META,FN_KILL},{META,FN_RESET}, },  /*  91 pause/break */
{ {META,FN_PRINT},{META,NONE},{META,FN_PRINT},{META,FN_LOG},{META,NONE},{META,FN_SET}, },  /*  92 print-screen */
{ {META,NONE},{META,NONE},{META,NONE},{META,NONE},{META,NONE},{META,NONE}, },  /*  93 world-trade-key */
{ {META,NONE},{META,NONE},{META,NONE},{META,NONE},{META,NONE},{META,NONE}, },  /*  94 world-trade-key */
};
#endif
