/****************************************************************
*								*
* MODULE NAME = UUCCPRB.H					*
*								*
* DESCRIPTIVE NAME = CPRB Structure, Return Codes and Routines	*
*								*
* COPYRIGHT = (C) COPYRIGHT IBM CORP. 1984, 1986		*
*	      LICENSED MATERIAL - PROGRAM PROPERTY OF IBM	*
*	      ALL RIGHTS RESERVED				*
*								*
*								*
* FUNCTION = Define the CPRB structure, return code constants	*
*	     and the external routines init_send_req_parms and	*
*	     send_request.					*
*								*
* NOTES =							*
*								*
*   DEPENDENCIES = None 					*
*								*
*   RESTRICTIONS = None 					*
*								*
*   REGISTER CONVENTIONS = None 				*
*								*
* MODULE TYPE = Include 					*
*								*
*   PROCESSOR = IBM Personal Computer C Compiler Version 1.00	*
*   MODULE SIZE = N/A						*
*   ATTRIBUTES	= N/A						*
*								*
* ENTRY POINT = N/A						*
*								*
*   PURPOSE = N/A						*
*   LINKAGE = N/A						*
*								*
* INPUT = None							*
*								*
* OUTPUT = None 						*
*								*
* NORMAL RETURN = N/A						*
*								*
* ERROR RETURN = N/A						*
*								*
* EXTERNAL REFERENCES						*
*								*
*   OTHER ROUTINES = N/A					*
*   DATA AREAS = N/A						*
*   CONTROL BLOCKS = N/A					*
*								*
* TABLES = N/A							*
*								*
* MACROS = N/A							*
*								*
* CHANGE ACTIVITY =						*
****************************************************************/
/***************************************************************/
/*			CPRB Structure			       */
/***************************************************************/
typedef struct {

     /* supplied parameters -- not changed by Send_Request */

      char far	    *uerserver;  /* ASCII name of server       */
      unsigned int uerfunct;	 /* Function ID 	       */

     /* request parameters and data */

      int	uerqparml;	 /* Request Parameters Length  */
      char far	*uerqparmad;	 /* Request Parameters Address */
      unsigned int   uerqdatal;  /* Request Data Length        */
      char far	*uerqdataad;	 /* Request Data Address       */

     /* reply parameters and data */

      int	uerrparml;	 /* Reply Parameters Length    */
      char far	*uerrparmad;	 /* Reply Parameters Address   */
      unsigned int   uerrdatal;  /* Reply Data Length	       */
      char far	*uerrdataad;	 /* Reply Data Address	       */

     /* returned parameters */

      long int	uerretcode;	 /* Return Code 	       */
      long int	uerservrc;	 /* Server Return Code	       */
      int	uerrepldplen;	 /* Replied Parameters Length  */
      unsigned int  uerreplddlen; /* Replied Data Length       */
      } UERCPRB;

/***************************************************************/
/*		       Return Codes			       */
/***************************************************************/

/****************************************************************
* The return code constants, their hexadecimal values and	*
* their meanings are as follows:				*
*								*
* UERERROK	0x00000000  Successful				*
* UERERRT1START 0x01000402  not started 			*
* UERERRT1LOAD	0x01000404  not loaded				*
* UERERRT1BUSY	0x01000408  busy				*
* UERERRT1VER	0x0100040A  Unsupported version ID		*
* UERERRT1EMU	0x0100040C  PC 3270 Emulation not loaded	*
* UERERRT1QPLEN 0x01000602  Request parameters length too large *
* UERERRT1RPLEN 0x01000604  Reply parameters length too large	*
* UERERRT1VERB	0x01000606  Invalid verb type			*
* UERERRT1SERV	0x01000608  Invalid server name 		*
* UERERRT1QPAD	0x0100060C  Invalid request parameters address	*
* UERERRT1QDAD	0x0100060E  Invalid request data address	*
* UERERRT1RPAD	0x01000610  Invalid reply parameters address	*
* UERERRT1RDAD	0x01000612  Invalid reply data address		*
* UERERRT1TOPV	0x01000616  TOPVIEW not supported		*
* UERERRT1CNCL	0x01000802  Cancelled by host			*
* UERERRT1CONV	0x01000C00  Unable to maintain conversation	*
* UERERRT1ISE	0x01000C02  Internal software error		*
* UERERRT1PROT	0x01000C04  Protocol violation			*
* UERERRT1SYIN	0x01000C06  System inconsistency		*
*								*
* UERERRT2	0x02	    Error Type 2 - acknowledge sent	*
* UERERRT3	0x03	    Error Type 3 - acknowledge received *
****************************************************************/
#define UERERROK       0x00000000
/* Type 1 Errors */
#define UERERRT1START  0x01000402
#define UERERRT1LOAD   0x01000404
#define UERERRT1BUSY   0x01000408
#define UERERRT1VER    0x0100040A
#define UERERRT1EMU    0x0100040C
#define UERERRT1QPLEN  0x01000602
#define UERERRT1RPLEN  0x01000604
#define UERERRT1VERB   0x01000606
#define UERERRT1SERV   0x01000608
#define UERERRT1QPAD   0x0100060C
#define UERERRT1QDAD   0x0100060E
#define UERERRT1RPAD   0x01000610
#define UERERRT1RDAD   0x01000612
#define UERERRT1TOPV   0x01000616
#define UERERRT1CNCL   0x01000802
#define UERERRT1CONV   0x01000C00
#define UERERRT1ISE    0x01000C02
#define UERERRT1PROT   0x01000C04
#define UERERRT1SYIN   0x01000C06

/****************************************************************
* For type 2 and type 3 errors the most significant byte of	*
* the return code is 0x02 and 0x03 respectively.  The 3 remain- *
* ing bytes are the Exception Class, Exception Code, and	*
* Exception Object sent or received in the Acknowledge. 	*
****************************************************************/
#define UERERRT2 0x02
#define UERERRT3 0x03

/***************************************************************/
/*		    Interface Routines			       */
/***************************************************************/
extern void init_send_req_parms(UERCPRB far *);
extern long int send_request(UERCPRB far *);
