.ce
Motorola FP Package Turnlog / Checklist
.SP
.ce
Pascal 3.24 QA Version ____     MTS:________   Date:_______
.SP 2
		COMMENTS:
.ce
.AL
Notes: "RCS host" currently refers to hpfclw.
.nf    "turn disc" refers to the disc attached to the turn system
.fi
.LI
Print out this turn log by executing the following on hpfclw:
.nf
cd /src/paws; co turn_fp.mm; mm turn_fp.mm | lp -onroff
.fi
.LI
Notes - This turnlog is a step by step procedure for converting
the Motorola supplied floating point package to PaWS format.
Wherever possible automatic tools will be used (as opposed to
hand editing). The source files reside in /src/paws/src/fp40/RCS.
The files with .sa suffixes are the original source from Motorola,
those sans a suffix are the PaWS versions. 

It really helps to have an SRM-UX unit on-line so you can test
the assembly of these routines as they go thru the translation
process.

The Motorola syntax is largely the same as PaWS assembler syntax.
Specific differences are called out in the steps below. These
modifications could be done by hand if desired. Each difference
called out below will also have some tool described to make the
task easier than doing it by hand, I hope.

If Motorola modifies their package in the future this turn procedure
may have to be updated. This turn procedure is fragile.

Unless you are doing something special, run the steps in the order
in which they appear in this turnlog.

These steps are not automatic and require user intervention.

.LI
cd to /src/paws/src/fp40
.LI
Run check_fp_out which will check out the .sa files and the
suffix-less (PaWS versions of these) files. The PaWS versions
are checked out -l because they will (presumably) change.
.LI
Run the command file fix_labels in /src/paws/bin to remove the ':'
character from the end of labels, and also to add an 'equ  *' to
lines containing nothing but a label. This operates on the .sa
files and puts the results into suffix-less versions of the same
name, with '_1' attached.
.LI
Run the command sed_stuff which will make changes to each source
file possible with sed. These include : control register names
(fpsr and fpcr), removing suffixes from the btst and other
related instructions (PaWS assembler doesn't like these),
comment out the 'section' pseudo-op, and expand some of the
macros.

The results of this step are put into the files with the
_2 suffix and the _1 suffix files are deleted.
.LI
Run the command awk_stuff which will expand the one
line wr_usk macro (sed couldn't do this). This command uses 
awk. This also changes macro invocations in the file
com_exc to subroutine calls. Edit file com_exc and
comment out the first line of routine mv_ext.

After this step the only files left will be the PaWS versions
of the FP package. From here on all changes must be done by
hand.
.LI
Edit the file bindec by hand. Several symbols need to be 'l-moded'.
These symbols are contained in the file bindec_symbols, in
/src/paws/bin. Read in the contents of this file after the
big header.
.LI
In the file decbin, there is a weird fequ pseudo-op. This needs to
be fixed by hand, as follows :

.nf
FZERO        fequ      0
FONE         fequ      1
FTEN         fequ     10

becomes 

FZERO        dc.w     0,0,0,0
FONE         dc.w     $3ff0,0,0,0
FTEN         dc.w     $4024,0,0,0

When accessing these values, remove the immediate (#) symbol.
Also make sure the size suffix for the op-code is .d.

There are some bugs in decbin, especially addressing modes.
Let's hope Motorola fixes these. These errors are :

.nf
==============================================
  line 175 : illegal addressing mode.

   change   or.l    #$4000000,(a0)
   to       ori.l   #$4000000,(a0)
==============================================
  line 239 : field overflow
   
   change   btst   #31,(a0)
   to       btst   #7,(a0)
==============================================
  line 297 : field overflow

   change   btst  #30,(a0)
    to      btst  #6,(a0)
==============================================
  line 327 : improper addressing mode
    same fix as line 175.
=============================================
  line 375 : improper addressing mode
    same fix as line 175
=============================================
  line 466 : improper addressing mode
    same fix as line 175
=============================================
  line 493 : field overflow
    same fix as line 297
=============================================

Some symbols need to be l-moded :

          lmode   ADJ_EXP
          lmode   FPCONTROL_OLD
          lmode   FPSCALE
.fi


.LI
Edit the file rd_usk and comment out all the macro definitions.
.LI
Edit the file com_exc and comment out the first line in the routine
mv_ext. Also l-mode the symbol ftemp. The bra.b instruction on 
line 350 (about) needs to be changed to bra because it's to the
next instruction. I don't understand why there is a branch there
at all ... there is also a bug on line 191. They tried to invoke
the mv_ext macro with two parameters, not one like they should.
So when we transform it to a call we wind up with a move instr
with 3 operands, just remove one of them.
.LI
Edit the file do_func and l-mode the following :
.nf
           lmode  store_flg
.fi
Also in do_func put a dot (.) after the names of the files included.
.LI
Edit get_op by hand and put a dot (.) after the names of the included
files. Also in get_op they try to use the dc.x pseudo-op to declare
an extended (96-bit) floating point constant. These should be
replaced with dc.l statements ... also in two places they try
to use # to start a comment line, change this to *.

The wfp_usk macro invocation needs to be fixed by hand here.
Change
.nf
           
     fmovem.x   fp0(a6),SOPO
to
     fnop
     fmovem.x   fp0,SOPO(a6)
.fi

Also the symbol DBINEXC needs to be l-moded. 
.LI
Grep for include and make sure that included files are terminated
with a dot (.) so the PaWS assembler doesn't look for .TEXT
files.
.LI
Now, assemble the files one at a time and make whatever changes
you need to. These steps have covered almost everything, but
it seems every file has some special cases ...
.LI
For 3.24, these are all the changes needed to convert from Motorola
syntax to PaWS syntax. If the package changes requiring additions to
the translation procedure, add the approprite steps to this
turnlog.
.LI
Run check_fp_in to check back in the PaWS versions.
