/*
 * C routines for testing hfscalc
 */

#include <sys/types.h>
#include <sys/inode.h>
#include <sys/ino.h>
#include <sys/fs.h>
#include <sys/dir.h>
#include <sys/param.h>
#include <sys/sysmacros.h>

void
Csetbit(cp, i)
	char *cp; {
	setbit(cp, i);
}

void
Cclrbit(cp, i)
	char *cp; {
	clrbit(cp, i);
}

Cisset(cp, i)
	char *cp; {
	return isset(cp, i);
}

Cisclr(cp, i)
	char *cp; {
	return isclr(cp, i);
}

Cblkmap(fs, cp, i)
	struct fs *fs;
	char *cp; {
	return blkmap(fs, cp, i);
}

Cdtog(fs, c)
	struct fs *fs; {
	return dtog(fs, c);
}

Cdtogd(fs, c)
	struct fs *fs; {
	return dtogd(fs, c);
}

Ccgtod(fs, c)
	struct fs *fs; {
	return cgtod(fs, c);
}

Ccbtocylno(fs, bno)
	struct fs *fs; {
	return cbtocylno(fs, bno);
}

Ccbtorpos(fs, bno)
	struct fs *fs; {
	return cbtorpos(fs, bno);
}

Citog(fs, x)
	struct fs *fs; {
	return itog(fs, x);
}

Cfs_cs(fs, x)
	struct fs *fs; {
	return &fs->fs_cs(fs, x);
}

Cinode_start(fs, x)
	struct fs *fs; {
    	return dbtob(fsbtodb(fs, itod(fs, x))) + 
                   itoo(fs, x) * sizeof(struct icommon);
}

Cdata_start(fs, x)
	struct fs *fs; {
    	return dbtob(fsbtodb(fs, x));
}


Ccgroup_start(fs, x)
	struct fs *fs; {
    	return dbtob(fsbtodb(fs, cgtod(fs, x)));
};

Csuper_start(fs, x)
	struct fs *fs; {
    	return dbtob(fsbtodb(fs, cgsblock(fs, x)));
};
