/************************************************************************/
/* This is a test program to test the routines which are part of the    */
/* PAWS BACKUP utitlity.                                                */
/*                                                                      */
/* file name             : tapeio                                       */
/* module name           : ioctl                                        */
/* routines to be tested : is_tape,                                     */
/*                         bytes_per_medium,                            */
/*                         write_tape_mark,                             */
/*                         unload_tape                                  */
/*                                                                      */
/* The main routine of this program gets called by a PAWS main program. */
/************************************************************************/

#include <stdio.h>
pascal ioctl_is_tape();
pascal ioctl_bytes_per_medium();
pascal ioctl_write_tape_mark();
pascal ioctl_unload_tape();

main()
{
	char vname[32];
	int fd;
	int is_tape;
	int bytes;
	int bnum;

	printf("Test of module ioctl\n");
	printf("Tested routines: is_tape, bytes_per_medium, write_tape_mark, unload_tape\n");
	printf("\nvolume name: ");
	scanf("%s",vname);

	/* open the volume */
	fd = open(vname,0);
	if( fd < 0 ){
		printf("Cannot open volume %s\n",vname);
		exit(1);
	}

	/* check whether the volume is a tape */
	is_tape = ioctl_is_tape(fd);
	if( is_tape ){
		printf("volume %s is a tape\n",vname);
	}

	/* number of bytes of the volume */
	bytes = ioctl_bytes_per_medium(fd);
	printf("number of bytes of volume %s: %d\n", vname, bytes);

	/* write a tape mark to the input blocknumber */
	if( is_tape ) {
		printf("\nblocknumber for tape mark:");
		scanf("%d",&bnum);
		if( ioctl_write_tape_mark(fd,bnum) != 0){
			printf("error during writing of tape mark\n");
		}
	}

	/* if volume is a tape unload it */
	if( is_tape ){
		if( ioctl_unload_tape(fd) != 0){
			printf("error during unload of tape\n");
			exit(1);
		}
	}

	close(fd);
}
