.H 1 "TDAM -- Check DAM Calls"
.P
TDAM is a Pascal program that exercises every DAM call.  It
makes both legal and illegal calls.  The goal here is call the DAM
with as many different sorts of parameters as possible, and to be sure 
that it responds correctly, even in cases where the request was
intentionally illegal.  
.P
For part of the test, TDAM will work on both an HFS and a LIF
or SRM volume, so that it can check the differences between the
different file systems.
.P
Here is a description of the tests for each DAM call.  The
program calls the DAM in each of the conditions listed, and ensures
that the noted ioresult is set.
.AL
.LI
lockfile, unlockfile.  HFSDAM should set ibadrequest.
.LI
getvolumedate, setvolumedate.  HFSDAM should set ibadrequest.
.LI
crunch.  HFSDAM returns no error, but does nothing.
.LI
createfile. 
.AL a
.LI
normal case -- no error.
.LI
no write permission for parent directory -- inopermission
.LI
no write permission for file -- inopermission
.LI
14-char file name -- no error
.LI
15-char file name -- ibadtitle
.LI
file name containing #0 -- ibadtitle
.LI
file name containing '/' -- ibadtitle
.LI
file name '/a/b/c', but 'b' doesn't exist -- inofile
.LE
.LI
openfile
.AL a
.LI
normal case -- no error
.LI
no read or write permission -- inopermission
.LI
read permission, but not write permission -- no error
.AL i
.LI
read this file -- no error
.LI
write this file -- inopermission
.LE
.LI
write permission, but not read permission -- no error
.AL i
.LI
write this file -- no error
.LI
read this file -- inopermission
.LE
.LI
file not present -- inofile
.LI
15-char file name -- ibadtitle
.LI
file is directory -- inotondir
.LI
file is block/char special -- no error.
read or write this file -- inoaccess
.LI
all other file types -- no error
.LE
.LI
overwritefile
.AL a
.LI
normal case -- no error
.LI
file not there -- same as createfile
.LI
no write permission -- inopermission	
.LI
file is dir -- inotondir
.LI
file is block/char special -- inoaccess  
.LI
all other file types -- no error
.LE
.LI
closefile
.AL a
.LI
normal case -- no error
.LI
file not open -- inotopen
.LI
file is dir -- inotondir
.LE
.LI
purgefile
.AL a
.LI
normal case -- no error
.LI
file is / -- inotclosed
.LI
file is prefix -- inotclosed
.LI
file is newly created (e.g., rewrite(f, 'foo');
close(f, 'purge');) -- no error	
.LE
.LI
purgename
.AL a
.LI
normal case -- no error
.LI
file not there -- inofile
.LI
no write permission on parent directory -- inopermission
.LI
file is an empty directory -- no error
.LI
file is a directory with 1 file -- inotempty
.LI
file is a prefix dir -- inotclosed
.LE
.LI
stretchit
.AL a
.LI
normal case -- no error
.LI
all file types stretchable except block/char, which bring
inoaccess
.LI
file type is char/block -- inoaccess
.LI
all other file types -- no error
.LI
file system has 1 frag free, try to stretch 1 frag -- no error
.LE
.LI
changename
.AL a
.LI
normal case -- no error
.LI
old file not there -- inofile
.LI
new file already there -- idupfile
.LI
no write perm in dir -- inopermission
.LI
any kind of file -- no error
.LI
file is prefix dir -- inotclosed
.LI
15-char file name -- ibadtitle
.LE
.LI
getvolumename, setvolumename
.AL a
.LI
set a 4-char name, then get it back -- no error
.LI
set a 6-char name, then get it back -- no error
.LI
turn off or pop out disk -- set shows error,
but get shows no error (returns '' as name)
.LI
name > 6 chars -- ibadtitle 
.LE
.LI
duplicatelink
.AL a
.LI
normal case -- no error
.LI
old file not there -- inofile
.LI
new file there -- idupfile
.LI
no write perm in dir -- inopermission
.LI
file is dir -- inotondir
.LI
any other kind of file -- no error
.LI
15-char name -- ibadtitle
.LE
.LI
opendirectory, openparentdir
.AL a
.LI
normal case -- no error
.LI
no x permission -- inopermission
.LI
file not dir -- opens parent
.LI
file not there -- opens parent
.LE
.LI
catalog
.AL a
.LI
normal case -- no error
.LI
no read permission on dir -- inopermission
.LI
set index too high -- no error, but get back no files
.LE
.LI
closedirectory.  no errors.
.LI
openvolume/openunit
.AL a
.LI
no errors.
.LI
do TM access afterwards -- no error
.LI
close fib with closefile -- no error
.LE
.LI
makedirectory
.AL a
.LI
normal case -- no error
.LI
no write permission in parent -- inopermission
.LI
name exists -- idupfile
.LI
15-char file name -- ibadtitle
.LE
.LI
setunitprefix
.AL a
.LI
normal case -- no error
.LI
no x permission on dir -- inopermission
.LI
file not there -- inofile
.LI
file not dir -- ifilenotdir
.LE
