
.H 1 "TCALC -- Testing HFS Calculation Routines"
.P
TCALC will test the module "hfscalc".  It is partly in C, and
partly in Pascal.  "Hfscalc" is a Pascal implementation of many small
C macros.  The C part of TCALC will consist of routines that implement
the macros.  For example, the C routine "Ccgtod" will implement the macro
"cgtod".
.P
The job of TCALC will be to call each of the hfscalc routines,
and check the result either by calling the corresponding C routine, or, 
if possible, by checking the result directly.
.P
The steps of TCALC follow.  "Sbp" is assumed to be a pointer
to a superblock.
.AL
.LI
Test min, max
.nf
	min(1,2) = 1
	max(1,2) = 2
.fi
.LI
Test howmany
.nf
	howmany(15,5) = 3
	howmany(16,5) = 4
	howmany(15,7) = 3
	howmany(15,8) = 2
	howmany(15,1) = 15 
.fi
.LI
Test roundup
.nf
	roundup(15,5) = 15
	roundup(16,5) = 20
	roundup(15,4) = 16
	roundup(15,8) = 16
	roundup(15,1) = 15
.fi
.LI
Test rounddownp2
.nf
	rounddownp2(15,4) = 12
	rounddownp2(16,4) = 16
	rounddownp2(13,4) = 12
	rounddownp2(15,8) = 8
	rounddownp2(15,2) = 14
.fi
.LI
Test freespace.  We set dsize and fragshift as shown.
Then we try each nbfree/nffree combination, and check
that the resulting freespace is as indicated.
.SP
.nf
	sbp^.dsize := 1000;
	sbp^.fragshift := 3;

	nbfree		nffree		freespace(sbp,10)
	------		------		-----------------
	0		0		-100
	100		100		800
	50		50		350
	50		500		800
	10		20		0
.fi
.LI
Test bitmap manipulation.  Take 2 arrays of 50 integers.
One is for the Pascal bit routines, the other for the C routines.
Zero them.  Then calculate 800 random numbers between 0
and 1599 inclusive, and call setbit and Csetbit to
set those bits in the two arrays.  Do the same with clrbit
and Cclrbit.  Then compare the arrays by ensuring that
isset and Cisset give the same results.  Do the same with
isclr and Cisclr.  Do the same with blkmap and Cblkmap.
.LI
Test btodb.  Generate 100 random numbers, and check
that
.SP
.nf
	btodb(randnum) = randnum div DEV_BSIZE
.fi
.LI
Test fragstoblks, blkstofrags, and fragstobytes.  
Generate 100 random numbers, and check that
.SP
.nf
	fragstoblks(sbp, randnum) = randnum div sbp^.frag
	blkstofrags(sbp, randnum) = randnum * sbp^.frag
	fragstobytes(sbp, randnum) = randnum * sbp^.fsize
.fi
.LI
Test cylinder arithmetic.  Generate 100 random
numbers, and check that
.SP
.nf
	cgtod(sbp, randnum) = Ccgtod(sbp, randnum)
	dtog(sbp, randnum) = Cdtog(sbp, randnum)
	dtogd(sbp, randnum) = Cdtogd(sbp, randnum)
	cbtocylno(sbp, randnum) = Ccbtocylno(sbp, randnum)
	cbtorpos(sbp, randnum) = Ccbtorpos(sbp, randnum)
	itog(sbp, randnum) = Citog(sbp, randnum)
.fi
.LI
Test nspb, nspf, and maxbpc.
.SP
.nf
	nspb(sbp) = sbp^.bsize div DEV_BSIZE
	nspf(sbp) = sbp^.fsize div DEV_BSIZE
	maxbpc + sizeof(sbp^) = SBSIZE
.if
.LI
Test fs_cs.  Assign to the ith element of sbp^.csp
the expression
.SP
.nf
	addr(sbp^, 8*1024*i)	
.fi
.SP
Then check that, for each cylinder group,
.SP
.nf
	fs_cs(sbp, cg) = Cfs_cs(sbp, cg)
.fi
.LI
Test offset calculations.  Generate 100 random numbers,
then check that
.SP
.nf
	blkoff(sbp, randnum) = randnum mod sbp^.bsize
	fragoff(sbp, randnum) = randnum mod sbp^.fsize
	lblkno(sbp, randnum) = randnum div sbp^.bsize
	numfrags(sbp, randnum) = randnum div sbp^.fsize
	fragroundup(sbp, randnum) = roundup(randnum, sbp^.fsize)
.fi	
.LI
Test the start routines.
.SP
.nf
	for each inode number
	    inode_start(...) = Cinode_start(...)

	for each fragment number
	    data_start(...) = Cdata_start(...)

	for each cylinder group number
	    cgroup_start(...) = Ccgroup_start(...)
	    super_start(...) = Csuper_start(...)
.fi
.LE
