			    TESTING HFSCK
			    Hal Prince
			    Sept. 1, 1986


ABSTRACT

	We describe the ways in which HFSCK will be tested.  The tests
fall into three categories.

	First, it will be tested through normal use.

	Second, it will be tested along with MKHFS testing.

	Third, it will be tested on intentionally corrupted file
systems.

	The tests are not meant to be exhaustive.  Since the C body
of HFSCK has received many thousands of hours of testing and use already,
we do not try to test every single piece of the C code.
Instead, our goal is to choose a varied set
of tests that are representative and that exercise the I/O facilities
of HFSCK, which are not part of the HP-UX C code.


RESOURCES NEEDED

	s200/300 running PAWS

	Disks for testing.  One or more of the ones we support.  See the
MKHFS test plan for a list.

	The amount of testing needed per disk is about 1/2 day.


REGULAR USE

	We expect to use HFSCK whenever we wish to check or repair
an HFS system.  The following activities and groups can provide test time:

	1) testing other programs.  All HFS programs (BACKUP, the DAM,
	etc) will need to check HFS file systems.  This should be done
	with HFSCK, both at Boeblingen and at Fort Collins.

	2) BASIC.  The BASIC group has a copy of HFSCK, and is
	presumably using it or a slightly modified version for
	their own development.

This testing will exercise HFSCK on a variety of file systems (empty,
full, clean, corrupt).  While we do not plan to keep statistics about
how often HFSCK is used in this fashion, we expect that the majority
of its exercise will be in this area.


WITH MKHFS

	We plan an extensive set of tests for MKHFS.  The results
of the MKHFS will be checked by running HFSCK (and sometimes fsck
under HP-UX also).  This will give HFSCK a lot of exercise, although
the file systems, being empty, will probably not present much of
a challenge.  See the MKHFS test plan for more detailed information.


INTENTIONALLY CORRUPTED FILE SYSTEMS

	We will have a series of stream files that create corrupted
file systems on a local disk.  The corruption will be done with FSDB.
The set of tests will be repeated with as many different types of
local disks as possible.

	The tester will do the following:

	1.  Attach local disk and do a MKHFS to create an empty HFS
	file system.  Run TABLE to get disk recognized as HFS.

	2.  Create the following standard file system on the disk:

	file name -- inumber -- size in bytes
	indentation shows structure

	/ -- 2
		file1 -- 4 -- 1536
		dir1 -- 64 
			file2 -- 65 -- 10752
			fifo1.ux -- 66 -- 0 
			dir2 -- 67
				file3 -- 68 -- 102912
				file4 -- 4 -- 1536

	"fifo1.ux" is created as a regular file, but is turned into a
	fifo later.

	Note that "file4" is a link to "file1".

	The files and directories can be created automatically by the
	following script:

	    fp/
	    mffile1[2]
	    mddir1
	    pdir1
	    mffile2[20]
	    mffifo1.ux
	    mddir2
	    pdir2
	    mffile3[2000]
	    dd/file1
	    file4
	    q

	The inumbers are given to show the links.  The actual
	inumbers are irrelevant, but the ones listed above are
	assumed in the following discussion.

	3.  Run the program "genstream" to generate the stream files
	for testing the disk.  The program asks for the unit number of
	the disk to be tested.  It generates streamfiles in the
	current directory named cfs#, where # ranges from 1 through 21.
	Genstream reads the file system to find the information it
	needs.  Each stream file that it generates uses FSDB to
	create a certain type of corruption to be resolved by HFSCK.

	4.  For each stream file (there are 21), do the following:

		-run the file, producing a corrupted file system
		-run HFSCK to repair the problem
		-run HFSCK again to verify that the problem is gone
		
	The stream file will tell the tester what mode
	("ask always" or "normal confirmation") to use; each will be
	chosen equally often.  The remaining mode, "report only", will
	be run by the stream file itself to show the user what is wrong.

	Some stream files, marked with * below, corrupt the file system
	in such a way that HFSCK will not restore it to its original state.
	Therefore, after one of these stream files are run, the tester must
	reconstruct the file system and run genstream again (because the inode 
	and block numbers may have changed).

	Here are the actions performed by each stream file, followed
	by the HFSCK mode, then the expected action of HFSCK:

	cfs1: Change "fifo1" to a fifo, and set writer count to 1.
	HFSCK (ask always) changes writer count to 0.

	cfs2: Change block count in "file1" to 3.  HFSCK (normal confirmation)
	corrects block count.

	cfs3: Write disk address 200 in the third direct address of
	the inode of "file2".  This is inconsistent with the inode
	size, which requires only two disk addresses.  HFSCK (ask
	always) zeroes the third address.

	cfs4: Change first indirect address of inode 10 (not allocated)
	to 2.  HFSCK (normal confirmation) clears unreferenced
	pipe.

	cfs5: Change third direct address of inode 10 (not allocated)
	to 200.  HFSCK (ask always) clears partially allocated
	inode.

	cfs6: Change inumber for '.' in directory "dir1" to 67.
	HFSCK (normal confirmation) corrects inumber.

	cfs7: Change the mode of unallocated inode 10 to 0100644.
	HFSCK (normal confirmation) clears the file.

	cfs8: Change free inode count in superblock to 100.
	HFSCK (ask always) corrects it.

	cfs9: Corrupt bit map in cylinder group by writing a 15 to
	the first byte in the bitmap that isn't 15.
	HFSCK (normal confirmation) rebuilds the free map.

	cfs10: Corrupt csumm info in cylinder group 0 by changing the
	free block count to 0.  HFSCK (ask always) corrects the
	bad cylinder group.

	cfs11: Change link count of "file1" to 5, too high.  HFSCK (normal
	confirmation) corrects it.

	cfs12: Change link count of "file1" to 1, too low.  HFSCK
	(ask always) corrects the bad link count.

	cfs13: Zero the superblock.  HFSCK (use alternate superblock
	at block 16) reconstructs it.

	*cfs14: Point two files to the same disk block by changing the first
	block of "file2" to be the same as the first block of "file4".
	HFSCK (normal confirmation) clears both files.

	*cfs15: Change first address of "file2" to 5000000, beyond the end
	of the file system.  HFSCK (ask always) removes DUP/BAD file.

	*cfs16: Change address of indirect block of "file3" to the
	address of the first data block of "file2".  HFSCK (normal
	confirmation) clears DUP/BAD files.

	*cfs17: Change size of directory "dir2" to zero.  HFSCK (ask
	always) clears file of unknown type.

	*cfs18: Make extra '..' entry in directory "dir1" by changing
	the name of the entry for "fifo1.ux".  HFSCK
	(ask always) removes it.

	*cfs19: Change inumber of "fifo1.ux" in directory "dir1" to
	3000000, impossibly large.  HFSCK (normal confirmation)
	removes the entry.

	*cfs20: Change inumber of "fifo1.ux" in directory "dir1" to
	10, an unallocated inode.  HFSCK (normal confirmation) 
	removes the directory entry.

	*cfs21: Disconnect directory from tree by changing inumber of
	"dir2" entry in directory "dir1" to 10.  HFSCK (ask always)
	reconnects the lost directory.


TIME REQUIRED

	Here is the time we expect to need for writing and executing
the tests.

	Regular Use -- no extra time.

	With MKHFS -- no extra time.

	Intentionally Corrupted File Systems -- 5 days to write, then
.5 days per disk to execute, plus some per-disk overhead for finding it,
attaching it, possibly backing it up, and so on.  
