.H 1 "Unit tests"
The test programs used here are written in C. 
They call either a Pascal or an assembly routine.
The assembly routine then calls another routine written in Pascal.
This is the same situation as in the BACKUP utility.
.P
There exists a shell script called gentst which is useful to generate
the CODE file for every test described in this test area.
This script first compiles the C test program into an assembly routine,
see "PAWS C compiler" documentation.
Then it copies this to SRM.
Afterwards a Pascal main program and a stream file are generated and also
copied to SRM.
The stream file assembles the test routine, compiles the generated Pascal
main program and then links the two CODE files together.
This script works only for C programs which don't define argv and argc.
It also requires a SRM connection between your HP-UX and PAWS system.
To finally run the tests it is necessary to either p-load the routines that
are tested (those who get called by the C test program) or to link them
with the CODE file gotten by the script.
.P
Here is an example how gentst can be used.
.AL
.LI
Generate C test program, name it tstprog.c on HP-UX.
.LI
call gentst (on HP-UX):
.br
$ gentst tstprog
.LI
execute stream file 'maketst' on SRM.
.LI
p-load the routines that are called by the test program, for example
psys.CODE.
.LI
execute test program tstprog.CODE.
.LE
.H 2 "Test routines of module ioctl"
.H 3 "Unit.1.1"
.SP
.B "Description"
.SP
This routine tests several routines of module ioctl with one program.
After invocation of this test program the user is asked for the name of
the volume.
The routine open is called to open this volume.
If this fails the program exits.
After a successful open the routine 'ioctl_is_tape' is called with the 
file descriptor gotten by the previous open call.
The return value is printed to CONSOLE: (stdout).
Then 'ioctl_bytes_per_medium' is called, which returns 
the size of the related volume.
If the given volume indicates a cartridge tape  the user is now asked for
a block number on which a tape mark will be written.
The routine 'ioctl_tape_mark' gets called with this block number.
The last routine that gets called is 'ioctl_unload_tape'.
It is only called for tapes to unload them.
.TS
expand;
lcl.
file containing test program	:	tsttape.c
tested routines	:	is_tape
		bytes_per_medium
		write_tape_mark
		unload_tape
module name	:	ioctl
file name	:	tapeio
other modules needed	:	clib (CLIBRARY.CODE),
(p-load in given order or link)		ioctl (tapeio.CODE),
		CS80tbdvr (dvr.CODE)
.TE
.SP
.B "Test Input"
.SP
This test should be done with the following user inputs:
.DL
.LI
#41: (cartridge tape)
.LI
#3:  (floppy)
.LI
#11: (volume on local disc)
.LI
#20: (non existing volume)
.LE
.H 2 "Test routines of module paws"
The tests described here test the routines of module paws.
Those routines are called from the C program part of BACKUP.
In the following sections there is at first a description of the test 
program.
Then the different test cases that should be performed follow.
This includes a more general description of the test inputs and some 
examples for those.
.H 3 "Unit.2.1"
.SP
.B "Description"
.SP
At the beginning the test person is asked for a file name.
The name that can be input here is according to the description in the
"Pascal 3.1 Workstation System, Vol. I Main Command Level and Subsystems"
manual.
.P
If the call to the routine to be tested is successful the following values
are printed to CONSOLE:.
First the return value of 'ptocpion' is printed.
Possible values are 0, 1, 2 and 3.
If it is 0 the given file name is not valid (for example the volume does
not exist).
The other values indicate a successful call to 'ptocpion'.
The value 1 indicates that the given file is on a LIF volume,
2 indicates on SRM or not on LIF and not on HFS volume,
finally 3 indicates on HFS volume.
If the given name is valid
the volume part of the given file name, the file name part how it was input
and the file name part without any password are printed.
.TS
expand;
lcl.
file containing test program	:	tstpaws1.c
tested routine	:	ptocpion
module name	:	paws
file name	:	psys
other modules needed	:	clib (CLIBRARY.CODE),
(p-load in given order or link)		matchstr (MATCHSTR.CODE),
		paws (b_support.CODE),
		ctopstr (cpio.CODE),
		ptocstr (cpio.CODE)
.TE
.SP
.B "Test Input"
.DL
.LI
names without passwords
.br
#11:, #11:tst.TEXT, #11:=.ASC, #11<tst>:
.br
#5:tst, #5:tst/tsta
.br
HFS:tst, HFS:./ABC, HFS:<tst>tst
.LI
names with passwords
#5:<tst>tst, #5<tst>:, #5:tst<tst>abc, #5:tst<ts<>a
.LI
invalid names
#20:, #5:A
.LE
.H 3 "Unit.2.2"
.SP
.B "Description"
.SP
The test person is asked for a file name a pattern and an index.
The file name must contain wild cards in the part that indicates a file
(for example =.TEXT or /tst/=).
Index can be any value greater than or equal to zero.
.P
The routine 'getnfile' which is tested here, returns the next file that 
matches the given pattern starting at index (the DAM catalog call is started
at index).
This test calls getnfile until no further match can be found and prints 
each file name and the according index.
Dir indicates whether pattern and file name match completely.
The values for dir are 1: if complete match, 0: otherwise.
.TS
expand;
lcl.
file containing test program	:	tstpaws2.c
tested routine	:	getnfile
module name	:	paws
file name	:	b_support
other modules needed	:	clib (CLIBRARY.CODE),
(p-load in given order or link)		matchstr (MATCHSTR.CODE),
		paws (b_support.CODE),
		ctopstr (cpio.CODE),
		ptocstr (cpio.CODE)
.TE
.SP
.B "Test Input"
.DL
.LI
LIF
.br
=.TEXT with different indices (0, 10)
.br
A= with different indices (0, 5, 20)
.LI
SRM
.br
tst/= with different indices (0, 10, 20, 25)
.br
=.TEXT with different indices (0, 10)
.br
A= with different indices (0, 5, 20)
.LI
HFS
.br
tst/= with different indices (0, 10, 20, 25)
.br
=.TEXT with different indices (0, 10)
.br
A= with different indices (0, 5, 20)
.LE
The file names and the patterns are the same for all the above tests.
.H 3 "Unit.2.3"
.SP
.B "Description"
.SP
The test asks for a directory or volume name.
The routine 'volvalid' which is tested here checks whether this name is valid.
This is true if the name is a directory and if it is an existing one.
.P
The return values are 0 if not valid, 1 if a LIF volume, 2 if on SRM or
not on LIF and not on an HFS volume and 3 if on an HFS volume.
This values are printed to CONSOLE:.
.TS
expand;
lcl.
file containing test program	:	tstpaws3.c
tested routine	:	volvalid
module name	:	paws
file name	:	b_support
other modules needed	:	clib (CLIBRARY.CODE),
(p-load in given order or link)		matchstr (MATCHSTR.CODE),
		paws (b_support.CODE),
		ctopstr (cpio.CODE),
		ptocstr (cpio.CODE)
.TE
.SP
.B "Test Input"
.DL
.LI
LIF
.br
#11:, #11:TST, #23: (invalid volume), #11<tst>:
.LI
SRM
.br
relative: #5:, #5:tst
.br
absolute: #5:/geli/tsta, #5:/geli/tstb<geli>
.LI
HFS
.br
relative: HFS:, HFS:tst
.br
absolute: HFS:/geli/tsta, HFS:/geli/tstb<geli>
.LE
.H 3 "Unit.2.4"
.SP
.B "Description"
.SP
After invocation the test person is asked for a file name.
The routine 'get_filehdr' checks whether this files needs a WS header
on an HFS volume and returns the appropriate header.
If the file is a BDAT file a BDAT header is also returned.
However this test prints only the return values onto CONSOLE:.
These are -1 if the call was not successful, 0 if the file needs no WS
header, 1 if the file needs a WS header and 2 if the file needs a WS and
a BDAT header.
.TS
expand;
lcl.
file containing test program	:	tstpaws4.c
tested routine	:	get_filehdr
module name	:	paws
file name	:	b_support
other modules needed	:	clib (CLIBRARY.CODE),
(p-load in given order or link)		matchstr (MATCHSTR.CODE),
		paws (b_support.CODE),
		ctopstr (cpio.CODE)
.TE
.SP
.B "Test Input"
.DL
.LI
for all possible file types on LIF/SRM/HFS
.LI
for files with relative pathes SRM/HFS
.LI
for files with absolute pathes SRM/HFS
.LE
.H 3 "Unit.2.5"
.SP
.B "Description"
.SP
With this test routine 'createf' can be tested.
A file with a given name and file type can be created.
Also a start address is requested (fstartaddress field in fib) which is 
required for 'System' files.
There is no output if the call to createf was successful.
.TS
expand;
lcl.
file containing test program	:	tstpaws5.c
tested routine	:	createf
module name	:	paws
file name	:	b_support
other modules needed	:	clib (CLIBRARY.CODE),
(p-load in given order or link)		matchstr (MATCHSTR.CODE),
		paws (b_support.CODE),
		ctopstr (cpio.CODE)
.TE
.SP
.B "Test Input"
.DL
.LI
all possible file types on LIF/SRM/HFS
.LI
files with different path lengths on SRM/HFS
.LI
files with relative/absolute pathes on SRM/HFS
.LI
try to create files where some directories are missing on SRM/HFS
.LE
.H 3 "Unit.2.6"
With this test routine 'part_match' can be tested.
It can be checked whether a name and a pattern match partial , complete 
or not at all.
The file b_support does normally not export this routine which is required
to do this test.
Therefore special editing is required to be able to call the routine
from another module.
.TS
expand;
lcl.
file containing test program	:	tstpaws6.c
tested routine	:	part_match
module name	:	paws
file name	:	b_support
other modules needed	:	clib (CLIBRARY.CODE),
(p-load in given order or link)		matchstr (MATCHSTR.CODE),
		paws (b_support.CODE),
		ctopstr (cpio.CODE)
.TE
.SP
.B "Test Input"

.H 2 "Test routines of module ppsys"
The routines which are tested here are the equivalents to some of the C
system calls on HP-UX.
.H 3 "Unit.3.1"
.SP
.B "Description"
.SP
The test person is asked for a file name to input.
If the file is valid and the user has read access to it, all fields of the
stat buffer are printed to CONSOLE:.
.TS
expand;
lcl.
file containing test program	:	tststat.c
tested routine	:	stat
module name	:	ppsys
file name	:	ppcsys
other modules needed	:	clib (CLIBRARY.CODE),
(p-load in given order or link)		ppsys (ppcsys.CODE)
.TE
.SP
.B "Test Input"
.DL
.LI
files with all possible file types on LIF/SRM/HFS
.LI
LIF/SRM/HFS volume names
.LI
invalid LIF/SRM/HFS files/volumes
.LI
protected SRM/HFS files
.LI
protected SRM/HFS directories
.LI
all possible device special files on HFS
.LI
files with links on HFS
.LE
.H 3 "Unit.3.2"
.SP
.B "Description"
.SP
The inputs to this test are a directory name and a mode.
If the user has the appropriate access rights the named directory is created
if it doesn't already exist.
.TS
expand;
lcl.
file containing test program	:	tstmkdir.c
tested routine	:	mkdir
module name	:	ppsys
file name	:	ppcsys
other modules needed	:	clib (CLIBRARY.CODE),
(p-load in given order or link)		ppsys (ppcsys.CODE)
.TE
.SP
.B "Test Input"
.DL
.LI
non existing directories on SRM/HFS with relative and absolute pathes
.LI
try to create a directory on LIF
.LI
already existing directories on SRM/HFS
.LI
already existing files on SRM/HFS
.LI
pathes with protected directories in it
.LE
.H 3 "Unit.3.3"
.SP
.B "Description"
.SP
Two file names have to be input.
The first one must already exist, the second one should not exist.
.TS
expand;
lcl.
file containing test program	:	tstlink.c
tested routine	:	link
module name	:	ppsys
file name	:	ppcsys
other modules needed	:	clib (CLIBRARY.CODE),
(p-load in given order or link)		ppsys (ppcsys.CODE)
.TE
.B "Test Input"
.SP
This test has only to be performed for files on an HFS disc.
.DL
.LI
file1 exists file2 doesn't both file names given absolute
.LI
both files exist both file names given absolute
.LI
both files don't exist both file names given absolute
.LI
file1 doesn't exist file2 does both file names given absolute
.LI
file1 exists file2 doesn't both file names given relative
.LI
file1 exists file2 doesn't, file name 1 given relative 2 absolute
.LI
file1 exists file2 doesn't, file name 1 given absolute 2 relative
.LI
files with different permissions
.LI
directories
.LE
.H 3 "Unit.3.4"
.SP
.B "Description"
.SP
The input to this test is a file name and a mode.
The call to chmod can only be successful if the given file exists already.
.TS
expand;
lcl.
file containing test program	:	tstchgi.c
tested routine	:	change_inode
module name	:	ppsys
file name	:	ppcsys
other modules needed	:	clib (CLIBRARY.CODE),
(p-load in given order or link)		ppsys (ppcsys.CODE)
.TE
.SP
.B "Test Input"
.SP
This test has only to be performed for files on an HFS disc.
.DL
.LI
files with different file types, names given relative
.LI
file names given absolute
.LI
directories
.LI
protected files/directories
.LE
