.H 1 "Special tests"
As already mentioned the tests described in this chapter test special 
features of the BACKUP utility.
.H 2 "Security"
It is very important to do this tests.
We really want to be sure that it is not possible to read or delete
protected files from an HFS disc with the BACKUP utility.
However we want to be sure that it is possible to make a backup of every
file from an HFS disc.
.H 3 "Spec.1.1"
Check whether the mode bits get backed up and restored properly.
.DL
.LI
back up files from an HFS disc with all possible combination of the mode bits.
.LI
make a table of contents to check whether the mode bits are stored properly.
.LI
restore this backup to an HFS volume to check whether the mode bits get
reset properly.
.LE
.H 3 "Spec.1.2"
Check whether the owner and group ids get backed up and restored correct.
.DL
.LI
back up files from an HFS disc with owner other than BASIC or PAWS and
group other than WS.
.LI
make a table of contents to check whether the uid and gid are stored properly.
.LI
restore this backup to an HFS volume to check whether the uid and gid get
reset correct.
.LE
.H 3 "Spec.1.3"
Check whether only those files can be restored to a non HFS disc which are
owned by user PAWS or BASIC or group WS, or which have read permissions for
others.
.DL
.LI
back up files from an HFS disc with all possible kinds of the mode bits and
which are not owned by PAWS, BASIC or WS.
.LI
make a table of contents to check whether all bits are stored properly.
.LI
restore the backup to different kinds of file systems:
.AL a
.LI
try to restore to a LIF volume.
.LI
try to restore to a SRM volume.
.LE
.LE
.H 3 "Spec.1.4"
Check whether only those files from SRM can be backed up for which the
correct password is specified if it is read protected.
.DL
.LI
back up files from a SRM volume which have passwords
.LI
back up files from a SRM volume which have passwords using the volume password
.LI
try to restore those files to SRM
.LE
.H 2 "Linked files"
.H 3 "Spec.2.1"
Check whether it is possible to back up and restore links from an HFS volume
correctly.
.DL
.LI
backup several files from an HFS disc which are linked together.
.LI
restore those files
.AL a
.LI
to an HFS volume
.LI
to a SRM volume
.LI
to HP-UX
.LE
.LE
.H 2 "Device special files"
.H 3 "Spec.3.1"
Check whether it is possible to back up device special files with the
BACKUP utility and whether this backup can be restored correctly by HP-UX.
.DL
.LI
back up all possible kinds of device special files.
.LI
make a table of contents.
.LI
restore those files
.AL a
.LI
try to restore them to PAWS
.LI
restore them to HP-UX
.LE
.LE
.H 2 "Different file types"
.H 3 "Spec.4.1"
Back up files of all different kinds of file types from a LIF volume
and restore them to all possible kinds of file systems.
.DL
.LI
back up files with all possible file types from a LIF volume.
.LI
restore those files
.AL a
.LI
to a LIF volume
.LI
to a SRM volume
.LI
to an HFS volume
.LE
.LE
.H 3 "Spec.4.2"
Back up files of all different kinds of file types from a SRM volume
and restore them to all possible kinds of file systems.
.DL
.LI
back up files with all possible file types from a SRM volume.
.LI
restore those files
.AL a
.LI
to a LIF volume
.LI
to a SRM volume
.LI
to an HFS volume
.LE
.LE
.H 3 "Spec.4.3"
Back up files of all different kinds of file types from a HFS volume
and restore them to all possible kinds of file systems.
.DL
.LI
back up files with all possible file types from an HFS volume.
.LI
restore those files
.AL a
.LI
to a LIF volume
.LI
to a SRM volume
.LI
to an HFS volume
.LE
.LE
.H 2 "Utime"
Files that are restored to an HFS disc keep the last modification date
from the backup tape.
This feature is tested here.
.H 3 "Spec.5.1"
Take the backup tape made by Bkp.2.3 and restore it to an HFS volume.
Check whether the times get restored correctly.
.H 2 "Multiple tapes/floppies"
.H 3 "Spec.6.1"
Do a multiple tape backup.
.DL
.LI
back up '/' from an HFS volume to a cartridge tape (150 ft).
Repeat this step until the second tape is requested and some stuff gets
stored onto it.
.LI
do a table of contents of this tape on
.AL a
.LI
PAWS
.LI
HP-UX
.LE
.LE
.H 3 "Spec.6.2"
Do a multiple floppy backup.
.DL
.LI
back up '/' from an HFS volume to a floppy disc.
.LI
do a table of contents of this floppy on
.AL a
.LI
PAWS
.LI
HP-UX
.LE
.LE
.H 2 "Stress tests"
.H 3 "Spec.7.1"
Do a backup of '/' from an HFS volume with different size of memory.
.H 2 "Error cases"
.H 3 "Spec.8.1"
.H 2 "Stream files"
The tests in this section have only to be performed if the tests Bkp.2.4,
Rest.1.4 and Tbl.1.1 are not done from a stream file.
.H 3 "Spec.9.1"
Test backup from a stream file.
This test is similar to Bkp.2.4, except that it gets executed from a stream
file.
.H 3 "Spec.9.2"
Test restore from a stream file.
This test is similar to Rest.1.4, except that it gets executed from stream
file.
.H 3 "Spec.9.2"
Test table of content from a stream file.
This test is similar to Tbl.1.1, except that it gets executed from s stream
file.
.H 2 "Documented examples"
All examples that are documented in the manuals or in some other documents
have to be tested too.
.H 2 "Code review"
Here is a list of all routines that have to be code reviewed.
.TS
;
lllc.
FILE NAME	MODULE NAME	ROUTINE to be tested	IMPORTANCE
.sp
cpio.c		main	A
cpio.c		backup	A
cpio.c		getname	A
cpio.c		ckname	A
cpio.c		openout	A
cpio.c		bread	B
cpio.c		readhdr	B
cpio.c		bwrite	B
cpio.c		writehdr	B
cpio.c		chgreel	B
cpio.c		postml	B
cpio.c		pentry	B
cpio.c		missdir	C
cpio.c		write_vinfo	C
cpio.c		read_filehdr	C
cpio.c		write_filehdr	C
.sp
cpiomain.p		BCKP	B
.sp
b_support.p	paws	ptocpion	A
b_support.p	paws	getnfile	A
b_support.p	paws	volvalid	B
b_support.p	paws	get_filehdr	A
b_support.p	paws	createf	A
b_support.p	paws	part_match	A
.sp
ppcsys.p		stat	A
ppcsys.p		mkdir	A
ppcsys.p		link	*
ppcsys.p		change_inode	*
.sp
		ctime	A
		time	A
.TE
.TS
;
ll.
A	must
B	high want
C	want
*	one of link or change_inode
.TE
