/* HPUX_ID: @(#)sysmacros.h	27.3     85/06/27  */
/*
 * Some macros for units conversion
 */
/* Core clicks (??? bytes) to segments and vice versa */
#define	ctos(x)	(x)
#define	stoc(x)	(x)

/* Core clicks (2048 bytes) to disk blocks (256 bytes)*/
#define	ctod(x)	(x<<(PGSHIFT- DEV_BSHIFT))
#define	dtoc(x)	(x>>(PGSHIFT- DEV_BSHIFT))         /* truncated conversion only */
#define	dtob(x)	((x)<<DEV_BSHIFT)       

/*
 * Macros for handling inode numbers:
 *     inode number to file system block offset.
 *     inode number to cylinder group number.
 *     inode number to file system block address.
 */
#define	itoo(fs,x)	((x) % INOPB(fs))
#define itog(fs,x)	((x) / (fs) -> fs_ipg)
#define itod(fs,x)	\
	((daddr_t)(cgimin(fs, itog(fs, x)) + \
	(blkstofrags((fs), (((x) % (fs) -> fs_ipg) / INOPB(fs))))))

/* pages to clicks */
#define	ptoc(x) (((x)+CLSIZE-1) >> CLSIZELOG2)

/* clicks to bytes */
#define	ctob(x)	((x)<<PGSHIFT)

/* bytes to clicks */
#define	btoc(x)	(((unsigned)(x)+(NBPG -1))>>PGSHIFT)

/* page count to physical page frame number */
#define	pctopfn(x)	((x) + physmembase)

/* major part of a device */
#define	major(x)	((long)(((unsigned)(x)>>24)&0377))
#define bmajor(x)       major(x)
#define brdev(x)        (x)

/* minor part of a device */
#define	minor(x)	((long)((x)&0xffffff))
/* make a minor number */
#define	makeminor(sc, ba, un, vl)	((long)((sc)<<16|(ba)<<8|(un)<<4|vl))

/* common field definitions within the minor */
#define m_selcode(x) 	(int)((unsigned)(x)>>16&0xff)
#define m_busaddr(x) 	(int)((unsigned)(x)>>8&0xff)
#define m_unit(x) 	(int)((unsigned)(x)>>4&0xf)
#define m_volume(x) 	(int)((unsigned)(x)&0xf)
#define m_flags(x) 	(int)((unsigned)(x)&0xff)
#define m_port(x)       (int)((unsigned)(x)>>8&0xff)
#define M_DEVMASK	(0xffff00)

/* make a device number */
#define	makedev(x,y)	((dev_t)(((x)<<24) | (y & 0xffffff)))

#define MINOR_FORMAT    "0x%06.6x"
