/* HPUX_ID: @(#)space.h	27.9.1.5		85/11/21 */

#include "../h/dir.h"
#include "../h/user.h"
#include "../h/proc.h"
#include "../h/text.h"
#include "../h/inode.h"
#include "../h/callout.h"
#include "../h/cmap.h"
#include "../h/kernel.h"
#include "../h/map.h"
#include "../h/buf.h"
#include "../h/pty.h"

/*
 * System devices.  
 * 
 * Argdev is declared here until we can support configurable & multiple
 * swap devices.  Config is capable of handling argdev and when enabled
 * will generate appropriate variable in conf.c.  
 *
 */
dev_t	swapdev = makedev(3, 0x000000);
dev_t	argdev;

/*
 * System parameter formulae.
 */

struct	timezone tz = { TIMEZONE, DST };

#ifdef INET
#define	NETSLOP	20
#else
#define	NETSLOP	0
#endif

#ifdef	NOSWAP
#define	NOSWAP	1
#else
#define	NOSWAP	0
#endif

#define	NCLIST  (100+16*MAXUSERS)
int	nclist = NCLIST;

int	nproc = NPROC;
int	ninode = NINODE;
int	ncallout = NCALLOUT;
long	unlockable_mem = UNLOCKABLE_MEM;
int	ntext = NTEXT;
int	nfile = NFILE;
int	nbuf = NBUF;
int	nflocks = NFLOCKS;
int	npty = NPTY;
int	maxuprc = MAXUPRC;
int	dmmin = DMMIN;		/* unit: sector size */
int	dmmax = DMMAX;		/* unit: sector size */
int	dmtext = DMTEXT;	/* unit: sector size */
int	dmshm = DMSHM;
int	maxdsiz = MAXDSIZ/NBPG; /* unit: page size */
int	maxssiz = MAXSSIZ/NBPG; /* unit: page size */
int	maxtsiz = MAXTSIZ/NBPG; /* unit: page size */
uint	shmmaxaddr = SHMMAXADDR;
int	parity_option = PARITY_OPTION;
uint	argdevnblk = ARGDEVNBLK;
int	noswap	= NOSWAP;
int	timeslice = TIMESLICE;		/* unit: 20ms tick */
int	acctsuspend = ACCTSUSPEND;	/* unit: percent of filesystem free */
int	acctresume = ACCTRESUME;	/* unit: percent of filesystem free */

int	mem_no = 3; 	/* major device number of memory special file */

/*
   The tty stuff that needs to be declared somewhere.
*/
#define	NPCI	16
short	npci = NPCI;
struct tty pci_tty[NPCI];
struct tty *tty_line[NPCI];
struct tty *cons_tty;

/* 
   !!! When compiler symbol table is fixed, NMBCLUSTERS should be generated
   by including mbuf.h
*/

#define	NMBCLUSTERS 256
int	nmbclusters = NMBCLUSTERS;


/*
 * These have to be allocated somewhere; allocating
 * them here forces loader errors if this file is omitted.
 */
struct	proc *proc, *procNPROC;
struct	inode *inode, *inodeNINODE;
struct 	callout *callout;
struct	text *text, *textNTEXT;
struct	file *file, *fileNFILE;
struct locklist locklist[NFLOCKS];	/* The lock table itself */
struct	tty  pt_tty[NPTY];
struct	tty  *pt_line[NPTY];
struct	pty_info  pty_info[NPTY];

struct	cblock *cfree;
struct	buf *buf, *swbuf;
short	*swsize;
int	*swpf;
char	*buffers;
struct	cmap *cmap, *ecmap;

struct	buf	bfreelist[BQUEUES];	/* heads of available lists */
struct	bufhd	bufhash[BUFHSZ];	/* heads of hash lists */
struct	buf	bswlist;		/* head of free swap header list */
struct	buf	*bclnlist;		/* head of cleaned page list */

char	runin;				/* scheduling flag */
char	runout;				/* scheduling flag */
int     runrun;				/* scheduling flag */
char	curpri;				/* more scheduling */
int	maxmem;				/* actual max memory per process */
int	physmem;			/* physical memory on this CPU */
int	hand;				/* current index into coremap used by daemon */
int	wantin;
int	selwait;
/*
 * The following is for the shared memory subsystem (if configured)
 */

#include	"../h/ipc.h"
#include	"../h/msg.h"

struct ipcmap	msgmap[MSGMAP];
struct msqid_ds	msgque[MSGMNI];
struct msg	msgh[MSGTQL];
struct msginfo	msginfo = {
	MSGMAP,
	MSGMAX,
	MSGMNB,
	MSGMNI,
	MSGSSZ,
	MSGTQL,
	MSGSEG
};
int	messages_present = 1;

#	ifndef IPC_ALLOC
#	include	"../h/ipc.h"
#	endif
#include	"../h/sem.h"
struct semid_ds	sema[SEMMNI];
struct sem	sem[SEMMNS];
struct map	semmap[SEMMAP];
struct	sem_undo	*sem_undo[NPROC];
#define	SEMUSZ	(sizeof(struct sem_undo)+sizeof(struct undo)*SEMUME)
int	semu[((SEMUSZ*SEMMNU)+NBPW-1)/NBPW];
union {
	short		semvals[SEMMSL];
	struct semid_ds	ds;
	struct sembuf	semops[SEMOPM];
}	semtmp;

struct	seminfo seminfo = {
	SEMMAP,
	SEMMNI,
	SEMMNS,
	SEMMNU,
	SEMMSL,
	SEMOPM,
	SEMUME,
	SEMUSZ,
	SEMVMX,
	SEMAEM
};
int	semaphores_present = 1;

#	ifndef	IPC_ALLOC
#	include	"../h/ipc.h"
#	endif
#include	"../h/shm.h"
struct	shmid_ds	shmem[SHMMNI];	
struct	shmpt_ds	shm_pte[NPROC*SHMSEG];
struct	shminfo shminfo = {
	SHMMAX,
	SHMMIN,
	SHMMNI,
	SHMSEG,
	SHMBRK,
	SHMALL
};
int	shared_memory_present = 1;
