/* HPUX_ID: @(#)shm.h	27.10		85/04/18 */

/*
**	IPC Shared Memory Facility.
*/

/*
**	Implementation Constants.
*/

#define	SHMLBA	(ctob(clrnd(1))) 	/* segment low bound address multiple */
		 	 	        /* (SHMLBA must be a power of 2) */

/*
**	Permission Definitions.
*/

#define	SHM_R	0400	/* read permission */
#define	SHM_W	0200	/* write permission */

/*
**	ipc_perm Mode Definitions.
*/

#define	SHM_CLEAR	01000	/* clear segment on next attach */
#define	SHM_DEST	02000	/* destroy segment when # attached = 0 */

/*
**	Message Operation Flags.
*/

#define	SHM_RDONLY	010000	/* attach read-only (else read-write) */
#define	SHM_RND		020000	/* round attach address to SHMLBA */
/*
**      disc image constants.
*/
#define NSHMDAD		12	/* 12 chunks */

#include <machine/pte.h>
/*
**	Structure Definitions.
*/


/*
**	There is a shared mem id data structure for each segment in the system.
*/

struct shmid_ds {
	struct ipc_perm	shm_perm;	/* operation permission struct */
	int		shm_segsz;	/* segment size */
	struct pte	*shm_ptbl;	/* ptr to associated page table */
	ushort		shm_lpid;	/* pid of last shmop */
	ushort		shm_cpid;	/* pid of creator */
	ushort		shm_nattch;	/* current # attached */
	ushort		shm_cnattch;	/* in memory # attached */
	time_t		shm_atime;	/* last shmat time */
	time_t		shm_dtime;	/* last shmdt time */
	time_t		shm_ctime;	/* last change time */

	ushort		*shm_umptbl;     /* ptr to associated umm page table */
	swblk_t		shm_daddr[NSHMDAD];    /* disc address of DMSHM    */
					       /* blocks segments	  */
	ushort		shm_poip;	
	ushort		shm_rssize;
	int		shm_flag;	/* segment attributes */
};

struct	shmpt_ds {
	struct	shmid_ds  *shm_dsptr;
	int	shm_spte;	/* starting pte entry */
	int	shm_sflg;	/* R/W permission on segment */
};

struct	shminfo {
	int	shmmax,	/* max shared memory segment size */
		shmmin,	/* min shared memory segment size */
		shmmni,	/* # of shared memory identifiers */
		shmseg,	/* max attached shared memory segments per process */
		shmbrk,	/* gap (in clicks) used between data and shared memory */
		shmall;	/* max total shared memory system wide (in clicks) */
};




/*
 * Shared memory control operations
 */

#define SHM_LOCK	3	/* Lock segment in core */
#define SHM_UNLOCK	4	/* Unlock segment */
