/* HPUX_ID: @(#)resource.h	27.4     85/10/28  */


struct	rusage {
	struct timeval ru_utime;	/* user time used */
	struct timeval ru_stime;	/* system time used */
	long	ru_maxrss;
#define	ru_first	ru_ixrss
	long	ru_ixrss;		/* integral shared memory size */
	long	ru_idrss;		/* integral unshared data " */
	long	ru_isrss;		/* integral unshared stack " */
	long	ru_minflt;		/* page reclaims */
	long	ru_majflt;		/* page faults */
	long	ru_nswap;		/* swaps */
	long	ru_inblock;		/* block input operations */
	long	ru_oublock;		/* block output operations */
	long	ru_ioch;		/* # of characters read/written */
	long	ru_msgsnd;		/* messages sent */
	long	ru_msgrcv;		/* messages received */
	long	ru_nsignals;		/* signals received */
	long	ru_nvcsw;		/* voluntary context switches */
	long	ru_nivcsw;		/* involuntary " */
#define	ru_last		ru_nivcsw
};

/*
 * Within the kernel, time information is stored as ticks rather than as
 * seconds plus microseconds.  This makes normal updates more efficient
 * and eliminates race conditions while updating.  The seconds field is
 * used to store ticks and the microseconds field is unused.
 */
#define ru_sticks	ru_stime.tv_sec
#define ru_uticks	ru_utime.tv_sec


#define	RLIM_NLIMITS	6		/* number of resource limits */

struct rlimit {
	int	rlim_cur;		/* current (soft) limit */
	int	rlim_max;		/* maximum value for rlim_cur */
};
