/* HPUX_ID: @(#)pty.h	27.2     85/03/12  */

#include "../h/ptyio.h"

#define	TRUE		1	
#define	FALSE		0	
#define	TRAPTERMIO	1
#define	TRAPRW		0
#define	PSEL_COLL	1		/* Select Collision Flag */

struct pty_select {
	struct proc *pty_selp;
	short pty_selflag;
};

struct pty_info {
	struct pty_select pty_selr;
	struct pty_select pty_selw;
	struct pty_select pty_sele;
	char exclusive;			/* ptm is being used exclusively */
	char ptmsleep;			/* ptm is asleep waiting for data
					   to read */
	struct proc *u_procp;		/* Pointer to ptm proc */
	char trapbusy;			/* pts is busy trapping an
					   ioctl/open/close */
	char trapwait;			/* pts is sleeping waiting for turn
					   to trap ioctl/open/close */
	char trapcomplete;		/* pts is sleeping, waiting for ptm to 
					   read trapped ioctl/open/close */
	char tioctrap;			/* Tell ptm about open, close, ioctl */
	char tiocsigmode;		/* signal handling mode */
	char tioctty;			/* termio processing enable */
	char tiocpkt;			/* TIOCPKT enabled */
	char tiocmonitor;		/* TIOCMONITOR enabled */
	char tiocremote;		/* TIOCREMOTE enabled */
	unsigned char pktbyte;		/* TIOCPKT byte value */
	char sendpktbyte;		/* Flag TIOCPKT byte to be sent */
	struct request_info r_info;
	char ioctl_buf[EFFECTIVE_IOCPARM_MASK+1]; /* buffer to hold pts ioctl */
};

