/* HPUX_ID: @(#)proc.h	27.4		85/10/16 */

#include <machine/pte.h>

/*
 * One structure allocated per active
 * process. It contains all data needed
 * about the process while the
 * process may be swapped out.
 * Other per process data (user.h)
 * is swapped with the process.
 */
struct	proc {
	struct	proc *p_link;	/* linked list of running processes */
	struct	proc *p_rlink;
	u_char	p_usrpri;	/* user-priority based on p_cpu and p_nice */
	u_char	p_pri;		/* priority, lower numbers are higher pri */
	u_char  p_rtpri;        /* real time priority */
	char	p_cpu;		/* cpu usage for scheduling */
	char	p_stat;
	char	p_nice;		/* nice for cpu usage */
	char	p_cursig;
	int	p_sig;		/* signals pending to this process */
	int	p_sigmask;	/* current signal mask */
	int	p_sigignore;	/* signals being ignored */
	int	p_sigcatch;	/* signals being caught by user */
	int	p_flag; 
	u_short	p_uid;		/* user id, used to direct tty signals */
	u_short	p_suid;		/* set (effective) uid */
	short	p_pgrp;		/* name of process group leader */
	short	p_pid;		/* unique process id */
	short	p_ppid;		/* process id of parent */
	caddr_t p_wchan;	/* event process is awaiting */
	size_t 	p_rssize; 	/* current resident set size in clicks */
	size_t	p_maxrss;	/* copy of u.u_limit[MAXRSS] */
	short	p_cpticks;	/* ticks of cpu time */
	float	p_pctcpu;	/* %cpu for this process during p_time */
	short	p_idhash;	/* hashed based on p_pid for kill+exit+... */
	struct	proc *p_pptr;	/* pointer to process structure of parent */
	struct	proc *p_cptr;	/* pointer to youngest living child */
	struct	proc *p_osptr;	/* pointer to older sibling processes */
	struct	proc *p_ysptr;	/* pointer to younger siblings */

    union {

      /* variant for zombie processes (p_stat == SZOMB) */
      struct {
	u_short	ZP_xstat;	/* Exit status for wait */
	struct	rusage ZP_ru;	/* mbuf holding exit information */
      } p_zombie;

      /* variant for non-zombie processes (p_stat != SZOMB) */
      struct {
	struct	pte *P_addr;	/* u-area kernel map address */
	char	P_time;		/* resident time for scheduling */
	char	P_slptime;	/* time since last block */
	short	P_poip;		/* page outs in progress */
	short	P_szp0pt;
	short	P_szp1pt;
	short	P_ndx;		/* proc index for memall (because of vfork) */
	size_t	P_tsize;	/* size of text (clicks) */
	size_t	P_dsize;	/* size of data space (clicks) */
	size_t	P_ssize;	/* copy of stack size (clicks) */
	size_t	P_swrss;	/* resident set size before last swap */
	swblk_t	P_swaddr;	/* disk address of u area when swapped */
	struct	text *P_textp;	/* pointer to text structure */
	struct	pte *P_p0br;	/* page table base P0BR */
	struct	proc *P_xlink;	/* linked list of procs sharing same text */
	struct	itimerval P_realtimer;
	struct	quota *P_quota;	/* quotas for this process */
	union {
		unsigned short *P_ummsegptr;   /* umm segment table pointer */
		struct ste *P_woprsegptr;  /* physical segment table pointer */
	} p_segment;
	union {
		unsigned short *P_ummlsegptr; /*logical segment table pointer*/
		struct ste *P_woprlsegptr; /* logical segment table pointer */
	} p_lsegment;

	int     P_smbeg;        /* beginning segment for shm */
	int     P_smend;        /* ending segment for shm */
      } p_normal;
    }	p_union;
};

#define	zp_xstat	p_union.p_zombie.ZP_xstat
#define	zp_ru		p_union.p_zombie.ZP_ru

#define	p_addr		p_union.p_normal.P_addr
#define	p_time		p_union.p_normal.P_time
#define	p_slptime	p_union.p_normal.P_slptime
#define	p_poip		p_union.p_normal.P_poip
/* UMM alias */
#define	p_szp0pt	p_union.p_normal.P_szp0pt
#define	p_szp1pt	p_union.p_normal.P_szp1pt
/* WOPR alias */
#define	p_szpt		p_union.p_normal.P_szp0pt
#define	p_ndx		p_union.p_normal.P_ndx
#define	p_tsize		p_union.p_normal.P_tsize
#define	p_dsize		p_union.p_normal.P_dsize
#define	p_ssize		p_union.p_normal.P_ssize
#define	p_swrss		p_union.p_normal.P_swrss
#define	p_swaddr	p_union.p_normal.P_swaddr
#define	p_textp		p_union.p_normal.P_textp
#define	p_p0br		p_union.p_normal.P_p0br
#define	p_xlink		p_union.p_normal.P_xlink
#define	p_realtimer	p_union.p_normal.P_realtimer
#define	p_quota		p_union.p_normal.P_quota
#ifdef	UMM
#define	p_segptr	p_union.p_normal.p_segment.P_ummsegptr
#define	p_lsegptr	p_union.p_normal.p_lsegment.P_ummlsegptr
#else	WOPR
#define	p_segptr	p_union.p_normal.p_segment.P_woprsegptr
#define	p_lsegptr	p_union.p_normal.p_lsegment.P_woprlsegptr
#endif	UMM/WOPR
#define	p_smbeg		p_union.p_normal.P_smbeg
#define	p_smend		p_union.p_normal.P_smend

#define	PIDHSZ		63
#define	PIDHASH(pid)	((pid) % PIDHSZ)


/* stat codes */
#define	SSLEEP	1		/* awaiting an event */
#define	SWAIT	2		/* (abandoned state) */
#define	SRUN	3		/* running */
#define	SIDL	4		/* intermediate state in process creation */
#define	SZOMB	5		/* intermediate state in process termination */
#define	SSTOP	6		/* process being traced */

/* flag codes (p_flag) */
#define	SLOAD	0x00000001	/* in core */
#define	SSYS	0x00000002	/* swapper or pager process */
#define	SLOCK	0x00000004	/* process being swapped out */
#define	SSWAP	0x00000008	/* save area flag */
#define	STRC	0x00000010	/* process is being traced */
#define	SWTED	0x00000020	/* another tracing flag */
#define	SULOCK	0x00000040	/* user settable lock in core */
#define	SPAGE	0x00000080	/* process in page wait state */
#define	SKEEP	0x00000100	/* another flag to prevent swap out */
#define	SOMASK	0x00000200	/* restore old mask after taking signal */
#define	SWEXIT	0x00000400	/* working on exiting */
#define	SPHYSIO	0x00000800	/* doing physical i/o (bio.c) */
#define	SVFORK	0x00001000	/* process resulted from vfork() */
#define	SVFDONE	0x00002000	/* another vfork flag */
#define	SNOVM	0x00004000	/* no vm, parent in a vfork() */
#define	SPAGI	0x00008000	/* init data space on demand, from inode */
#define	SSEQL	0x00010000	/* user warned of sequential vm behavior */
#define	SUANOM	0x00020000	/* user warned of random vm behavior */
#define	SDATLOCK 0x00040000	/* process is data locked */
 /* was STIMO (timing out during sleep) */ /* was SDETACH */
#define	SOUSIG	0x00100000	/* using old signal mechanism */
#define	SOWEUPC	0x00200000	/* owe process an addupc() call at next ast */
#define	SSEL	0x00400000	/* selecting; wakeup/waiting danger */
#define	STXTLOCK 0x00800000	/* process is text locked */
 /* was SLOGIN (a login process, which is a legit child of init) */
#define	SPTECHG	0x01000000	/* pte's for process have changed */
#define	SPROBE	0x02000000	/* probe simulation in progress */
#define SRTPROC 0x04000000	/* real time processes */
#define SSIGABL 0x08000000	/* signalable process */
#define SPRIV	0x10000000	/* compute privilege mask */
