/* HPUX_ID: @(#)param.h	27.12		85/06/28 */
/*
 * Configuration Dependent Parameters (User Only)
 */

/*
 * Kernel Type Declarations
 */
#include <sys/types.h>
#include <machine/param.h>

#define	NPTEPG		(NBPG/(sizeof (struct pte)))
/*
 * Machine-independent constants
 */
#define	MSWAPX	15		/* pseudo mount table index for swapdev */

#define	NOFILE	60		/* max open files per process */

#define	MAXPID	30000		/* max process id */
#define	MAXUID	60000		/* max user id */
#define	MAXLINK	1000


#define SSIZE   2               /* initial stack size/NBPG */
#define SINCR   2               /* increment of stack/NBPG */

/*
 * USRTEXT is the start of the user text/data space, while USRSTACK
 * is the top (end) of the user stack.  LOWPAGES and HIGHPAGES are
 * the number of pages from the beginning of the P0 region to the
 * beginning of the text and from the beginning of the P1 region to the
 * beginning of the stack respectively.
 */

#define	USRTEXT		0
#define	LOWPAGES	0
#define	P1PAGES		8192    	/* number of pages in P1 region 
					   max number of pages for 68010 
					   SEE LOCORE.S if you change this */

#define	UPAGES_M320	3		/* pages of u-area */
#define	FLOAT_M320	5		/* pages of float card area */
#define	HIGHPAGES_M320	(UPAGES_M320+FLOAT_M320)
#define	USRSTACK_M320 	(caddr_t) (-(HIGHPAGES_M320*NBPG_M320))
#define	USER_AREA_M320 	(USRSTACK_M320)	
#define	FLOAT_AREA_M320 (USRSTACK_M320+UPAGES_M320*NBPG_M320)	

#define	UPAGES_WOPR	UPAGES_M320
#define	FLOAT_WOPR	FLOAT_M320
#define	HIGHPAGES_WOPR	HIGHPAGES_M320
#define	USRSTACK_WOPR	USRSTACK_M320
#define	USER_AREA_WOPR	USER_AREA_M320
#define	FLOAT_AREA_WOPR	FLOAT_AREA_M320

#define	USRSTACK_M310 	(caddr_t) (0x1000000-(HIGHPAGES_M320*NBPG_M320))
#define	USER_AREA_M310 	(USRSTACK_M310)	
#define	FLOAT_AREA_M310 (USRSTACK_M310+UPAGES_M320*NBPG_M320)	

#define	UPAGES_UMM	4		/* pages of u-area */
#define	FLOAT_UMM	10		/* pages of float card area */
#define	HIGHPAGES_UMM	(UPAGES_UMM+FLOAT_UMM)
#define	USRSTACK_UMM 	(caddr_t) (0x1000000-(HIGHPAGES_UMM*NBPG_UMM))
#define	USER_AREA_UMM 	(USRSTACK_UMM)	
#define	FLOAT_AREA_UMM	(USRSTACK_UMM+UPAGES_UMM*NBPG_UMM)	

/* The following terms are defined only if UMM or WOPR is defined */
#ifdef	WOPR
#define	UPAGES		UPAGES_M320		/* pages of u-area */
#define	FLOAT		FLOAT_M320		/* pages of float card area */
#define	HIGHPAGES	HIGHPAGES_M320
#define	USRSTACK 	USRSTACK_M320
#define	USER_AREA 	USER_AREA_M320
#define	FLOAT_AREA 	FLOAT_AREA_M320
#endif	WOPR

#ifdef	UMM
#define	UPAGES		UPAGES_UMM		/* pages of u-area */
#define	FLOAT		FLOAT_UMM		/* pages of float card area */
#define	HIGHPAGES	HIGHPAGES_UMM
#define	USRSTACK 	USRSTACK_UMM
#define	USER_AREA 	USER_AREA_UMM
#define	FLOAT_AREA 	FLOAT_AREA_UMM
#endif	UMM


#define	CANBSIZ	256		/* max size of typewriter line	*/

#define	HZ	50		/* Ticks/second of the clock (in kernel land) */

/*
 * Maximum values (in seconds) for alarms, interval timers, and timeouts
 */
#define	MAX_ALARM	((unsigned long)(0x7fffffff / HZ))
#define	MAX_VT_ALARM	((unsigned long)0xffffffff)
#define	MAX_PROF	((unsigned long)0xffffffff)

#define	NCARGS	10240		/* # characters in exec arglist */

/*
 * priorities
 * should not be altered too much
 */

#define	PMASK	0xff
#define	PCATCH	0x100

#define PRTBASE 0
#define PTIMESHARE 128

#define	PSWP	(0+PTIMESHARE)
#define	PINOD	(10+PTIMESHARE)
#define	PRIBIO	(20+PTIMESHARE)
#define	PRIUBA	(24+PTIMESHARE)
#define	PZERO	(25+PTIMESHARE)
#define	PPIPE	(26+PTIMESHARE)
#define	PWAIT	(30+PTIMESHARE)
#define	PLOCK	(35+PTIMESHARE)
#define	PSLEP	(40+PTIMESHARE)
#define	PUSER	(50+PTIMESHARE)
#define PIDLE   (127+PTIMESHARE)
#define	NZERO	20

/*
 * fundamental constants of the implementation--
 * cannot be changed easily
 */

#define	NBPW	sizeof(int)	/* number of bytes in an integer */
#define BSIZE   DEV_BSIZE
#define BSHIFT  DEV_BSHIFT

/*
 * NINDIR is the number of indirects in a file system block.
 */
#define	NINDIR(fs)	((fs)->fs_nindir)
/*
 * INOPB is the number of inodes in a secondary storage block.
 */
#define	INOPB(fs)	((fs)->fs_inopb)
#define INOPF(fs)       ((fs)->fs_inopb >> (fs)->fs_fragshift)
#ifndef NULL
#define	NULL	0
#endif
#define	CMASK	0		/* default mask for file creation */
#define	CDLIMIT	0x1FFFFFFF	/* default max write address */
#define	NODEV	(dev_t)(-1)
/* The root inode is the root of the file system.
 * Inode 0 can't be used for normal purposes and
 * historically bad blocks were linked to inode 1,
 * thus the root inode is 2. (inode 1 is no longer used for
 * this purpose, however numerous dump tapes make this
 * assumption, so we are stuck with it)
 * The lost+found directory is given the next available
 * inode when it is created by ``mkfs''.
 */
#define	ROOTINO		((ino_t)2)	/* i number of all roots */
#define LOSTFOUNDINO    (ROOTINO + 1)
#define	SUPERBOFF	512	/* byte offset of the super block */
#define	DIRSIZ	14		/* max characters per directory */
#define	NICINOD	100		/* number of superblock inodes */
#define USERMODE(ps)    (((ps) & PS_S) == 0)  /* check for user mode */
#define BASEPRI(ps)     (((ps) & PS_IPL) == 0)    /* check for int level 0 */


#define	NGROUPS	20		/* max number groups */
#define	NOGROUP	-1		/* marker for empty group set member */
/*
 * Signals
 */

#define	ISSIG(p) \
	((p)->p_sig && ((p)->p_flag&STRC || \
	 ((p)->p_sig &~ (p)->p_sigmask)) && issig())

#ifndef NBBY
#define	NBBY	8		/* number of bits in a byte */
 				/* NOTE: this is also defined	*/
 				/* in fs.h (filsys.h).  So if	*/
 				/* NBBY gets changed, change it	*/
 				/* in fs.h (filsys.h) also	*/
#endif NBBY

/*
 * Clustering of hardware pages on machines with ridiculously small
 * page sizes is done here.  The paging subsystem deals with units of
 * CLSIZE pte's describing NBPG (from vm.h) pages each... BSIZE must
 * be CLSIZE*NBPG in the current implementation, that is the paging subsystem
 * deals with the same size blocks that the file system uses.
 *
 * NOTE: SSIZE, SINCR and UPAGES must be multiples of CLSIZE
 */
#define	CLBYTES		(CLSIZE*NBPG)
#define	CLOFSET		(CLSIZE*NBPG-1)	/* for clusters, like PGOFSET */
#define	claligned(x)	((((int)(x))&CLOFSET)==0)
#define	CLOFF		CLOFSET
#define	CLSHIFT		(PGSHIFT+CLSIZELOG2)

#if CLSIZE==1
#define	clbase(i)	(i)
#define	clrnd(i)	(i)
#else
/* give the base virtual address (first of CLSIZE) */
#define	clbase(i)	((i) &~ (CLSIZE-1))
/* round a number of clicks up to a whole cluster */
#define	clrnd(i)	(((i) + (CLSIZE-1)) &~ (CLSIZE-1))
#endif CLSIZE=1

/* macros replacing interleaving functions */
#define	dkblock(bp)	((bp)->b_blkno)
#define	dkunit(bp)	(minor((bp)->b_dev) >> 3)

/*
 * File system parameters and macros.
 *
 * The file system is made out of blocks of at most MAXBSIZE units,
 * with smaller units (fragments) only in the last direct block.
 * MAXBSIZE primarily determines the size of buffers in the buffer
 * pool. It may be made larger without any effect on existing
 * file systems; however making it smaller make make some file
 * systems unmountable.
 *
 * Note that the blocked devices are assumed to have DEV_BSIZE
 * "sectors" and that fragments must be some multiple of this size.
 * Block devices are read in BLKDEV_IOSIZE units. This number must
 * be a power of two and in the range of
 *	DEV_BSIZE <= BLKDEV_IOSIZE <= MAXBSIZE
 * This size has no effect upon the file system, but is usually set
 * to the block size of the root file system, so as to maximize the
 * speed of ``fsck''.
 */
#define	MAXBSIZE	8192
#define	DEV_BSIZE	1024
#define	DEV_BSHIFT	10      	/* log2(DEV_BSIZE) */
#define BLKDEV_IOSIZE	2048

#define	btodb(bytes)	 		/* calculates (bytes / DEV_BSIZE) */ \
	((unsigned)(bytes) >> DEV_BSHIFT)
#define	dbtob(db)			/* calculates (db * DEV_BSIZE) */ \
	((unsigned)(db) << DEV_BSHIFT)

/*
 * Map a ``block device block'' to a file system block.
 * This should be device dependent, and will be after we
 * add an entry to cdevsw for that purpose.  For now though
 * just use DEV_BSIZE.
 */
#define	bdbtofsb(bn)	((bn) / (BLKDEV_IOSIZE/DEV_BSIZE))

/*
 * MAXPATHLEN defines the longest permissable path length
 * after expanding symbolic links. It is used to allocate
 * a temporary buffer from the buffer pool in which to do the
 * name expansion, hence should be a power of two, and must
 * be less than or equal to MAXBSIZE.
 * MAXSYMLINKS defines the maximum number of symbolic links
 * that may be expanded in a path name. It should be set high
 * enough to allow all legitimate uses, but halt infinite loops
 * reasonably quickly.
 */
#define MAXPATHLEN	1024
#define MAXSYMLINKS	8

/*
 * bit map related macros
 */
#define	setbit(a,i)	((a)[(i)/NBBY] |= 1<<((i)%NBBY))
#define	clrbit(a,i)	((a)[(i)/NBBY] &= ~(1<<((i)%NBBY)))
#define	isset(a,i)	((a)[(i)/NBBY] & (1<<((i)%NBBY)))
#define	isclr(a,i)	(((a)[(i)/NBBY] & (1<<((i)%NBBY))) == 0)

/*
 * Macros for fast min/max.
 */
#define	MIN(a,b) (((a)<(b))?(a):(b))
#define	MAX(a,b) (((a)>(b))?(a):(b))

/*
 * Macros for counting and rounding.
 */
#define	howmany(x, y)	(((x)+((y)-1))/(y))
#define	roundup(x, y)	((((x)+((y)-1))/(y))*(y))

#define NMOUNT  20

