/* HPUX_ID: @(#)ite.h	27.3     85/06/27  */

/*
 (ITE) Internal Terminal Emulator header file
 */

#define DIO_START	(0x560000)

/* 2622 terminal emulation defines */

#define	HARD	1	/* hard (power on) reset */
#define	SOFT	2	/* soft reset */

#define	FORCE	1	/* Force new labels */

#define	FORWARD     1	/* tab forward */
#define	BACKWARD    2	/* back tab */

#define	TRUE	1
#define	FALSE	0
#define UP	1
#define DOWN	0

#define	USER		1
#define	AIDS		2
#define	CLEAR		3
#define MODES		4
#define	MARGINS		5
#define	CONFIG		6
#define	TCONFIG		7
#define	DCONFIG		8
#define	SERVICE		9
#define	SET_USER	10
#define	FLEXDISC	11

/* console state flags */
#define	ALPHAON		0x01	/* State of top section of display */
#define	NOT_9826	0x02
#define SFK_ON		0x04	/* State of bottom section of display */
#define	COLOR		0x08	/* if color top present */
#define	GATORAID	0x10	/* Gatoraid present flag */
#define FONT_STYLE	0x20	/* 8 by 16 font if set else 12 by 15 */
#define BIT_MAPPED	0x40	/* Bit mapped top present */
#define KANA8		0x80	/* use kana8 charactor set */

#define SCROLL		short

struct	iterminal	{
	int	scroll_lines;		/* number of lines in scroll buffer */
	SCROLL	*scroll_buf;		/* start address of scroll buf */
	int	(*crt_write)();		/* pointer to crt write routine */
	int	(*crt_cursor)();	/* pointer to crt cursor routine */
	int	(*crt_scroll)();	/* pointer to crt scroll routine */
	int	(*crt_clear)();		/* pointer to crt clear routine */
	int	(*crt_reset)();		/* pointer to crt reset routine */
	int	(*crt_set_st)();	/* pointer to crt junk routine */
	unsigned char 	*frame_start;	/* start of frame buffer for crt */
	unsigned char 	*font1_start;	/* start of roman8 font */
	unsigned char 	*font2_start;	/* start of 2nd half of kana8 font */
	int	font_width;		/* pixels per column of font */
	int	font_height;		/* pixels per row of font */
	int	font_line;		/* pixels per charactor line for font */

	int	top_line;		/* First line in Top of Full Scroller Memory */
	int	start_line;		/* Next Empty Scroller line Top of CRT Image*/
	int	crt_stop_line;		/* Next Empty CRT Slot for Bottom of CRT Image*/
	int	bottom_line;		/* Next Empty Scroller line for Bottom of Full*/
	int	first_line;		/* First absolute line on the screen */
	int	last_line;		/* Last absolute line in the scroller */

	int	select;			/* Index into Terminal Configuration */
	int	sx;			/* Index into Configuration String */
	char	dsp_funcs;		/* Save of Terminal Configure Display funcs */
	char	flds;			/* Field separator */
	char	blkt;			/* Block terminator */
	char	retdef[2];		/* Return definition */

	char	disp_funcs;
	char	local_echo;
	char	xmit_fnctn;
	char	remote_mode;
	char	insert_mode;
	char	autolf_mode;
	char	escape;
	char	scroll_lock;
	char	inheolwrp;
	char	c_mode;
	char	flags;
	char	cursor_on;
	char	plane_mask;

	int  	screenwidth;	        /* number of columns */
	int	screenheight;		/* number of rows */
	int	screensize;		/* size of the display in bytes */
	int	maxx, maxy;		/* maximum row, column */
	int	xpos, ypos;		/* row, column on crt during scroll */
	int	cxpos, cypos;		/* row, column on crt during configure*/
	int	oldx, oldy, coldx, coldy;
	char    tabstops[129];		/* tab stop settings */
	char	key_state;		/* State of f1 thru f8 */
	char	last_labels;		/* State of f1 thru f8 previous to going
					** to a configure mode */
	char	pstate;			/* State of parser */
	int	pint1;			/* Temporary for parser */
	int	pint2;
};

/* miscellaneous macros */
#define	ITE_TTY	ite_tty

/* ASCII character defines */
#define	FF	0x0c
#define	US	0x1f
#define	LF	0x0a
#define	CR	0x0d
#define	FS	0x1c
#define	BS	0x08
#define	TAB	0x09
#define	RING	0x07
#define	ESCAPE	0x1b
#define	DEL	0x7f
#define	NUL	0x00

/* Number of Parameters in Action */
#define scroll_params(x)	((x&0xF000)>>12)
/* Scroller Action */
#define	scroll_action(x)	(x&0x0FFF)

#define	SET_CURSOR	0x2001	/* set_cursor(x,y) */
#define SCROLL_UP	0x0002	/* scroll_up(start_row) */
#define SCROLL_DOWN	0x0003	/* scroll_down(start_row) */
#define	CLEAR_LINE	0x0004	/* clear_line() */
#define CURSOR_DOWN	0x0005	/* cursor_down() */
#define CURSOR_UP	0x0006	/* cursor_up() */
#define	CURSOR_LEFT	0x0007	/* cursor_left() */
#define	CURSOR_RIGHT	0x0008	/* cursor_right() */
#define	INSERT		0x0009	/* insert() */
#define	DELETE		0x000A	/* delete() */
#define	TAB_DIR		0x100B	/* tab(direction) */
#define	SET_TAB		0x000C	/* set_tab() */
#define	CLEAR_TAB	0x000D	/* clear_tab() */
#define	CLEAR_ALL_TABS	0x000E	/* clear_all_tabs() */
#define	ALPHA_ON	0x000F	/* alpha_on() */
#define	ALPHA_OFF	0x0010	/* alpha_off() */
#define	SFK_INPUT	0x1011	/* sfk_input(key) */
#define	DSP_LABELS	0x2012	/* display_labels(mode,force) */
#define SET_CRT_START	0x0013	/* set_crt_start() */
#define	IND_OVERRUN	0x0014	/* Indicate display scroller overrun */
#define DELETE_LINE	0x1015	/* delete_line(start_row) */
#define INSERT_LINE	0x1016	/* insert_line(start_row) */
#define	ROLL_UP		0x0017	/* roll_up() */
#define	ROLL_DOWN	0x0018	/* roll_down() */
#define LF_CURSOR_DOWN	0x0019	/* lf_cursor_down() */
#define	DOWN_ARROW	0x001A	/* down_arrow() */
#define	UP_ARROW	0x001B	/* up_arrow() */
#define	PREV_PAGE	0x001C	/* prev_page() */
#define	NEXT_PAGE	0x001D	/* next_page() */
#define	AUTOLF		0x101E	/* autolf(state) */
#define	DISP_FUNCS	0x101F	/* disp_funcs(state) */
#define	REMOTE		0x1020	/* remote(state) */
#define	HOME_DOWN	0x0021	/* home_down() */
#define	HOME_UP		0x0022	/* home_up() */
#define	INSERT_MODE	0x1023	/* insert_mode(state) */
#define	CLEAR_SCREEN	0x0024	/* clear_screen() */
#define	ABS_CURSOR	0x2025	/* abs_cursor(x,y) */
#define	ENHANCE		0x1026	/* set_enhance(type) */
#define	LEFTDRIVE	0x1027	/* set_leftdrive(string) */
#define	RIGHTDRIVE	0x1028	/* set_rightdrive(string) */
#define	COLORPAIR	0x1029	/* select_colorpair(num) */
#define	PLANE_MASK	0x102A	/* plane_mask(mask) */
#define	SCREEN_START	0x102B	/* screen_start(linenum) */
#define	REDRAW		0x002A	/* redraw_screen() */
#define	ALPHA_OFF_FULL	0x002B	/* alpha_off_full() */
#define	HARD_RESET	0x002C	/* term_reset(HARD) */
#define SOFT_RESET	0x002D	/* term_reset(SOFT) */
#define	WAIT_SEC	0x002E	/* wait_one_second() */
#define	REENTER		0x002F	/* reenter scroller after a wait one second */
#define	ABS_SENSE	0x0030	/* return absolute cursor address */
#define	REL_SENSE	0x0031	/* return relative cursor address */
#define	SCR_BACKSPACE	0x0032	/* backspace() */

/* SOFTKEY definitions */
#define NUMBER_OF_SFKS	8	/* number of soft keys             */
#define	LABEL_SIZE 	8	/* label size for 80 column screen */

#define	BLACK	0
#define	WHITE	1
#define	RED	2
#define	YELLOW	3
#define	GREEN	4
#define	CYAN	5
#define	BLUE	6
#define	MAGENTA	7

#define	RGB	0
#define	HSL	1

/* define foreground and background index into array */
#define BG	1
#define FG	0

/* define the by 4 replication of colors in bmap_colors array */
#define		FBLACK		(BLACK|BLACK<<8|BLACK<<16|BLACK<<24)
#define		FWHITE		(WHITE|WHITE<<8|WHITE<<16|WHITE<<24)
#define		FRED		(RED|RED<<8|RED<<16|RED<<24)
#define		FYELLOW		(YELLOW|YELLOW<<8|YELLOW<<16|YELLOW<<24)
#define		FGREEN		(GREEN|GREEN<<8|GREEN<<16|GREEN<<24)
#define		FCYAN		(CYAN|CYAN<<8|CYAN<<16|CYAN<<24)
#define		FBLUE		(BLUE|BLUE<<8|BLUE<<16|BLUE<<24)
#define		FMAGENTA	(MAGENTA|MAGENTA<<8|MAGENTA<<16|MAGENTA<<24)

/* Fields in scroller memory entry */
#define	CHAR_VAL	0xFF		/* 8 bits for character value */
#define	CHAR_ENHANCE	0x300		/* 2 bits for enhancement value */
#define		HALF_BRIGHT	0x000		/* half bright bit */
#define		UNDERLINE	0x200		/* underline bit */
#define		BLINKING	0x000		/* blinking bit */
#define		INVERSE_VIDEO	0x100		/* inverse video bit */
#define	CHAR_ON		0x400		/* Enable all character features */
#define	CHAR_ENSTART	0x800		/* Start a new display enhancement */
#define	CHAR_CPAIR	0x7000		/* 3 bits for color pair number */
#define	CHAR_CPAIRSTART	0x8000	/* Start a new color pair number */
#define CPAIR_SFT	(12)	/* shift number for color pair position */
