/* HPUX_ID: @(#)ioctl.h	27.4     85/06/27  */
/*
 * Ioctl definitions
 */
#ifndef _IO
/*
 * Ioctl's have the command encoded in the lower word,
 * and the size of any in or out parameters in the upper
 * word.  The high 2 bits of the upper word are used
 * to encode the in/out status of the parameter.
 */
#define	IOCSIZE_MASK	0x3fff0000	/* Field which has ioctl size */
#define	IOCPARM_MASK	(IOCSIZE_MASK>>16) /* parameters must be < 16K bytes */
/* Since our implementation statically allocates space for ioctl parameters */
/* on a per-process basis and sometimes on a per-device basis, each ioctl   */
/* is limited to 128 bytes.                                                 */
#define	EFFECTIVE_IOCSIZE_MASK	0x7f0000
#define	EFFECTIVE_IOCPARM_MASK	(EFFECTIVE_IOCSIZE_MASK>>16)
#define	IOCCMD_MASK	0x0ffff		/* Command field */
#define	IOC_VOID	0x80000000	/* no parameters, field size = 0 */
#define	IOC_OUT		0x40000000	/* copy out parameters */
#define	IOC_IN		0x80000000	/* copy in parameters */
#define	IOC_INOUT	(IOC_IN|IOC_OUT)
#define	_IO(x,y)	(IOC_VOID|('x'<<8)|y)
#define	_IOR(x,y,t)	(IOC_OUT|((sizeof(t)&IOCPARM_MASK)<<16)|('x'<<8)|y)
#define	_IOW(x,y,t)	(IOC_IN|((sizeof(t)&IOCPARM_MASK)<<16)|('x'<<8)|y)
/* this should be _IORW, but stdio got there first */
#define	_IOWR(x,y,t)	(IOC_INOUT|((sizeof(t)&IOCPARM_MASK)<<16)|('x'<<8)|y)


#endif
