/* HPUX_ID: @(#)hpibio.h	27.3     85/06/27  */

#ifndef	TRUE
#define TRUE	   1
#define FALSE      0
#endif
        
/* card address constants */

#define IOSTART_ADDR	0x400000	/* start of I/O space    */
#define START_ADDR	0x600000	/* start for "other" cards    */
#define INTERNAL_CARD	0x478000	/* INTERNAL HPIB card address */


/* card id constants */
        
#define NO_ID            0
#define INTERNAL_HPIB    1
#define HP98624          2           /* hpib */
#define HP98626          3           /* serial */
#define HP98625          4           /* high-speed disk interface */
#define HP98627A         5           /* moon unit */
#define HP98628          6           /* hp98628 */
#define	HP98204A	 7	     /* 9920  graphics frame buffer */
#define	HP98204B	 8	     /* marbox graphics frame buffer */
#define	HP9826A		 9	     /* 9826a graphics frame buffer */
#define	HP9836A		10	     /* 9836a graphics frame buffer */
#define	HP9836C		11	     /* 9836c graphics frame buffer */
#define HP9837H		12	     /* GATOR graphics frame buffer */
#define HP98700		13	     /* GATORBOX graphics frame buffer */
#define HP98642         14           /* hp98642 */
#define HP98643         15           /* hp98643 */
#define HP98644         16           /* hp98644 */
#define HP98622         17           /* hp98622 */
#define BOBCAT          18           /* BOBCAT graphics frame buffer */
        
enum type_hpib_line    { REN_LINE, IFC_LINE, SRQ_LINE, EOI_LINE, NRFD_LINE,
			 NDAC_LINE, DAV_LINE, ATN_LINE };

/* transfer types */
enum TFR_type {NO_TFR, DMA_TFR, INTR_TFR, FHS_TFR, BURST_TFR, BO_END_TFR};

/* transfer requests */
enum transfer_request_type {MAX_OVERLAP, MAX_SPEED, MUST_FHS, MUST_INTR};

/* obtainable interrupts */
#define	INT_SRQ		0x01	/* requested SRQ interrupt */
#define	INT_PPL		0x02	/* requested parallel poll interrupt */

/* intr_wait info */
#define	INT_LADS	0x10	/* listen address interrupt */
#define	INT_TADS	0x20	/* talk address interrupt */

/* hp-ib addressing group bases */
#define	LAG_BASE   	0x20	 /*  listener address base */
#define	TAG_BASE   	0x40	 /*  talker address base */
#define	SCG_BASE   	0x60	 /*  secondary address base */

/* hp-ib command equates in odd parity */
#define	GTL         0x01	/*  go to local */
#define	SDC         0x04	/*  selective device clear */
#define	PPC         0x85	/*  ppoll configure */
#define	GET         0x08	/*  group execute trigger */
#define	TCT         0x89	/*  take control */
#define	LLO         0x91	/*  local lockout */
#define	DCL         0x94	/*  device clear */
#define	PPU         0x15	/*  ppoll unconfigure */
#define	SPE         0x98	/*  spoll enable */
#define	SPD         0x19	/*  spoll disable */
#define	UNL         0xbf	/*  unlisten */
#define	UNT         0xdf	/*  untalk */

#define RSV_MASK    0x40	 /* SRQ is set by this guy (in spoll byte) */

/* driver declarations */
struct drv_table_type {
	int (*iod_init)();
	int (*iod_ident)();
	int (*iod_clear_wopp)();
	int (*iod_clear)();
	int (*iod_ifc)();
	int (*iod_isr)();
	int (*iod_tfr)();
	int (*iod_pplset)();
	int (*iod_pplclr)();
	int (*iod_ppoll)();
	int (*iod_spoll)();
	int (*iod_preamb)();
	int (*iod_postamb)();
	int (*iod_mesg)();
	int (*iod_hst)();
	int (*iod_abort)();
};

/* this is a copy of the tty_driver in tty.h */
struct tty_drivercp {
	int	type;			/* Driver Number */
	int	(*open)();		/* open(dev, tp, flag) */
	int	(*close)();		/* close(dev, tp) */
	int	(*read)();		/* read(tp) */
	int	(*write)();		/* write(tp) */
	int	(*ioctl)();		/* ioctl(dev, tp, cmd, arg, mode) */
	int	(*select)();		/* select(tp) */
	int	(*kputchar)();		/* putchar(c); */
	int	(*wait)();		/* wait(tp); */
	int	(*pwr_init)();	/* pwr_init(&tp, addr, id, il, &cs,
						&pci_total); */
	int	(*who_init)();		/* who_init(tp, tty_number, sc)
						For console tty_number == -1 */
	struct tty_drivercp *next;	/* Pointer to next one in list */
};

/*
**  interface driver space
*/
struct isc_table_type {
	struct buf *b_actf;
	struct buf *b_actl;
	struct buf *ppoll_f;	/* those waiting for ppoll */
	struct buf *ppoll_l;
	struct buf *spoll_f;	/* those waiting for spoll */
	struct buf *spoll_l;
	unsigned short state;
	char card_type;
	char my_isc;
	char my_address;
	char active;
	char int_lvl;
	unsigned char spoll_byte;
	enum TFR_type transfer;
	struct drv_table_type *iosw;
	struct tty_drivercp *tty_routine;	/* for tty's selectcodes */
	int *card_ptr;
	unsigned short intcopy;
	unsigned short intmsksav;
	unsigned short intmskcpy;
	struct dma_channel *dma_chan;
	short dma_reserved;		/* dma not to be locked by another sc */
	short dma_active;		/* sc hopes to use dma */
	unsigned char int_flags;
	unsigned char int_enabled;
	struct buf *owner;
 	char ppoll_flag;		/* info for ti9914 ppoll requests */
 	unsigned char ppoll_mask;
 	unsigned char ppoll_sense;
	unsigned char tfr_control;	/* DIL transfer type and term reason */
 	unsigned short ppoll_resp;	/* ppoll response */
	unsigned short pattern; 	/* pattern for transfer termination */
 	int resid;
 	caddr_t buffer;			/* transfer information */
 	int count;
	struct sw_intloc intloc;	/* for software triggers */
	int lock_count;			/* those waiting to lock the bus */
	int intr_wait;			/* interrupt waiting conditions */
	int (*dil_isr)();		/* so dil drivers can handle events */
	int mapped;			/* keep a copy of the mapped in address */
};

/* flags for state above */
#define F_EOI			0x0001
#define F_WORD_DMA		0x0002	/* flag to dma_build_chain */
#define F_PRIORITY_DMA		0x0004	/* flag to dma_build_chain */
#define F_SIMONB		0x0008	/* flag to dma_build_chain */
#define LOCKED			0x0010
#define TI_PPOLL		0x0020
#define ACTIVE_CONTROLLER	0x0040
#define SYSTEM_CONTROLLER	0x0080
#define IST			0x0100	/* for ppoll response */
#define STATE_SAVED		0x0200
#define BOBCAT_HPIB		0x0400
#define IN_HOLDOFF		0x0800


#define MINISC  	 0
#define EXTERNALISC	32
#define MAXISC		63

/*
**  isc_table no longer includes "internal space" psuedo select codes 32-63!
*/
struct isc_table_type *isc_table[EXTERNALISC];

/* message IO flags */
#define T_WRITE		0x1
#define T_EOI		0x2
#define T_PPL		0x4

#define	TIMED_OUT	2	/* escape value */

#define START_POLL	{						\
			bp->b_queue->markstack = (int (**)())get_sp();	\
			if (bp->b_queue->timeflag) {			\
				bp->b_queue->timeflag = FALSE;		\
				escape(TIMED_OUT);			\
			}						\
			}

#define END_POLL	{						\
			bp->b_queue->markstack = NULL;			\
			}

/* temporary, till we get it right */
#define SWAP_BASE 2000
