/* HPUX_ID: @(#)hilioctl.h	27.2     85/05/21  */
#include "sys/ioctl.h"

struct eft2 {
	unsigned char b[2];
};
struct eft4 {
	unsigned char b[4];
};
struct eft5 {
	unsigned char b[5];
};

#define EFTRIUR _IOR(H,0x02,char)	/* Read the in use register. */
#define EFTRIM  _IOR(H,0x04,char)	/* Read the interrupt mask. */
#define EFTRKS  _IOR(H,0x05,char)	/* Read the keyboard status register. */
#define EFTRCC  _IOR(H,0x11,char)	/* Read the configuration code. */
#define EFTRLC  _IOR(H,0x12,char)	/* Read the language code. */
#define EFTRRT  _IOR(H,0x31,struct eft5)/* Read the real time. */
#define EFTSIM  _IOW(H,0x40,char)	/* Set the interrupt mask. */
#define EFTSRD  _IOW(H,0xa0,char)	/* Set the repeat delay. */
#define EFTSRR  _IOW(H,0xa2,char)	/* Set the repeat rate. */
#define EFTSBI  _IOW(H,0xa3,struct eft2)/* Set the bell information. */
#define EFTSRPG _IOW(H,0xa6,char)	/* Set rate at which RPG
                                              can interrupt. */
#define EFTSRT  _IOW(H,0xad,struct eft5)/* Set the real time. */
#define EFTSBP  _IOW(H,0xc4,struct eft4)/* Send data to the beeper. */
#define EFTSKBD _IOW(H,0xe9,char)	/* Set "cooked" keyboard mask. */
#define EFTSLPC _IOW(H,0xeb,char)	/* Set HIL interface control
                                              register. */
#define EFTRR0  _IOR(H,0xf0,struct eft4)/* Read general purpose data
                                              buffer. */
#define EFTRT   _IOR(H,0xf4,struct eft4)/* Read the timers for the
                                              four voices. */
#define EFTRKBD _IOR(H,0xf9,char)	/* Read "cooked" keyboard mask. */
#define EFTRLPS _IOR(H,0xfa,char)	/* Read HIL interface status
                                              register. */
#define EFTRLPC _IOR(H,0xfb,char)	/* Read HIL interface control
                                              register. */
#define EFTRREV _IOR(H,0xfe,char)	/* Read the 8042 REVID. */

struct hil11 {
	unsigned char b[11];
};
struct hil16 {
	unsigned char b[16];
};

#define HILID  _IOR(h,0x03,struct hil11)/* Identify and Describe */
#define HILPST _IOR(h,0x05,char)	/* Perform Self Test */
#define HILRR  _IOWR(h,0x06,char)	/* Read Register */
#define HILWR  _IOW(h,0x07,char)	/* Write Register */
#define HILRN  _IOR(h,0x30,struct hil16)/* Report Name */
#define HILRS  _IOR(h,0x31,struct hil16)/* Report Status */
#define HILED  _IOR(h,0x32,struct hil16)/* Extended Describe*/
#define HILSC  _IOR(h,0x33,struct hil16)/* Report Security Code */
#define HILDKR _IO(h,0x3d)		/* Disable Key Repeat */
#define HILER1 _IO(h,0x3e)		/* Enable Repeat, 1/30 */
#define HILER2 _IO(h,0x3f)		/* Enable Repeat, 1/60 */
#define HILP1  _IO(h,0x40)		/* Prompt 1 */
#define HILP2  _IO(h,0x41)		/* Prompt 2 */
#define HILP3  _IO(h,0x42)		/* Prompt 3 */
#define HILP4  _IO(h,0x43)		/* Prompt 4 */
#define HILP5  _IO(h,0x44)		/* Prompt 5 */
#define HILP6  _IO(h,0x45)		/* Prompt 6 */
#define HILP7  _IO(h,0x46)		/* Prompt 7 */
#define HILP   _IO(h,0x47)		/* Prompt */
#define HILA1  _IO(h,0x48)		/* Acknowledge 1 */
#define HILA2  _IO(h,0x49)		/* Acknowledge 2 */
#define HILA3  _IO(h,0x4a)		/* Acknowledge 3 */
#define HILA4  _IO(h,0x4b)		/* Acknowledge 4 */
#define HILA5  _IO(h,0x4c)		/* Acknowledge 5 */
#define HILA6  _IO(h,0x4d)		/* Acknowledge 6 */
#define HILA7  _IO(h,0x4e)		/* Acknowledge 7 */
#define HILA   _IO(h,0x4f)		/* Acknowledge */
